/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension;

import java.net.URI;
import java.util.Collection;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.net.VirtualFileSystem;

public abstract class ExtensionHook
extends ElementVisitor {
    public static final String KEY_EXTENSION = "extension";
    public static final String KEY_RSBUNDLE_CLASS = "rsbundleclass";
    private String _schemaLocation;
    private String _providerId;
    public static final String MANIFEST_XMLNS = "http://jcp.org/jsr/198/extension-manifest";

    public final void setProvider(String extensionId) {
        if (extensionId == null) {
            throw new NullPointerException("extensionId");
        }
        if (this._providerId != null) {
            throw new IllegalStateException("Provider is already set.");
        }
        this._providerId = extensionId;
    }

    public final String getProvider() {
        return this._providerId;
    }

    public final void setSchemaLocation(String schemaLocation) {
        this._schemaLocation = schemaLocation;
    }

    public final String getSchemaLocation() {
        return this._schemaLocation;
    }

    protected final String getRSBundleClass(ElementContext context) {
        return (String)context.getScopeData().get(KEY_RSBUNDLE_CLASS);
    }

    protected final Extension getExtension(ElementContext context) {
        return (Extension)context.getScopeData().get(KEY_EXTENSION);
    }

    protected final URI resolvePath(ElementContext context, String path) {
        if (path == null) {
            throw new NullPointerException("path is null");
        }
        ExtensionSource source = (ExtensionSource)context.getScopeData().get("extSource");
        Extension extension = (Extension)context.getScopeData().get(KEY_EXTENSION);
        return source.resolvePath(extension, path);
    }

    protected final URI findPath(ElementContext context, String path) {
        if (path == null) {
            throw new NullPointerException("path is null");
        }
        URI def = this.resolvePath(context, path);
        if (def != null && VirtualFileSystem.getVirtualFileSystem().exists(def)) {
            return def;
        }
        Extension extension = (Extension)context.getScopeData().get(KEY_EXTENSION);
        if (extension instanceof DefaultExtension) {
            DefaultExtension defaultExtension = (DefaultExtension)extension;
            Collection<String> deps = defaultExtension.getAllImportedExtensions(ExtensionRegistry.getExtensionRegistry());
            for (String dep : deps) {
                URI u;
                Extension e = ExtensionRegistry.getExtensionRegistry().findExtension(dep);
                if (e == null || !(e instanceof DefaultExtension) || (u = ((DefaultExtension)e).getSource().resolvePath(e, path)) == null || !VirtualFileSystem.getVirtualFileSystem().exists(u)) continue;
                return u;
            }
        }
        return null;
    }
}

