/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.Service;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.UnrecognizedElementException;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.DefaultHookVisitorFactory;
import javax.ide.extension.spi.DependencyTree;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.ExtensionVisitor;
import javax.ide.extension.spi.SAXManifestParser;
import javax.ide.spi.ProviderNotFoundException;
import javax.ide.util.Version;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class ExtensionRegistry
extends Service {
    private Map _extensions;
    private ElementVisitorFactory _hookFactory;
    private ExtensionVisitor _extensionVisitor;

    public final Extension findExtension(String id) {
        if (this._extensions == null) {
            return this._extensionVisitor.findExtension(id);
        }
        return (Extension)this._extensions.get(id);
    }

    public final Collection getExtensions() {
        return Collections.unmodifiableCollection(this._extensions.values());
    }

    public ExtensionHook getHook(ElementName hookElement) {
        if (hookElement == null) {
            throw new NullPointerException("Null hookElement");
        }
        try {
            ExtensionHook extensionHook = (ExtensionHook)this._hookFactory.getVisitor(hookElement);
            return extensionHook;
        }
        catch (UnrecognizedElementException ue) {
            ExtensionHook extensionHook = null;
            return extensionHook;
        }
    }

    protected abstract Collection findAllExtensionSources();

    protected ElementContext createInitialContext() {
        return new DefaultElementContext();
    }

    protected Collection loadExtensions() {
        Collection sources = this.findAllExtensionSources();
        ArrayList<ExtensionSource> validSources = new ArrayList<ExtensionSource>();
        for (ExtensionSource source : sources) {
            if (source.getManifestURI() == null) continue;
            validSources.add(source);
        }
        DependencyTree dt = DependencyTree.buildTree(validSources, new 1(), this.createExtensionLogger(), (DefaultElementContext)this.createInitialContext());
        ArrayList<ExtensionSource> orderedSources = new ArrayList<ExtensionSource>();
        for (String id : dt.getSortedExtensionIDs()) {
            orderedSources.add(dt.getSource(id));
        }
        Collection extensions = this.loadExtensions(orderedSources);
        Iterator i = dt.getCycles().iterator();
        while (i.hasNext()) {
            this.cycleEncountered((Collection)i.next());
        }
        for (Extension unsatisfied : dt.getUnsatisfiedExtensions()) {
            Collection deps = dt.getUnsatisfiedDependencies(unsatisfied);
            this.unsatisfiedExtensionDependencies(unsatisfied, deps);
        }
        return extensions;
    }

    protected boolean isExtensionEnabled(String id, Version version) {
        return true;
    }

    protected void cycleEncountered(Collection cycle) {
    }

    protected void unsatisfiedExtensionDependencies(Extension ext, Collection deps) {
    }

    protected Collection loadExtensions(Collection orderedSources) {
        if (this._hookFactory == null) {
            this._hookFactory = this.createHookVisitorFactory();
        }
        SAXManifestParser parser = new SAXManifestParser((DefaultElementContext)this.createInitialContext());
        Logger logger = this.createExtensionLogger();
        ((DefaultElementContext)parser.getContext()).setMessageReporter(logger);
        this._extensionVisitor = this.createExtensionVisitor(this._hookFactory);
        parser.getContext().registerChildVisitor(ExtensionVisitor.ELEMENT, this._extensionVisitor);
        for (ExtensionSource source : orderedSources) {
            this.loadExtension(parser, logger, source);
        }
        return this._extensionVisitor.getExtensions();
    }

    protected void loadExtension(SAXManifestParser parser, Logger logger, ExtensionSource source) {
        parser.getContext().getScopeData().put("extSource", source);
        URI uri = source.getManifestURI();
        InputStream inStream = null;
        try {
            try {
                inStream = source.getInputStream();
                InputSource inSource = new InputSource(inStream);
                inSource.setSystemId(uri.toString());
                parser.parse(inSource);
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, "Error loading manifest from " + source.getName(), ioe);
            }
            catch (ParserConfigurationException pce) {
                throw new IllegalStateException("Badly configured jaxb");
            }
            catch (SAXException saxe) {
                logger.log(Level.SEVERE, "Failed to parse manifest from " + source.getName(), saxe);
            }
            catch (RuntimeException re) {
                logger.log(Level.SEVERE, "RuntimeException parsing manifest from " + source.getName() + ": " + re, re);
            }
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, "Error closing stream for " + source.getName(), ioe);
            }
        }
    }

    protected Logger createExtensionLogger() {
        return Logger.getLogger(ExtensionRegistry.class.getName());
    }

    protected abstract ExtensionVisitor createExtensionVisitor(ElementVisitorFactory var1);

    protected void addToClassPath(ExtensionSource source) {
    }

    protected ElementVisitorFactory createHookVisitorFactory() {
        return new DefaultHookVisitorFactory();
    }

    protected void initialize() {
        Collection extensions = this.loadExtensions();
        this._extensions = new LinkedHashMap();
        for (Extension ext : extensions) {
            this._extensions.put(ext.getID(), ext);
        }
    }

    public static ExtensionRegistry getExtensionRegistry() {
        try {
            ExtensionRegistry extensionRegistry = (ExtensionRegistry)ExtensionRegistry.getService(ExtensionRegistry.class);
            return extensionRegistry;
        }
        catch (ProviderNotFoundException nse) {
            throw new IllegalStateException("No extension registry", nse);
        }
    }

    public abstract URI getInstallRoot(Extension var1);

    final class 1
    implements DependencyTree.EnabledExtensionLookup {
        public boolean isExtensionEnabled(Extension e) {
            return ExtensionRegistry.this.isExtensionEnabled(e.getID(), e.getVersion());
        }
    }
}

