/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;

public abstract class I18NStringVisitor
extends ElementVisitor {
    protected static final String KEY_RSKEY = "rskey";

    public void start(ElementStartContext start) {
        String rskey = start.getAttributeValue(KEY_RSKEY);
        if (rskey != null && (rskey = rskey.trim()).length() == 0) {
            rskey = null;
        }
        String rsBundleClass = (String)start.getScopeData().get("rsbundleclass");
        if (rskey != null && rsBundleClass == null) {
            this.log(start, Level.WARNING, "'rskey' used without 'rsbundle' on extension element.");
            rskey = null;
        }
        start.getScopeData().put(KEY_RSKEY, rskey);
    }

    public void end(ElementEndContext end) {
        String rskey = (String)end.getScopeData().get(KEY_RSKEY);
        String value = null;
        if (rskey != null) {
            try {
                value = this.lookupResource(end, rskey);
            }
            catch (MissingResourceException mre) {
                String bundleClass = (String)end.getScopeData().get("rsbundleclass");
                this.log(end, Level.WARNING, "Resource key '" + rskey + "' not found in bundle '" + bundleClass + "'.");
                value = null;
            }
        }
        if (value == null && (value = end.getText()) == null) {
            value = "";
        }
        this.string(end, value.trim());
    }

    private String lookupResource(ElementContext context, String key) {
        ResourceBundle bundle = ElementVisitor.getResourceBundle(context);
        if (bundle == null) {
            return "!MB!" + key;
        }
        return bundle.getString(key);
    }

    protected abstract void string(ElementContext var1, String var2);
}

