/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.SimpleGlobMatcher;
import javax.ide.net.VirtualFileSystem;
import javax.ide.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseExtensionVisitor
extends ElementVisitor {
    private static final Logger LOG = Logger.getLogger(BaseExtensionVisitor.class.getName());
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "extension");
    protected static final ElementName CLASSPATH_ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "classpath");
    static final ElementName HOOKS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "hooks");
    private ElementVisitor _hooksVisitor;
    private ElementVisitorFactory _hookVisitorFactory;
    public static final String KEY_EXTENSION_SOURCE = "extSource";
    private static final Version MAX_ESDK_VERSION = new Version("1.0");

    private void $init$() {
        this._hooksVisitor = this.createHooksVisitor();
    }

    protected DefaultExtension processExtension(ElementStartContext context) {
        Version parsedESDKVersion;
        Version parsedVersion;
        String id = context.getAttributeValue("id");
        if (id == null || (id = id.trim()) == "") {
            this.log(context, Level.SEVERE, "Missing required attribute 'id'");
            return null;
        }
        String version = context.getAttributeValue("version");
        if (version == null || (version = version.trim()) == "") {
            this.log(context, Level.SEVERE, "Missing required attribute 'version'");
            return null;
        }
        try {
            parsedVersion = new Version(version);
        }
        catch (NumberFormatException nfe) {
            this.log(context, Level.SEVERE, "Incorrectly formed version: " + version);
            DefaultExtension defaultExtension = null;
            return defaultExtension;
        }
        String esdkversion = context.getAttributeValue("esdk-version");
        if (esdkversion == null || (esdkversion = esdkversion.trim()) == "") {
            this.log(context, Level.SEVERE, "Missing required attribute 'esdk-version'");
            return null;
        }
        try {
            parsedESDKVersion = new Version(esdkversion);
        }
        catch (NumberFormatException nfe) {
            this.log(context, Level.SEVERE, "Incorrectly formed version: " + esdkversion);
            DefaultExtension defaultExtension = null;
            return defaultExtension;
        }
        if (parsedESDKVersion.compareTo(MAX_ESDK_VERSION) > 0) {
            this.log(context, Level.SEVERE, "ESDK version " + esdkversion + " is too high. Maximum supported version is " + MAX_ESDK_VERSION);
            return null;
        }
        DefaultExtension theExtension = new DefaultExtension(id);
        theExtension.setVersion(parsedVersion);
        theExtension.setEDKVersion(parsedESDKVersion);
        theExtension.setSource((ExtensionSource)context.getScopeData().get(KEY_EXTENSION_SOURCE));
        context.getScopeData().put("extension", theExtension);
        context.registerChildVisitor(HOOKS, this._hooksVisitor);
        return theExtension;
    }

    @Override
    public final void end(ElementEndContext end) {
        Extension extension = (Extension)end.getScopeData().get("extension");
        this.extension(end, extension);
        this.addExtensionSourceToClasspath(end);
    }

    protected void extension(ElementContext context, Extension extension) {
    }

    protected static final DefaultExtension getExtension(ElementContext context) {
        return (DefaultExtension)context.getScopeData().get("extension");
    }

    protected static final ExtensionSource getSource(ElementContext context) {
        return (ExtensionSource)context.getScopeData().get(KEY_EXTENSION_SOURCE);
    }

    protected abstract void addToClasspath(ElementContext var1, Extension var2, URI var3);

    protected final void setHookVisitorFactory(ElementVisitorFactory hookFactory) {
        this._hookVisitorFactory = hookFactory;
    }

    protected ElementVisitor createClasspathVisitor() {
        return new ClasspathVisitor();
    }

    public static final Collection<URI> matchWildcard(URI parent, String expression) {
        URI[] children = VirtualFileSystem.getVirtualFileSystem().list(parent);
        if (children == null) {
            return null;
        }
        ArrayList<URI> matching = new ArrayList<URI>();
        SimpleGlobMatcher matcher = new SimpleGlobMatcher(expression);
        URI[] uRIArray = children;
        int n = 0;
        while (n < uRIArray.length) {
            URI uri = uRIArray[n];
            String fileName = VirtualFileSystem.getVirtualFileSystem().getFileName(uri);
            if (fileName != null && matcher.matches(fileName)) {
                matching.add(uri);
            }
            ++n;
        }
        LOG.fine("Wildcard " + expression + " expanded to: " + matching);
        return matching;
    }

    protected ElementVisitor createHooksVisitor() {
        return new HooksVisitor(null);
    }

    protected void addExtensionSourceToClasspath(ElementContext context) {
        DefaultExtension extension = BaseExtensionVisitor.getExtension(context);
        ExtensionSource source = extension.getSource();
        LOG.fine("Adding source for " + extension.getID() + " to classpath: " + source.getClasspathEntry());
        this.addToClasspath(context, extension, source.getClasspathEntry());
    }

    public BaseExtensionVisitor() {
        this.$init$();
    }

    static Logger ra$LOG() {
        return LOG;
    }

    static ElementVisitorFactory ra$_hookVisitorFactory(BaseExtensionVisitor baseExtensionVisitor) {
        return baseExtensionVisitor._hookVisitorFactory;
    }

    public final class ClasspathsVisitor
    extends ElementVisitor {
        private final ElementVisitor _cpVisitor;

        private void $init$() {
            this._cpVisitor = BaseExtensionVisitor.this.createClasspathVisitor();
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(CLASSPATH_ELEMENT, this._cpVisitor);
        }

        public ClasspathsVisitor() {
            this.$init$();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClasspathVisitor
    extends ElementVisitor {
        protected URI getClasspathEntry(ElementEndContext context) {
            String text = context.getText().trim();
            if (text.length() == 0) {
                this.log(context, Level.WARNING, "Empty classpath definition");
                return null;
            }
            return this.resolveURI(context, text);
        }

        private URI resolveURI(ElementContext context, String text) {
            return BaseExtensionVisitor.getSource(context).resolvePath(BaseExtensionVisitor.getExtension(context), text);
        }

        protected boolean acceptClasspathEntry(ElementContext context, URI uri) {
            return true;
        }

        private Collection<URI> getClasspathEntries(ElementEndContext context) {
            String text = context.getText();
            if (text == null) {
                return null;
            }
            if ((text = text.trim()).length() == 0) {
                return null;
            }
            int posOfWildcard = -1;
            int posOfSeparator = -1;
            int i = text.length() - 1;
            while (i >= 0) {
                char c = text.charAt(i);
                if (c == '*') {
                    posOfWildcard = i;
                }
                if (c == '/') {
                    posOfSeparator = i;
                    break;
                }
                --i;
            }
            if (posOfWildcard == -1 || posOfSeparator == -1 || posOfSeparator == text.length() - 1) {
                return null;
            }
            BaseExtensionVisitor.ra$LOG().fine("Procesing wildcard classpath entry: " + text);
            String dirPath = text.substring(0, posOfSeparator);
            String glob = text.substring(posOfSeparator + 1);
            URI parentURI = this.resolveURI(context, dirPath);
            if (!VirtualFileSystem.getVirtualFileSystem().isDirectory(parentURI)) {
                BaseExtensionVisitor.ra$LOG().fine("Parent directory for wildcard entry does not exist: " + parentURI);
                return null;
            }
            return BaseExtensionVisitor.matchWildcard(parentURI, glob);
        }

        @Override
        public final void end(ElementEndContext context) {
            Collection<URI> allURIs = this.getClasspathEntries(context);
            if (allURIs == null) {
                URI singleEntry = this.getClasspathEntry(context);
                allURIs = singleEntry == null ? Collections.emptyList() : Collections.singleton(singleEntry);
            }
            for (URI uri : allURIs) {
                this.addURIToClasspath(context, BaseExtensionVisitor.getExtension(context), uri);
            }
        }

        private void addURIToClasspath(ElementContext context, Extension ext, URI entry) {
            if (!this.acceptClasspathEntry(context, entry)) {
                return;
            }
            if (ext instanceof DefaultExtension) {
                ((DefaultExtension)ext).getClassPath().add(entry);
            }
            BaseExtensionVisitor.this.addToClasspath(context, ext, entry);
        }
    }

    private final class HooksVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            if (BaseExtensionVisitor.ra$_hookVisitorFactory(BaseExtensionVisitor.this) != null) {
                context.registerVisitorFactory(BaseExtensionVisitor.ra$_hookVisitorFactory(BaseExtensionVisitor.this));
            }
            BaseExtensionVisitor.this.addExtensionSourceToClasspath(context);
        }

        private HooksVisitor() {
        }

        HooksVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

