/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.ElementVisitorFactory2;
import javax.ide.extension.Extension;
import javax.ide.extension.UnrecognizedElementException;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.MacroExpander;
import javax.ide.extension.spi.ScopedMap;
import javax.ide.extension.spi.Stack;
import javax.ide.net.URIFactory;
import org.xml.sax.Attributes;

public class DefaultElementContext
implements ElementContext,
ElementStartContext,
ElementEndContext {
    private Attributes _attributes;
    private ElementName _name;
    private final Stack<ElementName> _elementPathStack;
    private final ScopedMap _contextMap;
    private final Stack<StringBuffer> _elementText;
    private Logger _logger;
    private final Stack<Handlers> _handlers;
    private final MacroExpander _macroExpander;
    private final ElementVisitor NULL_VISITOR;

    private void $init$() {
        this._elementPathStack = new Stack();
        this._contextMap = new ScopedMap();
        this._elementText = new Stack();
        this._handlers = new Stack();
        this._macroExpander = new 1();
        this.NULL_VISITOR = new NullVisitor(null);
    }

    public DefaultElementContext() {
        this.$init$();
        this._handlers.push(new Handlers(null));
    }

    void reset() {
        this._contextMap.reset();
        this._elementPathStack.clear();
        this._elementText.clear();
        while (this._handlers.size() > 1) {
            this._handlers.pop();
        }
        this._name = null;
        this._attributes = null;
    }

    public ElementName getElementName() {
        return this._name;
    }

    final String getRawText() {
        StringBuffer buffer = this._elementText.peek();
        if (buffer == null) {
            return null;
        }
        return buffer.toString();
    }

    final String getProcessedText(String rawText) {
        return this.processText(rawText);
    }

    final void setText(String rawText) {
        if (rawText == null) {
            throw new NullPointerException();
        }
        this._elementText.pop();
        this._elementText.push(new StringBuffer(rawText));
    }

    public String getText() {
        StringBuffer buffer = this._elementText.peek();
        if (buffer == null) {
            return null;
        }
        return this.processText(buffer.toString());
    }

    public String getAttributeValue(String attributeName) {
        if (this._attributes == null) {
            throw new IllegalStateException("Cannot call from handleEndElement");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName must not be null");
        }
        return this.processText(this._attributes.getValue(attributeName));
    }

    public Collection getAttributeNames() {
        if (this._attributes == null) {
            throw new IllegalStateException();
        }
        ArrayList<String> al = new ArrayList<String>(this._attributes.getLength());
        int i = 0;
        while (i < this._attributes.getLength()) {
            al.add(this._attributes.getLocalName(i));
            ++i;
        }
        return Collections.unmodifiableCollection(al);
    }

    public Map getScopeData() {
        return this._contextMap;
    }

    public void registerChildVisitor(ElementName name, ElementVisitor visitor) {
        this._handlers.peek().addChildVisitor(name, visitor);
    }

    public void registerVisitorFactory(ElementVisitorFactory factory) {
        this._handlers.peek().addVisitorFactory(factory);
    }

    ElementVisitor getVisitorForEndElement() {
        return this._handlers.peek().getStartElementVisitor();
    }

    ElementVisitor getVisitorForStartElement(ElementName name) {
        try {
            ElementVisitor visitor = this.getVisitorForStartElementImpl(name);
            Handlers handlers = this._handlers.peek();
            handlers.setStartElementVisitor(visitor);
            ElementVisitor elementVisitor = visitor;
            return elementVisitor;
        }
        catch (UnrecognizedElementException uee) {
            this.getLogger().log(new ExtensionLogRecord(this, Level.SEVERE, uee.getMessage()));
            ElementVisitor elementVisitor = this.NULL_VISITOR;
            return elementVisitor;
        }
    }

    private ElementVisitor getVisitorForStartElementImpl(ElementName name) throws UnrecognizedElementException {
        ElementName qualified = name;
        ElementName unqualified = new ElementName(null, name.getLocalName());
        ElementVisitor handler = null;
        Handlers handlers = this._handlers.peek();
        handler = handlers.getChildVisitor(qualified);
        if (handler == null) {
            handler = handlers.getChildVisitor(unqualified);
        }
        if (handler != null) {
            return handler;
        }
        boolean firstLevel = true;
        for (Handlers h : this._handlers) {
            for (ElementVisitorFactory factory : h.getVisitorFactories()) {
                if (factory instanceof ElementVisitorFactory2) {
                    ElementVisitorFactory2 factory2 = (ElementVisitorFactory2)factory;
                    if ((firstLevel || !factory2.isDescending()) && !firstLevel) continue;
                    handler = factory2.getVisitor(this, qualified);
                    if (handler != null) {
                        return handler;
                    }
                    handler = factory2.getVisitor(this, unqualified);
                    if (handler == null) continue;
                    return handler;
                }
                handler = factory.getVisitor(qualified);
                if (handler != null) {
                    return handler;
                }
                handler = factory.getVisitor(unqualified);
            }
            firstLevel = false;
        }
        return handler;
    }

    private void setElement(String uri, String name) {
        this._name = new ElementName(uri, name);
    }

    void beginElement(String uri, String name, Attributes attributes) {
        this.setElement(uri, name);
        this._attributes = attributes;
        this._contextMap.enterScope();
        this._handlers.push(new Handlers(null));
    }

    void appendCharacters(char[] characters, int start, int length) {
        if (this._elementText.isEmpty()) {
            throw new IllegalStateException();
        }
        StringBuffer buffer = this._elementText.peek();
        if (buffer == null) {
            buffer = new StringBuffer();
            this._elementText.replace(buffer);
        }
        buffer.append(characters, start, length);
    }

    void postEndElement() {
        this._contextMap.exitScope();
        this._elementText.pop();
        this._name = null;
        this._attributes = null;
    }

    void endElement(String uri, String name) {
        this.setElement(uri, name);
        this._handlers.pop();
        this._attributes = null;
        this._elementPathStack.pop();
    }

    void postBeginElement() {
        this._elementPathStack.push(this._name);
        this._elementText.push(null);
    }

    public Logger getLogger() {
        if (this._logger == null) {
            this._logger = new NullLogger();
        }
        return this._logger;
    }

    public void setMessageReporter(Logger logger) {
        this._logger = logger;
    }

    public Extension getExtension() {
        return (Extension)this.getScopeData().get("extension");
    }

    public URI getExtensionSourceURI() {
        ExtensionSource source = (ExtensionSource)this.getScopeData().get("extSource");
        return source.getURI();
    }

    protected String processText(String text) {
        if (text == null) {
            return null;
        }
        String newText = this.substituteMacros(text);
        if (newText.startsWith("res:")) {
            return this.resolveResource(newText);
        }
        if (newText.startsWith("uri:")) {
            return this.resolveUri(newText);
        }
        return newText;
    }

    private String resolveUri(String text) {
        if (text.length() > 4) {
            String uriString = text.substring(4);
            Extension ext = (Extension)this.getScopeData().get("extension");
            ExtensionSource source = (ExtensionSource)this.getScopeData().get("extSource");
            URI resolved = source.resolvePath(ext, uriString);
            if (resolved == null) {
                this.getLogger().log(new ExtensionLogRecord(this, Level.WARNING, "Unresolved uri: '" + uriString + "'."));
                return text;
            }
            return "uri:" + resolved.toString();
        }
        this.getLogger().log(new ExtensionLogRecord(this, Level.SEVERE, "No uri specified."));
        return text;
    }

    private String resolveResource(String text) {
        if (text.length() > 4) {
            String resString = text.substring(4);
            if (resString.charAt(0) == '/' && resString.length() > 1) {
                ClassLoader cl = ElementVisitor.getClassLoader(this);
                URL resUrl = cl.getResource(resString.substring(1));
                if (resUrl != null) {
                    URI uri = URIFactory.newURI(resUrl);
                    return "uri:" + uri.toString();
                }
            } else {
                URL resUrl;
                ResourceBundle bundle = ElementVisitor.getResourceBundle(this);
                if (bundle != null && (resUrl = bundle.getClass().getResource(resString)) != null) {
                    URI uri = URIFactory.newURI(resUrl);
                    return "uri:" + uri.toString();
                }
            }
            this.getLogger().log(new ExtensionLogRecord(this, Level.SEVERE, "Resource not found: '" + resString + "'."));
            return text;
        }
        this.getLogger().log(new ExtensionLogRecord(this, Level.SEVERE, "No resource specified"));
        return text;
    }

    protected final String substituteMacros(String s) {
        return this._macroExpander.substituteMacros(s);
    }

    protected String getMacroValue(String macroName) {
        ResourceBundle bundle = ElementVisitor.getResourceBundle(this);
        if (bundle != null) {
            try {
                String string = bundle.getString(macroName);
                return string;
            }
            catch (MissingResourceException mre) {
                this.getLogger().log(new ExtensionLogRecord(this, Level.FINE, mre.getLocalizedMessage()));
                String string = null;
                return string;
            }
        }
        String resClass = (String)this.getScopeData().get("rsbundleclass");
        if (resClass == null) {
            this.getLogger().log(new ExtensionLogRecord(this, Level.FINE, "Unrecognized macro '" + macroName + "' and no rsbundle-class attribute specified."));
        } else {
            this.getLogger().log(new ExtensionLogRecord(this, Level.FINE, "Unable to find resource bundle class: " + resClass));
        }
        return null;
    }

    final class 1
    extends MacroExpander {
        protected String getMacroValue(String macroText) {
            return DefaultElementContext.this.getMacroValue(macroText);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Handlers {
        private Map<ElementName, ElementVisitor> childVisitors;
        private List<ElementVisitorFactory> visitorFactories;
        private ElementVisitor startElementVisitor;

        public ElementVisitor getStartElementVisitor() {
            return this.startElementVisitor;
        }

        public void setStartElementVisitor(ElementVisitor visitor) {
            this.startElementVisitor = visitor;
        }

        public void addChildVisitor(ElementName name, ElementVisitor visitor) {
            if (this.childVisitors == null) {
                this.childVisitors = new HashMap<ElementName, ElementVisitor>();
            }
            this.childVisitors.put(name, visitor);
        }

        public ElementVisitor getChildVisitor(ElementName name) {
            if (this.childVisitors == null) {
                return null;
            }
            return this.childVisitors.get(name);
        }

        public void addVisitorFactory(ElementVisitorFactory factory) {
            if (this.visitorFactories == null) {
                this.visitorFactories = new ArrayList<ElementVisitorFactory>();
            }
            this.visitorFactories.add(factory);
        }

        public List<ElementVisitorFactory> getVisitorFactories() {
            return this.visitorFactories == null ? Collections.EMPTY_LIST : this.visitorFactories;
        }

        private Handlers() {
        }

        Handlers(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class NullLogger
    extends Logger {
        public NullLogger() {
            super(null, null);
        }

        public void log(LogRecord logRecord) {
        }
    }

    private final class NullVisitor
    extends ElementVisitor {
        private NullVisitor() {
        }

        NullVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

