/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.util.Version;

public class DependenciesVisitor
extends ElementVisitor {
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "dependencies");
    private static final ElementName IMPORT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "import");
    private ElementVisitor _importVisitor;
    private static final String MIN_VERSION = "minVersion";
    private static final String MAX_VERSION = "maxVersion";

    private void $init$() {
        this._importVisitor = new ImportVisitor(null);
    }

    public final void start(ElementStartContext context) {
        context.registerChildVisitor(IMPORT, this._importVisitor);
    }

    public final void end(ElementEndContext context) {
    }

    protected void addDependency(ElementContext context, DefaultExtension extension, ExtensionDependency dep) {
        extension.addDependency(dep);
    }

    public DependenciesVisitor() {
        this.$init$();
    }

    private class ImportVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String minVersion = context.getAttributeValue(DependenciesVisitor.MIN_VERSION);
            String maxVersion = context.getAttributeValue(DependenciesVisitor.MAX_VERSION);
            Version vMinVersion = null;
            if (minVersion != null) {
                vMinVersion = new Version(minVersion);
            }
            Version vMaxVersion = null;
            if (maxVersion != null) {
                vMaxVersion = new Version(maxVersion);
            }
            context.getScopeData().put(DependenciesVisitor.MIN_VERSION, vMinVersion);
            context.getScopeData().put(DependenciesVisitor.MAX_VERSION, vMaxVersion);
        }

        public void end(ElementEndContext context) {
            String id = context.getText().trim();
            if (id.length() == 0) {
                this.log(context, Level.SEVERE, "Element 'import' must specify an extension id.");
                return;
            }
            ExtensionDependency dep = new ExtensionDependency(id, (Version)context.getScopeData().get(DependenciesVisitor.MIN_VERSION), (Version)context.getScopeData().get(DependenciesVisitor.MAX_VERSION));
            DefaultExtension ext = (DefaultExtension)context.getScopeData().get("extension");
            DependenciesVisitor.this.addDependency(context, ext, dep);
        }

        private ImportVisitor() {
        }

        ImportVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

