/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Stack<T>
extends AbstractCollection<T>
implements Iterable<T> {
    private ArrayList<T> _list;

    public Stack() {
    }

    public Stack(Collection<T> c) {
        this.addAll(c);
    }

    private List<T> getList() {
        if (this._list == null) {
            this._list = new ArrayList();
        }
        return this._list;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean push(T o) {
        return this.getList().add(o);
    }

    public T peek() {
        int size = this.size();
        if (size == 0) {
            throw new IllegalStateException("Illegal peek()");
        }
        return this.getList().get(size - 1);
    }

    public void replace(T o) {
        int size = this.size();
        if (size == 0) {
            throw new IllegalStateException("Illegal replace()");
        }
        this.getList().set(size - 1, o);
    }

    public T pop() {
        int size = this.size();
        if (size == 0) {
            throw new IllegalStateException("Illegal pop()");
        }
        T theValue = this._list.remove(size - 1);
        if (size == 1) {
            this._list = null;
        }
        return theValue;
    }

    public Iterator<T> reverseIterator() {
        if (this.isEmpty()) {
            return Collections.emptyList().iterator();
        }
        return this._list.iterator();
    }

    @Override
    public boolean add(T o) {
        return this.push(o);
    }

    @Override
    public void clear() {
        if (this._list != null) {
            this._list.clear();
        }
    }

    @Override
    public Iterator<T> iterator() {
        if (this.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new ReverseListIterator<T>(this._list);
    }

    @Override
    public int size() {
        return this._list == null ? 0 : this._list.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReverseListIterator<T>
    implements Iterator<T> {
        private final ListIterator<T> _listIterator;

        public ReverseListIterator(List<T> list) {
            this._listIterator = list.listIterator(list.size());
        }

        @Override
        public boolean hasNext() {
            return this._listIterator.hasPrevious();
        }

        @Override
        public T next() {
            return this._listIterator.previous();
        }

        @Override
        public void remove() {
            this._listIterator.remove();
        }
    }
}

