/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.menu.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ide.command.Controller;
import javax.ide.menu.IDEAction;
import javax.ide.menu.spi.MenuBar;
import javax.ide.menu.spi.PopupMenu;
import javax.ide.menu.spi.Toolbar;
import javax.ide.util.MetaClass;

public final class MenuModel {
    private final Map _actions;
    private final Map _pullDownMenus;
    private final Map _popupMenus;
    private final Map _toolbars;
    private final Map _actionControllers;
    private final Set _itemFactories;

    private void $init$() {
        this._actions = new HashMap();
        this._pullDownMenus = new HashMap();
        this._popupMenus = new HashMap();
        this._toolbars = new HashMap();
        this._actionControllers = new HashMap();
        this._itemFactories = new HashSet();
    }

    void addAction(IDEAction action) {
        this._actions.put(action.getID(), action);
    }

    boolean isUniqueActionId(String id) {
        return this._actions.containsKey(id) ^ true;
    }

    Toolbar findOrCreateToolbar(String id) {
        Toolbar toolbar = (Toolbar)this._toolbars.get(id);
        if (toolbar == null) {
            toolbar = new Toolbar(id);
            this._toolbars.put(id, toolbar);
        }
        return toolbar;
    }

    MenuBar findOrCreatePullDownMenu(String id) {
        MenuBar mc = (MenuBar)this._pullDownMenus.get(id);
        if (mc == null) {
            mc = new MenuBar(id);
            this._pullDownMenus.put(id, mc);
        }
        return mc;
    }

    PopupMenu findOrCreatePopupMenu(String id) {
        PopupMenu mc = (PopupMenu)this._popupMenus.get(id);
        if (mc == null) {
            mc = new PopupMenu(id);
            this._popupMenus.put(id, mc);
        }
        return mc;
    }

    void addItemFactory(MetaClass itemFactory) {
        this._itemFactories.add(new MetaClassWrapper(itemFactory));
    }

    public Set getActionsWithControllers() {
        return this._actionControllers.keySet();
    }

    public List getControllers(String actionId) {
        List list = (List)this._actionControllers.get(actionId);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(list);
    }

    void addController(String actionId, Controller controller) {
        ArrayList<Controller> controllers = (ArrayList<Controller>)this._actionControllers.get(actionId);
        if (controllers == null) {
            controllers = new ArrayList<Controller>();
            this._actionControllers.put(actionId, controllers);
        }
        controllers.add(controller);
    }

    public Map getActions() {
        return this._actions;
    }

    public Map getMenuBars() {
        return this._pullDownMenus;
    }

    public Map getPopupMenus() {
        return this._popupMenus;
    }

    public Map getToolbars() {
        return this._toolbars;
    }

    public Collection getItemFactories() {
        ArrayList<Object> al = new ArrayList<Object>();
        for (MetaClassWrapper mcw : this._itemFactories) {
            try {
                al.add(mcw.getInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Collections.unmodifiableCollection(al);
    }

    public MenuModel() {
        this.$init$();
    }

    private class MetaClassWrapper {
        private MetaClass _metaClass;
        private Object _instance;

        MetaClassWrapper(MetaClass mc) {
            this._metaClass = mc;
        }

        public Object getInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            if (this._instance == null) {
                this._instance = this._metaClass.newInstance();
            }
            return this._instance;
        }
    }
}

