/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.menu.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.ide.menu.spi.Positionable;

final class PositionMap {
    private Map _idsToVertices;
    private Map _undefinedItemMap;
    private Vertex _currentAncestor;
    private List _sortedList;
    private static final Object COLOR_VISITING = "visiting";
    private static final Object COLOR_VISITED = "visited";

    private void $init$() {
        this._idsToVertices = new LinkedHashMap();
        this._undefinedItemMap = new LinkedHashMap();
    }

    public void add(Positionable p) {
        this._sortedList = null;
        Vertex thisVertex = this.getVertex(p.getID());
        if (thisVertex == null) {
            thisVertex = new Vertex(p);
            this._idsToVertices.put(p.getID(), thisVertex);
        }
    }

    private Vertex getVertex(String name) {
        Vertex vertex = (Vertex)this._idsToVertices.get(name);
        if (vertex == null) {
            vertex = (Vertex)this._undefinedItemMap.get(name);
        }
        return vertex;
    }

    private void addToGraph(Vertex thisVertex) {
        Vertex afterVertex;
        Positionable p = thisVertex.getPositionable();
        String before = p.getBefore();
        String after = p.getAfter();
        if (after == null && before == null && this._currentAncestor != null && (afterVertex = this.getVertex(after = this._currentAncestor.getName())) != null && afterVertex.getFromEdges().contains(thisVertex)) {
            this._currentAncestor = thisVertex;
            return;
        }
        if (after != null) {
            Vertex afterVertex2 = this.getVertex(after);
            if (afterVertex2 == null) {
                afterVertex2 = new Vertex(after);
                this._undefinedItemMap.put(after, afterVertex2);
            }
            thisVertex.attachAfter(afterVertex2.getToEdges());
            afterVertex2.attachAfter(thisVertex);
            if (thisVertex.isUndefinedReference()) {
                for (Vertex v : thisVertex.getFromEdges()) {
                    if (afterVertex2 == v) continue;
                    afterVertex2.attachAfter(v);
                }
                thisVertex.setPositionable(p);
            }
        }
        if (before != null) {
            Vertex beforeVertex = this.getVertex(before);
            if (beforeVertex == null) {
                beforeVertex = new Vertex(before);
                this._undefinedItemMap.put(before, beforeVertex);
            }
            thisVertex.attachBefore(beforeVertex.getFromEdges());
            beforeVertex.attachBefore(thisVertex);
            if (thisVertex.isUndefinedReference()) {
                for (Vertex v : thisVertex.getToEdges()) {
                    if (beforeVertex == v) continue;
                    beforeVertex.attachBefore(v);
                }
                thisVertex.setPositionable(p);
            }
        }
        this._currentAncestor = thisVertex;
    }

    public List getSortedItems() {
        if (this._sortedList == null) {
            this._sortedList = this.sort();
        }
        return this._sortedList;
    }

    public Positionable get(String id) {
        Vertex vertex = this.getVertex(id);
        if (vertex == null || vertex.isUndefinedReference()) {
            return null;
        }
        return vertex.getPositionable();
    }

    private List sort() {
        for (Vertex vertex : this._idsToVertices.values()) {
            this.addToGraph(vertex);
        }
        HashMap colorings = new HashMap();
        ArrayList topo = new ArrayList();
        for (Vertex vertex : this._idsToVertices.values()) {
            Object color = colorings.get(vertex);
            if (color != null) continue;
            this.visit(colorings, vertex, topo);
        }
        ArrayList<Positionable> sorted = new ArrayList<Positionable>(topo.size());
        ListIterator li = topo.listIterator(topo.size());
        while (li.hasPrevious()) {
            Vertex v = (Vertex)li.previous();
            if (v.isUndefinedReference()) continue;
            sorted.add(v.getPositionable());
        }
        return sorted;
    }

    private void visit(Map colorings, Vertex vertex, List topo) {
        colorings.put(vertex, COLOR_VISITING);
        for (Vertex child : vertex.getToEdges()) {
            Object color = colorings.get(child);
            if (color == COLOR_VISITING || color == COLOR_VISITED) continue;
            this.visit(colorings, child, topo);
        }
        topo.add(vertex);
        colorings.put(vertex, COLOR_VISITED);
    }

    PositionMap() {
        this.$init$();
    }

    private class Vertex {
        private List _toEdges;
        private List _fromEdges;
        private final String _name;
        private Positionable _positionable;

        private void $init$() {
            this._toEdges = new ArrayList();
            this._fromEdges = new ArrayList();
        }

        public Vertex(String name) {
            this.$init$();
            this._name = name;
        }

        public Vertex(Positionable positionable) {
            this.$init$();
            this._name = positionable.getID();
            this._positionable = positionable;
        }

        public void setPositionable(Positionable p) {
            this._positionable = p;
        }

        public Positionable getPositionable() {
            return this._positionable;
        }

        public boolean isUndefinedReference() {
            return this._positionable == null;
        }

        public String getName() {
            return this._name;
        }

        public Collection getFromEdges() {
            return this._fromEdges;
        }

        public Collection getToEdges() {
            return this._toEdges;
        }

        public void attachBefore(Vertex otherVertex) {
            if (this._fromEdges.contains(otherVertex) || otherVertex == this) {
                return;
            }
            this._fromEdges.add(otherVertex);
            otherVertex._toEdges.add(this);
        }

        public void attachAfter(Vertex otherVertex) {
            if (this._toEdges.contains(otherVertex) || otherVertex == this) {
                return;
            }
            this._toEdges.add(otherVertex);
            otherVertex._fromEdges.add(this);
        }

        public void attachAfter(Collection vertices) {
            for (Vertex v : vertices) {
                this.attachAfter(v);
            }
        }

        public void attachBefore(Collection vertices) {
            for (Vertex v : vertices) {
                this.attachBefore(v);
            }
        }
    }
}

