/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.menu.spi;

import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.menu.spi.Item;
import javax.ide.menu.spi.Menu;
import javax.ide.menu.spi.MenuVisitor;
import javax.ide.menu.spi.Positionable;
import javax.ide.menu.spi.PositionableVisitor;
import javax.ide.menu.spi.Section;
import javax.ide.menu.spi.SectionContainer;

final class SectionVisitor
extends PositionableVisitor {
    static final ElementName SECTION = new ElementName("http://jcp.org/jsr/198/extension-manifest", "section");
    private static final ElementName ITEM = new ElementName("http://jcp.org/jsr/198/extension-manifest", "item");
    private ElementVisitor _menuVisitor;
    private ElementVisitor _itemVisitor;
    private static final String KEY_SECTION = "section";

    private void $init$() {
        this._menuVisitor = new MenuInSectionVisitor(null);
        this._itemVisitor = new ItemVisitor();
    }

    protected void positionable(ElementStartContext context, String id, String before, String after) {
        SectionContainer container = (SectionContainer)context.getScopeData().get("sectionContainer");
        Section section = container.getSection(id);
        if (section == null) {
            section = new Section(id);
            container.addSection(section);
        }
        if (before != null) {
            section.setBefore(before);
        } else if (after != null) {
            section.setAfter(after);
        }
        context.getScopeData().put(KEY_SECTION, section);
        context.registerChildVisitor(MenuVisitor.MENU, this._menuVisitor);
        context.registerChildVisitor(ITEM, this._itemVisitor);
    }

    private Section getSection(ElementContext context) {
        return (Section)context.getScopeData().get(KEY_SECTION);
    }

    SectionVisitor() {
        this.$init$();
    }

    static Section mav$getSection(SectionVisitor sectionVisitor, ElementContext elementContext) {
        return sectionVisitor.getSection(elementContext);
    }

    private final class ItemVisitor
    extends PositionableVisitor {
        ItemVisitor() {
            super("action-ref");
        }

        protected void positionable(ElementStartContext context, String id, String before, String after) {
            Section parentSection = SectionVisitor.mav$getSection(SectionVisitor.this, context);
            Positionable pos = parentSection.getItem(id);
            if (pos == null) {
                pos = new Item(id);
                parentSection.addItem(pos);
            } else if (pos instanceof Menu) {
                this.log(context, Level.SEVERE, "'" + id + "' is already defined as a menu in section '" + parentSection.getID() + "'");
                return;
            }
            Item item = (Item)pos;
            String radioGroupId = context.getAttributeValue("radiogroup-id");
            if (radioGroupId != null) {
                radioGroupId = radioGroupId.trim();
                item.setRadioGroupID(radioGroupId);
            }
            if (before != null) {
                item.setBefore(before);
            } else if (after != null) {
                item.setAfter(after);
            }
        }
    }

    private final class MenuInSectionVisitor
    extends MenuVisitor {
        protected void positionable(ElementStartContext context, String id, String before, String after) {
            Section parentSection = SectionVisitor.mav$getSection(SectionVisitor.this, context);
            Positionable pos = parentSection.getItem(id);
            if (pos == null) {
                pos = new Menu(id);
                parentSection.addItem(pos);
            } else if (pos instanceof Item) {
                this.log(context, Level.SEVERE, "'" + id + "' is already defined as an item in section '" + parentSection.getID() + "'");
                return;
            }
            Menu menu = (Menu)pos;
            this.processMenu(context, menu, before, after);
        }

        private MenuInSectionVisitor() {
        }

        MenuInSectionVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

