/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.model.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.spi.ListenerInfo;
import javax.ide.model.spi.SuffixRecognizer;
import javax.ide.model.spi.XMLDocType;
import javax.ide.model.spi.XMLDocTypeRecognizer;
import javax.ide.model.spi.XMLRootElementRecognizer;
import javax.ide.util.MetaClass;

public class DocumentHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "document-hook");
    private static final ElementName DOCUMENTS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "documents");
    private static final ElementName BY_SUFFIX = new ElementName("http://jcp.org/jsr/198/extension-manifest", "by-suffix");
    private static final ElementName SUFFIX = new ElementName("http://jcp.org/jsr/198/extension-manifest", "suffix");
    private static final ElementName BY_XML_ROOT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "by-xml-root");
    private static final ElementName BY_XML_DOCTYPE = new ElementName("http://jcp.org/jsr/198/extension-manifest", "by-xml-doctype");
    private static final ElementName ROOT_ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "root-element");
    private static final ElementName DOCTYPE = new ElementName("http://jcp.org/jsr/198/extension-manifest", "doctype");
    private static final ElementName BY_RECOGNIZER = new ElementName("http://jcp.org/jsr/198/extension-manifest", "by-recognizer");
    private static final ElementName LISTENERS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "listeners");
    private static final ElementName DOCUMENT_LISTENER = new ElementName("http://jcp.org/jsr/198/extension-manifest", "document-listener");
    private static final ElementName PROPERTY_LISTENER = new ElementName("http://jcp.org/jsr/198/extension-manifest", "property-listener");
    private final ElementVisitor _documentsVisitor;
    private final ElementVisitor _bySuffixVisitor;
    private final ElementVisitor _byXMLRootVisitor;
    private final ElementVisitor _byXMLDocTypeVisitor;
    private final ElementVisitor _byRecognizerVisitor;
    private final ElementVisitor _rootElementVisitor;
    private final ElementVisitor _docTypeVisitor;
    private final ElementVisitor _suffixVisitor;
    private final ElementVisitor _listenersVisitor;
    private final List _documentListeners;
    private final List _propertyListeners;
    private final List _suffixRecognizers;
    private final List _xmlRecognizers;
    private final List _customRecognizers;
    private static final String KEY_CURRENT_SUFFIX_RECOGNIZER = "currentSuffixRecognizer";

    private void $init$() {
        this._documentsVisitor = new DocumentsVisitor(null);
        this._bySuffixVisitor = new BySuffixVisitor(null);
        this._byXMLRootVisitor = new ByXMLRootVisitor(null);
        this._byXMLDocTypeVisitor = new ByXMLDocTypeVisitor(null);
        this._byRecognizerVisitor = new ByRecognizerVisitor(null);
        this._rootElementVisitor = new RootElementVisitor(null);
        this._docTypeVisitor = new DocTypeVisitor(null);
        this._suffixVisitor = new SuffixVisitor(null);
        this._listenersVisitor = new ListenersVisitor(null);
        this._documentListeners = new ArrayList();
        this._propertyListeners = new ArrayList();
        this._suffixRecognizers = new ArrayList();
        this._xmlRecognizers = new ArrayList();
        this._customRecognizers = new ArrayList();
    }

    public Collection getDocumentListeners() {
        return Collections.unmodifiableCollection(this._documentListeners);
    }

    public Collection getSuffixRecognizers() {
        return Collections.unmodifiableCollection(this._suffixRecognizers);
    }

    public Collection getXMLRecognizers() {
        return Collections.unmodifiableCollection(this._xmlRecognizers);
    }

    public Collection getCustomRecognizers() {
        return Collections.unmodifiableCollection(this._customRecognizers);
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(DOCUMENTS, this._documentsVisitor);
        context.registerChildVisitor(LISTENERS, this._listenersVisitor);
    }

    private final SuffixRecognizer getSuffixRecognizer(ElementContext context) {
        return (SuffixRecognizer)context.getScopeData().get(KEY_CURRENT_SUFFIX_RECOGNIZER);
    }

    private MetaClass createMetaClass(ElementContext context, String className) {
        ClassLoader classLoader = (ClassLoader)context.getScopeData().get("classLoader");
        return new MetaClass(classLoader, className);
    }

    public DocumentHook() {
        this.$init$();
    }

    static ElementName ra$BY_SUFFIX() {
        return BY_SUFFIX;
    }

    static ElementVisitor ra$_bySuffixVisitor(DocumentHook documentHook) {
        return documentHook._bySuffixVisitor;
    }

    static ElementName ra$BY_XML_ROOT() {
        return BY_XML_ROOT;
    }

    static ElementVisitor ra$_byXMLRootVisitor(DocumentHook documentHook) {
        return documentHook._byXMLRootVisitor;
    }

    static ElementName ra$BY_XML_DOCTYPE() {
        return BY_XML_DOCTYPE;
    }

    static ElementVisitor ra$_byXMLDocTypeVisitor(DocumentHook documentHook) {
        return documentHook._byXMLDocTypeVisitor;
    }

    static ElementName ra$BY_RECOGNIZER() {
        return BY_RECOGNIZER;
    }

    static ElementVisitor ra$_byRecognizerVisitor(DocumentHook documentHook) {
        return documentHook._byRecognizerVisitor;
    }

    static List ra$_suffixRecognizers(DocumentHook documentHook) {
        return documentHook._suffixRecognizers;
    }

    static SuffixRecognizer mav$getSuffixRecognizer(DocumentHook documentHook, ElementContext elementContext) {
        return documentHook.getSuffixRecognizer(elementContext);
    }

    static MetaClass mav$createMetaClass(DocumentHook documentHook, ElementContext elementContext, String string) {
        return documentHook.createMetaClass(elementContext, string);
    }

    static ElementName ra$SUFFIX() {
        return SUFFIX;
    }

    static ElementVisitor ra$_suffixVisitor(DocumentHook documentHook) {
        return documentHook._suffixVisitor;
    }

    static List ra$_xmlRecognizers(DocumentHook documentHook) {
        return documentHook._xmlRecognizers;
    }

    static ElementName ra$ROOT_ELEMENT() {
        return ROOT_ELEMENT;
    }

    static ElementVisitor ra$_rootElementVisitor(DocumentHook documentHook) {
        return documentHook._rootElementVisitor;
    }

    static ElementName ra$DOCTYPE() {
        return DOCTYPE;
    }

    static ElementVisitor ra$_docTypeVisitor(DocumentHook documentHook) {
        return documentHook._docTypeVisitor;
    }

    static List ra$_customRecognizers(DocumentHook documentHook) {
        return documentHook._customRecognizers;
    }

    static ElementName ra$DOCUMENT_LISTENER() {
        return DOCUMENT_LISTENER;
    }

    static ElementName ra$PROPERTY_LISTENER() {
        return PROPERTY_LISTENER;
    }

    static List ra$_documentListeners(DocumentHook documentHook) {
        return documentHook._documentListeners;
    }

    static List ra$_propertyListeners(DocumentHook documentHook) {
        return documentHook._propertyListeners;
    }

    private class DocumentsVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            context.registerChildVisitor(DocumentHook.ra$BY_SUFFIX(), DocumentHook.ra$_bySuffixVisitor(DocumentHook.this));
            context.registerChildVisitor(DocumentHook.ra$BY_XML_ROOT(), DocumentHook.ra$_byXMLRootVisitor(DocumentHook.this));
            context.registerChildVisitor(DocumentHook.ra$BY_XML_DOCTYPE(), DocumentHook.ra$_byXMLDocTypeVisitor(DocumentHook.this));
            context.registerChildVisitor(DocumentHook.ra$BY_RECOGNIZER(), DocumentHook.ra$_byRecognizerVisitor(DocumentHook.this));
        }

        private DocumentsVisitor() {
        }

        DocumentsVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class BySuffixVisitor
    extends ElementVisitor {
        public final void start(ElementStartContext context) {
            String docClass = context.getAttributeValue("document-class");
            if ((docClass == null || (docClass = docClass.trim()).length() == 0) && (docClass = this.getDefaultDocumentClassType()) == null) {
                this.log(context, Level.SEVERE, "Missing attribute 'document-class'.");
                return;
            }
            MetaClass docMetaClass = DocumentHook.mav$createMetaClass(DocumentHook.this, context, docClass);
            SuffixRecognizer sr = this.createSuffixRecognizer(context, docMetaClass);
            context.getScopeData().put(DocumentHook.KEY_CURRENT_SUFFIX_RECOGNIZER, sr);
            context.registerChildVisitor(DocumentHook.ra$SUFFIX(), DocumentHook.ra$_suffixVisitor(DocumentHook.this));
        }

        protected String getDefaultDocumentClassType() {
            return null;
        }

        protected boolean isSuffixRequired() {
            return true;
        }

        public final void end(ElementEndContext context) {
            SuffixRecognizer sr = DocumentHook.mav$getSuffixRecognizer(DocumentHook.this, context);
            if (this.isSuffixRequired() && sr.getSuffixes().isEmpty()) {
                this.log(context, Level.SEVERE, "Missing 'suffix' element.");
            } else {
                this.registerRecognizer(context, sr);
            }
        }

        protected void registerRecognizer(ElementContext context, SuffixRecognizer sr) {
            DocumentHook.ra$_suffixRecognizers(DocumentHook.this).add(sr);
        }

        protected SuffixRecognizer createSuffixRecognizer(ElementStartContext context, MetaClass docClass) {
            return new SuffixRecognizer(docClass);
        }

        private BySuffixVisitor() {
        }

        BySuffixVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class SuffixVisitor
    extends ElementVisitor {
        public void end(ElementEndContext context) {
            String text = context.getText();
            if (text == null || (text = text.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Must provide text content for 'suffix'.");
                return;
            }
            SuffixRecognizer r = DocumentHook.mav$getSuffixRecognizer(DocumentHook.this, context);
            r.addSuffix(text);
        }

        private SuffixVisitor() {
        }

        SuffixVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class ByXMLRootVisitor
    extends BySuffixVisitor {
        protected boolean isSuffixRequired() {
            return false;
        }

        protected String getDefaultDocumentClassType() {
            return "javax.ide.model.xml.XMLDocument";
        }

        protected SuffixRecognizer createSuffixRecognizer(ElementStartContext context, MetaClass docClass) {
            XMLRootElementRecognizer xmlr = new XMLRootElementRecognizer(docClass);
            context.registerChildVisitor(DocumentHook.ra$ROOT_ELEMENT(), DocumentHook.ra$_rootElementVisitor(DocumentHook.this));
            return xmlr;
        }

        protected void registerRecognizer(ElementContext context, SuffixRecognizer sr) {
            XMLRootElementRecognizer xmlr = (XMLRootElementRecognizer)sr;
            if (xmlr.getRootElements().isEmpty()) {
                this.log(context, Level.SEVERE, "Must specify 'root-element'.");
            } else {
                DocumentHook.ra$_xmlRecognizers(DocumentHook.this).add(xmlr);
            }
        }

        private ByXMLRootVisitor() {
            super(null);
        }

        ByXMLRootVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class ByXMLDocTypeVisitor
    extends BySuffixVisitor {
        protected boolean isSuffixRequired() {
            return false;
        }

        protected String getDefaultDocumentClassType() {
            return "javax.ide.model.xml.XMLDocument";
        }

        protected SuffixRecognizer createSuffixRecognizer(ElementStartContext context, MetaClass docClass) {
            XMLDocTypeRecognizer xmlr = new XMLDocTypeRecognizer(docClass);
            context.registerChildVisitor(DocumentHook.ra$DOCTYPE(), DocumentHook.ra$_docTypeVisitor(DocumentHook.this));
            return xmlr;
        }

        protected void registerRecognizer(ElementContext context, SuffixRecognizer sr) {
            XMLDocTypeRecognizer xmlr = (XMLDocTypeRecognizer)sr;
            if (xmlr.getDocTypes().isEmpty()) {
                this.log(context, Level.SEVERE, "Must specify 'doctype'.");
            } else {
                DocumentHook.ra$_xmlRecognizers(DocumentHook.this).add(xmlr);
            }
        }

        private ByXMLDocTypeVisitor() {
            super(null);
        }

        ByXMLDocTypeVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class RootElementVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String localName;
            XMLRootElementRecognizer rec = (XMLRootElementRecognizer)DocumentHook.mav$getSuffixRecognizer(DocumentHook.this, context);
            String ns = context.getAttributeValue("namespace");
            if (ns != null && ns.trim().length() == 0) {
                ns = null;
            }
            if ((localName = context.getAttributeValue("local-name")) == null || (localName = localName.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Missing required attribute 'local-name'.");
                return;
            }
            ElementName name = new ElementName(ns, localName);
            rec.addRootElement(name);
        }

        private RootElementVisitor() {
        }

        RootElementVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DocTypeVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String systemId;
            XMLDocTypeRecognizer rec = (XMLDocTypeRecognizer)DocumentHook.mav$getSuffixRecognizer(DocumentHook.this, context);
            String publicId = context.getAttributeValue("public-id");
            if (publicId != null && publicId.trim().length() == 0) {
                publicId = null;
            }
            if ((systemId = context.getAttributeValue("system-id")) != null && systemId.trim().length() == 0) {
                systemId = null;
            }
            XMLDocType docType = new XMLDocType(publicId, systemId);
            rec.addDocType(docType);
        }

        private DocTypeVisitor() {
        }

        DocTypeVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ByRecognizerVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String recClass = context.getAttributeValue("recognizer-class");
            if (recClass == null || (recClass = recClass.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Missing required attribute 'recognizer-class'.");
                return;
            }
            MetaClass recMetaClass = DocumentHook.mav$createMetaClass(DocumentHook.this, context, recClass);
            DocumentHook.ra$_customRecognizers(DocumentHook.this).add(recMetaClass);
        }

        private ByRecognizerVisitor() {
        }

        ByRecognizerVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class ListenersVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            context.registerChildVisitor(DocumentHook.ra$DOCUMENT_LISTENER(), new 1(DocumentHook.this));
            context.registerChildVisitor(DocumentHook.ra$PROPERTY_LISTENER(), new 2(DocumentHook.this));
        }

        private ListenersVisitor() {
        }

        ListenersVisitor(2 var2_2) {
            this();
        }

        final class 1
        extends AbstractListenerVisitor {
            protected void listenerInfo(ElementContext context, ListenerInfo info) {
                DocumentHook.ra$_documentListeners(DocumentHook.this).add(info);
            }

            public 1(DocumentHook documentHook) {
                super((1)null);
            }
        }

        final class 2
        extends AbstractListenerVisitor {
            protected void listenerInfo(ElementContext context, ListenerInfo info) {
                DocumentHook.ra$_propertyListeners(DocumentHook.this).add(info);
            }

            public 2(DocumentHook documentHook) {
                super((2)null);
            }
        }
    }

    private abstract class AbstractListenerVisitor
    extends ElementVisitor {
        public final void start(ElementStartContext context) {
            String listenerClass = context.getAttributeValue("listener-class");
            if (listenerClass == null || (listenerClass = listenerClass.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Missing required attribute 'listener-class'.");
                return;
            }
            String sourceClass = context.getAttributeValue("source-class");
            ListenerInfo info = new ListenerInfo();
            info.setListenerClass(DocumentHook.mav$createMetaClass(DocumentHook.this, context, listenerClass));
            info.setSourceID(sourceClass);
            this.listenerInfo(context, info);
        }

        protected abstract void listenerInfo(ElementContext var1, ListenerInfo var2);

        private AbstractListenerVisitor() {
        }

        AbstractListenerVisitor(ListenersVisitor.1 var2_2) {
            this();
        }

        AbstractListenerVisitor(ListenersVisitor.2 var2_2) {
            this();
        }
    }
}

