/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.model.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ide.model.Element;
import javax.ide.model.spi.ElementImpl;
import javax.ide.spi.LookupProvider;
import javax.ide.spi.ProviderNotFoundException;

public abstract class ModelAdapterFactory {
    private static ModelAdapterFactory _impl;

    public abstract ElementImpl getImpl(Element var1);

    public static ModelAdapterFactory getModelAdapterFactory() {
        try {
            if (_impl == null) {
                Collection impls = LookupProvider.lookupAll(Thread.currentThread().getContextClassLoader(), ModelAdapterFactory.class);
                if (impls.size() == 1) {
                    _impl = (ModelAdapterFactory)impls.iterator().next();
                } else {
                    ArrayList copy = new ArrayList(impls);
                    Collections.reverse(copy);
                    _impl = new ChainedFactories(copy);
                }
            }
        }
        catch (ProviderNotFoundException pnfe) {
            throw new IllegalStateException("No model adapter factory.");
        }
        return _impl;
    }

    private static final class ChainedFactories
    extends ModelAdapterFactory {
        private final List _factories;

        ChainedFactories(List factories) {
            this._factories = factories;
        }

        public ElementImpl getImpl(Element element) {
            for (ModelAdapterFactory f : this._factories) {
                ElementImpl result = f.getImpl(element);
                if (result == null) continue;
                return result;
            }
            return null;
        }
    }
}

