/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.net;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.ide.net.VirtualFileSystem;

public final class URIFactory {
    public static final String JAR_URI_SEPARATOR = "!/";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static URI newURI(URI baseURI, String relativeSpec) {
        String newPath = URIFactory.resolveRelative(baseURI.getPath(), relativeSpec);
        if (URIFactory.isJarURI(baseURI) && newPath.indexOf(JAR_URI_SEPARATOR) < 0) {
            return URIFactory.newJarFileURIImpl(newPath);
        }
        return URIFactory.replacePathPart(baseURI, newPath);
    }

    public static URI newDirURI(URI baseURI, String relativeSpec) {
        return relativeSpec.endsWith("/") ? URIFactory.newURI(baseURI, relativeSpec) : URIFactory.newURI(baseURI, relativeSpec + "/");
    }

    public static URI newURI(String scheme, String path) {
        return URIFactory.newURI(scheme, null, null, -1, path, null, null);
    }

    public static URI newDirURI(String scheme, String dirPath) {
        return dirPath.endsWith("/") ? URIFactory.newURI(scheme, dirPath) : URIFactory.newURI(scheme, dirPath + "/");
    }

    public static URI newUniqueURI(URI baseURI, NameGenerator nameGen) {
        URI uri;
        do {
            String name;
            if ((uri = URIFactory.newURI(baseURI, name = nameGen.nextName())) != null) continue;
            return null;
        } while (VirtualFileSystem.getVirtualFileSystem().isBound(uri));
        return uri;
    }

    public static URI replaceSchemePart(URI uri, String newScheme) {
        String userinfo = uri.getUserInfo();
        String host = uri.getHost();
        int port = uri.getPort();
        String path = uri.getPath();
        String query = uri.getQuery();
        String fragment = uri.getFragment();
        return URIFactory.newURI(newScheme, userinfo, host, port, path, query, fragment);
    }

    public static URI replacePortPart(URI uri, int newPort) {
        String scheme = uri.getScheme();
        String userinfo = uri.getUserInfo();
        String host = uri.getHost();
        String path = uri.getPath();
        String query = uri.getQuery();
        String fragment = uri.getFragment();
        return URIFactory.newURI(scheme, userinfo, host, newPort, path, query, fragment);
    }

    public static URI replaceHostPart(URI uri, String newHost) {
        String scheme = uri.getScheme();
        String userinfo = uri.getUserInfo();
        int port = uri.getPort();
        String path = uri.getPath();
        String query = uri.getQuery();
        String fragment = uri.getFragment();
        return URIFactory.newURI(scheme, userinfo, newHost, port, path, query, fragment);
    }

    public static URI replacePathPart(URI uri, String newPath) {
        String scheme = uri.getScheme();
        String userinfo = uri.getUserInfo();
        String host = uri.getHost();
        int port = uri.getPort();
        String query = uri.getQuery();
        String fragment = uri.getFragment();
        return URIFactory.newURI(scheme, userinfo, host, port, newPath, query, fragment);
    }

    public static URI replaceFragmentPart(URI uri, String newFragment) {
        String scheme = uri.getScheme();
        String userinfo = uri.getUserInfo();
        String host = uri.getHost();
        int port = uri.getPort();
        String path = uri.getPath();
        String query = uri.getQuery();
        return URIFactory.newURI(scheme, userinfo, host, port, path, query, newFragment);
    }

    public static URI replaceQueryPart(URI uri, String newQuery) {
        String scheme = uri.getScheme();
        String userinfo = uri.getUserInfo();
        String host = uri.getHost();
        int port = uri.getPort();
        String path = uri.getPath();
        String fragment = uri.getFragment();
        return URIFactory.newURI(scheme, userinfo, host, port, path, newQuery, fragment);
    }

    public static URI newURI(String uriSpec) {
        return URIFactory.newURI(uriSpec, false, false);
    }

    static URI newURI(String uriSpec, boolean forceDir, boolean assumeFile) {
        int uriSpecLen;
        if (uriSpec == null) {
            return null;
        }
        if (forceDir && !uriSpec.endsWith("/")) {
            uriSpec = uriSpec + "/";
        }
        if ((uriSpecLen = uriSpec.length()) > 0 && (uriSpec.charAt(0) == File.separatorChar || uriSpecLen > 1 && uriSpec.charAt(1) == ':' || uriSpec.indexOf(58) < 0 && assumeFile)) {
            return URIFactory.newFileURI(uriSpec);
        }
        if (uriSpec.toLowerCase().startsWith("file:")) {
            return URIFactory.newFileURI(uriSpec.substring(5));
        }
        try {
            URI uRI = new URI(uriSpec);
            return uRI;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static URI newFileURI(String filePath) {
        if (filePath == null) {
            return null;
        }
        String path = URIFactory.sanitizePath(filePath);
        return URIFactory.newURI("file", path);
    }

    public static URI newFileURI(File file) {
        if (file == null) {
            return null;
        }
        String filePath = file.getAbsolutePath();
        if (file.isDirectory()) {
            return URIFactory.newDirURI(filePath);
        }
        return URIFactory.newFileURI(filePath);
    }

    public static URI newDirURI(String dirPath) {
        if (dirPath == null) {
            return null;
        }
        String path = URIFactory.sanitizePath(dirPath);
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return URIFactory.newURI("file", path);
    }

    public static URI newDirURI(File dir) {
        return dir != null ? URIFactory.newDirURI(dir.getAbsolutePath()) : null;
    }

    public static URI newJarURI(File archiveFile, String entryName) {
        URI archiveURI = URIFactory.newFileURI(archiveFile);
        return URIFactory.newJarURI(archiveURI, entryName);
    }

    public static boolean isJarURI(URI jarURI) {
        return jarURI != null ? jarURI.getScheme().equals("jar") : false;
    }

    public static boolean isArchive(String pathname) {
        int lastDot = pathname.lastIndexOf(46);
        if (lastDot < 0) {
            return false;
        }
        String ext = pathname.substring(lastDot).toLowerCase();
        return ext.equals(".jar") || ext.equals(".zip");
    }

    static {
        $assertionsDisabled = URIFactory.class.desiredAssertionStatus() ^ true;
    }

    public static URI newJarURI(URI archiveURI, String entryName) {
        if (URIFactory.isJarURI(archiveURI)) {
            String path = archiveURI.getPath();
            int bangSlash = path.indexOf(JAR_URI_SEPARATOR);
            if (bangSlash < 0) {
                throw new IllegalArgumentException("Bad jar uri: " + archiveURI);
            }
            StringBuffer newPath = new StringBuffer(path);
            if (!path.endsWith("/")) {
                newPath.append('/');
            }
            if (entryName != null) {
                newPath.append(entryName);
            }
            return URIFactory.replacePathPart(archiveURI, newPath.toString());
        }
        try {
            StringBuffer path = new StringBuffer(URLDecoder.decode(archiveURI.toString(), "UTF-8"));
            path.insert(0, '/');
            path.append(JAR_URI_SEPARATOR);
            if (entryName != null) {
                path.append(entryName);
            }
            URI uRI = URIFactory.newURI("jar", path.toString());
            return uRI;
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    public static URI newURI(String scheme, String userinfo, String host, int port, String path, String query, String fragment) {
        try {
            URI uRI = new URI(scheme, userinfo, host, port, path, query, fragment);
            return uRI;
        }
        catch (Exception e) {
            e.printStackTrace();
            URI uRI = null;
            return uRI;
        }
    }

    public static URI newURI(URL url) {
        String path = url.getPath();
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            path = "/" + path;
        }
        return URIFactory.newURI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), path, url.getQuery(), url.getRef());
    }

    private static String sanitizePath(String path) {
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    private static String resolveRelative(String basePath, String relPath) {
        int length;
        ArrayList<String> pathElems = new ArrayList<String>();
        int pos = 0;
        while (true) {
            String substr;
            int newPos;
            boolean done = (newPos = basePath.indexOf(47, pos)) == -1;
            String string = substr = done ? basePath.substring(pos) : basePath.substring(pos, newPos);
            if (substr.length() > 0 || newPos == pos + 1) {
                pathElems.add(substr);
            }
            if (done) break;
            pos = newPos + 1;
        }
        boolean lastElemIsRelativeDir = false;
        int pos2 = 0;
        while (true) {
            String substr;
            int newPos;
            boolean done = (newPos = relPath.indexOf(47, pos2)) == -1;
            String string = substr = done ? relPath.substring(pos2) : relPath.substring(pos2, newPos);
            if (substr.length() > 0) {
                if (substr.equals("..")) {
                    int n = pathElems.size();
                    if (n > 0) {
                        pathElems.remove(n - 1);
                    }
                    lastElemIsRelativeDir = true;
                } else if (substr.equals(".")) {
                    lastElemIsRelativeDir = true;
                } else {
                    pathElems.add(substr);
                    lastElemIsRelativeDir = false;
                }
            }
            if (done) break;
            pos2 = newPos + 1;
        }
        StringBuffer newPath = new StringBuffer();
        if (basePath.startsWith("//")) {
            newPath.append("//");
        } else if (basePath.startsWith("/")) {
            newPath.append('/');
        }
        Iterator iter = pathElems.iterator();
        while (iter.hasNext()) {
            newPath.append(iter.next().toString()).append('/');
        }
        if (!lastElemIsRelativeDir && !relPath.endsWith("/") && relPath.length() != 0 && (length = newPath.length()) > 0) {
            newPath.setLength(length - 1);
        }
        return newPath.toString();
    }

    private static URI newJarFileURIImpl(String uriStr) {
        try {
            URI uRI = new URI(uriStr);
            return uRI;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            URI uRI = null;
            return uRI;
        }
    }

    private URIFactory() {
    }

    public interface NameGenerator {
        public String nextName();
    }
}

