/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.net;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.ide.Service;
import javax.ide.net.URIExistsTest;
import javax.ide.net.URIFilter;
import javax.ide.net.VirtualFileSystemHelper;
import javax.ide.spi.ProviderNotFoundException;

public class VirtualFileSystem
extends Service {
    private static final int COPY_BUFFER_SIZE = 4096;
    public static final String FILE_SCHEME = "file";
    public static final String HTTP_SCHEME = "http";
    public static final String JAR_SCHEME = "jar";
    private static final boolean _isCaseSensitive;
    private final HashMap _helpers;
    private final VirtualFileSystemHelper _defaultHelper;
    private final ArrayList _existsTests;

    private void $init$() {
        this._helpers = new HashMap();
        this._defaultHelper = new VirtualFileSystemHelper();
        this._existsTests = new ArrayList(3);
    }

    static {
        File f1 = new File("A");
        File f2 = new File("a");
        _isCaseSensitive = f1.equals(f2) ^ true;
    }

    public void registerHelper(String scheme, VirtualFileSystemHelper helper) {
        if (scheme == null) {
            throw new NullPointerException("scheme must not be null");
        }
        if ((scheme = scheme.trim()).length() == 0) {
            throw new IllegalArgumentException("cannot use empty string for scheme");
        }
        if (helper == null) {
            throw new NullPointerException("helper must not be null");
        }
        this._helpers.put(scheme, helper);
    }

    public VirtualFileSystemHelper findHelper(String scheme) {
        if (scheme == null) {
            throw new NullPointerException("scheme must not be null");
        }
        Object helper = this._helpers.get(scheme);
        return helper != null ? (VirtualFileSystemHelper)helper : this._defaultHelper;
    }

    public VirtualFileSystemHelper findHelper(URI uri) {
        if (uri == null) {
            return this._defaultHelper;
        }
        String scheme = uri.getScheme();
        return this.findHelper(scheme);
    }

    public void addExistsTest(URIExistsTest existsTest) {
        if (existsTest == null) {
            throw new NullPointerException("existsTest must not be null");
        }
        this._existsTests.add(existsTest);
    }

    public URI canonicalize(URI uri) throws IOException {
        return this.findHelper(uri).canonicalize(uri);
    }

    public boolean canRead(URI uri) {
        return this.findHelper(uri).canRead(uri);
    }

    public boolean canWrite(URI uri) {
        return this.findHelper(uri).canWrite(uri);
    }

    public boolean canCreate(URI uri) {
        return this.findHelper(uri).canCreate(uri);
    }

    public boolean isValid(URI uri) {
        return this.findHelper(uri).isValid(uri);
    }

    public URI convertSuffix(URI uri, String oldSuffix, String newSuffix) {
        return this.findHelper(uri).convertSuffix(uri, oldSuffix, newSuffix);
    }

    public void copy(URI src, URI dst) throws IOException {
        if (src == null) {
            throw new NullPointerException("src uri must not be null");
        }
        if (dst == null) {
            throw new NullPointerException("dst uri must not be null");
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            in = this.openInputStream(src);
            out = this.openOutputStream(dst);
            if (!this.mkdirs(this.getParent(dst))) {
                throw new IOException("Failed to create parent directories for " + dst);
            }
            VirtualFileSystem.copy(in, out);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void copy(InputStream in, URI dst) throws IOException {
        if (in == null) {
            throw new NullPointerException("in must not be null");
        }
        if (dst == null) {
            throw new NullPointerException("dst must not be null");
        }
        OutputStream out = null;
        try {
            out = this.openOutputStream(dst);
            this.mkdirs(this.getParent(dst));
            VirtualFileSystem.copy(in, out);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void copy(URI src, File dst) throws IOException {
        if (src == null) {
            throw new NullPointerException("src must not be null");
        }
        if (dst == null) {
            throw new NullPointerException("dst must not be null");
        }
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = this.openInputStream(src);
            out = new FileOutputStream(dst);
            dst.getParentFile().mkdirs();
            VirtualFileSystem.copy(in, out);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, bytesRead);
        }
    }

    public boolean delete(URI uri) {
        return this.findHelper(uri).delete(uri);
    }

    public URI ensureSuffix(URI uri, String suffix) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix must not be null");
        }
        return this.findHelper(uri).ensureSuffix(uri, suffix);
    }

    public boolean equals(URI uri1, URI uri2) {
        if (uri1 == uri2) {
            return true;
        }
        if (!VirtualFileSystem.schemesAreEqual(uri1, uri2)) {
            return false;
        }
        return this.findHelper(uri1).equals(uri1, uri2);
    }

    public boolean exists(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).exists(uri);
    }

    public String getFileName(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).getFileName(uri);
    }

    public long getLength(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).getLength(uri);
    }

    public String getName(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).getName(uri);
    }

    public URI getParent(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).getParent(uri);
    }

    public String getPath(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).getPath(uri);
    }

    public String getPathNoExt(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).getPathNoExt(uri);
    }

    public String getPlatformPathName(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).getPlatformPathName(uri);
    }

    public String getSuffix(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).getSuffix(uri);
    }

    public boolean hasSuffix(URI uri, String suffix) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix must not be null");
        }
        return this.findHelper(uri).hasSuffix(uri, suffix);
    }

    public boolean isBaseURIFor(URI uri1, URI uri2) {
        if (uri1 == null || uri2 == null) {
            return false;
        }
        if (uri1 == uri2) {
            return true;
        }
        if (!VirtualFileSystem.schemesAreEqual(uri1, uri2)) {
            return false;
        }
        return this.findHelper(uri1).isBaseURIFor(uri1, uri2);
    }

    public boolean isBound(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        for (URIExistsTest test : this._existsTests) {
            if (!test.uriExists(uri)) continue;
            return true;
        }
        return this.exists(uri);
    }

    public static boolean isLocalFileSystemCaseSensitive() {
        return _isCaseSensitive;
    }

    public boolean isDirectory(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).isDirectory(uri);
    }

    public boolean isDirectoryPath(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).isDirectoryPath(uri);
    }

    public boolean isHidden(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).isHidden(uri);
    }

    public boolean isReadOnly(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).isReadOnly(uri);
    }

    public boolean isRegularFile(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).isRegularFile(uri);
    }

    public boolean isRoot(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        URI[] roots = this.listRoots();
        int n = roots.length;
        int i = 0;
        while (i < n) {
            if (this.equals(uri, roots[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public long lastModified(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).lastModified(uri);
    }

    public URI[] list(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).list(uri);
    }

    public URI[] list(URI uri, URIFilter filter) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).list(uri, filter);
    }

    public URI[] listRoots() {
        ArrayList<URI> roots = new ArrayList<URI>(40);
        ArrayList helperKeys = new ArrayList(this._helpers.keySet());
        Collections.sort(helperKeys);
        Iterator iter = helperKeys.iterator();
        while (iter.hasNext()) {
            String scheme = iter.next().toString();
            VirtualFileSystemHelper helper = (VirtualFileSystemHelper)this._helpers.get(scheme);
            URI[] schemeRoots = helper.listRoots();
            if (schemeRoots == null) continue;
            roots.addAll(Arrays.asList(schemeRoots));
        }
        return roots.toArray(new URI[roots.size()]);
    }

    public boolean mkdir(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).mkdir(uri);
    }

    public boolean mkdirs(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).mkdirs(uri);
    }

    public URI createTempFile(String prefix, String suffix, URI directory) throws IOException {
        if (prefix == null || prefix.length() < 3) {
            throw new IllegalArgumentException("prefix must be at least three characters long");
        }
        return directory != null ? this.findHelper(directory).createTempFile(prefix, suffix, directory) : this.findHelper(FILE_SCHEME).createTempFile(prefix, suffix, null);
    }

    public InputStream openInputStream(URI uri) throws IOException {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).openInputStream(uri);
    }

    public OutputStream openOutputStream(URI uri) throws IOException {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).openOutputStream(uri);
    }

    public boolean renameTo(URI oldURI, URI newURI) {
        if (oldURI == null || newURI == null) {
            return false;
        }
        if (oldURI == newURI || oldURI.equals(newURI)) {
            return false;
        }
        if (!VirtualFileSystem.schemesAreEqual(oldURI, newURI)) {
            try {
                this.copy(oldURI, newURI);
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            return this.delete(oldURI);
        }
        return this.findHelper(oldURI).renameTo(oldURI, newURI);
    }

    public boolean setLastModified(URI uri, long time) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).setLastModified(uri, time);
    }

    public boolean setReadOnly(URI uri, boolean readOnly) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).setReadOnly(uri, readOnly);
    }

    public String toDisplayString(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        return this.findHelper(uri).toDisplayString(uri);
    }

    public String toRelativeSpec(URI uri, URI base) {
        if (uri == null) {
            throw new NullPointerException("uri must not be null");
        }
        if (base == null) {
            throw new NullPointerException("base must not be null");
        }
        return this.findHelper(uri).toRelativeSpec(uri, base);
    }

    public String toRelativeSpec(URI uri, URI base, boolean mustConsumeBase) {
        return this.findHelper(uri).toRelativeSpec(uri, base, mustConsumeBase);
    }

    public URI getBaseParent(URI uri, String relativeSpec) {
        return this.findHelper(uri).getBaseParent(uri, relativeSpec);
    }

    public URL toURL(URI uri) throws MalformedURLException {
        return this.findHelper(uri).toURL(uri);
    }

    private static boolean schemesAreEqual(URI uri1, URI uri2) {
        if (uri1 == null || uri2 == null) {
            return false;
        }
        String p1 = uri1.getScheme();
        String p2 = uri2.getScheme();
        return p1.equals(p2);
    }

    public static VirtualFileSystem getVirtualFileSystem() {
        try {
            VirtualFileSystem virtualFileSystem = (VirtualFileSystem)VirtualFileSystem.getService(VirtualFileSystem.class);
            return virtualFileSystem;
        }
        catch (ProviderNotFoundException lnfe) {
            lnfe.printStackTrace();
            throw new IllegalStateException("No virtual file system");
        }
    }

    public VirtualFileSystem() {
        this.$init$();
    }
}

