/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.ide.net.URIFilter;

public class VirtualFileSystemHelper {
    protected VirtualFileSystemHelper() {
    }

    public URI canonicalize(URI uri) throws IOException {
        return uri;
    }

    public boolean canRead(URI uri) {
        return false;
    }

    public boolean canWrite(URI uri) {
        return false;
    }

    public boolean canCreate(URI uri) {
        return true;
    }

    public boolean isValid(URI uri) {
        if (this.exists(uri)) {
            return true;
        }
        return this.canCreate(uri);
    }

    public URI convertSuffix(URI uri, String oldSuffix, String newSuffix) {
        String newPath;
        String path = uri.getPath();
        if (path.endsWith(oldSuffix)) {
            int suffixIndex = path.length() - oldSuffix.length();
            newPath = path.substring(0, suffixIndex) + newSuffix;
        } else {
            newPath = path + newSuffix;
        }
        return this.replacePathPart(uri, newPath);
    }

    public boolean delete(URI uri) {
        return false;
    }

    public URI ensureSuffix(URI uri, String suffix) {
        if (this.hasSuffix(uri, suffix)) {
            return uri;
        }
        String path = uri.getPath();
        return this.replacePathPart(uri, path + suffix);
    }

    public boolean equals(URI uri1, URI uri2) {
        return uri1.equals(uri2);
    }

    public boolean exists(URI uri) {
        return false;
    }

    public String getFileName(URI uri) {
        if (uri == null) {
            return "";
        }
        String path = uri.getPath();
        if (path == null || path.length() == 0) {
            return "";
        }
        if (path.equals("/")) {
            return "/";
        }
        int lastSep = path.lastIndexOf(47);
        if (lastSep == path.length() - 1) {
            int lastSep2 = path.lastIndexOf(47, lastSep - 1);
            return path.substring(lastSep2 + 1, lastSep);
        }
        return path.substring(lastSep + 1);
    }

    public long getLength(URI uri) {
        return -1;
    }

    public String getName(URI uri) {
        String fileName = this.getFileName(uri);
        int firstDot = fileName.indexOf(46);
        return firstDot > 0 ? fileName.substring(0, firstDot) : fileName;
    }

    public URI getParent(URI uri) {
        return uri != null ? uri.resolve("..") : null;
    }

    public String getPath(URI uri) {
        return uri.getPath();
    }

    public String getPathNoExt(URI uri) {
        String path = this.getPath(uri);
        int lastSlash = path.lastIndexOf("/");
        int lastDot = path.lastIndexOf(".");
        if (lastDot <= lastSlash) {
            return path;
        }
        return path.substring(0, lastDot);
    }

    public String getPlatformPathName(URI uri) {
        return uri != null ? uri.toString() : "";
    }

    public String getSuffix(URI uri) {
        String path = uri.getPath();
        int lastDot = path.lastIndexOf(46);
        int lastSlash = path.lastIndexOf(47);
        return lastDot >= 0 && lastDot > lastSlash ? path.substring(lastDot) : "";
    }

    public boolean hasSuffix(URI uri, String suffix) {
        String path = uri.getPath();
        return path.endsWith(suffix);
    }

    public boolean isBaseURIFor(URI uri1, URI uri2) {
        if (!this.isDirectoryPath(uri1)) {
            return false;
        }
        String uri1String = uri1.toString();
        String uri2String = uri2.toString();
        return uri2String.startsWith(uri1String);
    }

    public boolean isDirectory(URI uri) {
        return false;
    }

    public boolean isDirectoryPath(URI uri) {
        return uri != null && uri.getPath().endsWith("/") && uri.getQuery() == null && uri.getFragment() == null;
    }

    public boolean isHidden(URI uri) {
        return false;
    }

    public boolean isReadOnly(URI uri) {
        return true;
    }

    public boolean isRegularFile(URI uri) {
        return this.exists(uri) && !this.isDirectory(uri);
    }

    public long lastModified(URI uri) {
        return -1;
    }

    public URI[] list(URI uri) {
        return new URI[0];
    }

    public URI[] list(URI uri, URIFilter filter) {
        URI[] list = this.list(uri);
        if (list == null) {
            return null;
        }
        if (filter == null) {
            return list;
        }
        ArrayList<URI> filteredList = new ArrayList<URI>();
        int i = list.length - 1;
        while (i >= 0) {
            URI fileURI = list[i];
            if (filter.accept(fileURI)) {
                filteredList.add(fileURI);
            }
            --i;
        }
        return filteredList.toArray(new URI[filteredList.size()]);
    }

    public URI[] listRoots() {
        return null;
    }

    public boolean mkdir(URI uri) {
        return false;
    }

    public boolean mkdirs(URI uri) {
        return false;
    }

    public URI createTempFile(String prefix, String suffix, URI directory) throws IOException {
        return null;
    }

    public InputStream openInputStream(URI uri) throws IOException {
        throw new UnknownServiceException();
    }

    public OutputStream openOutputStream(URI uri) throws IOException {
        throw new UnknownServiceException();
    }

    public boolean renameTo(URI oldURI, URI newURI) {
        return false;
    }

    public boolean setLastModified(URI uri, long time) {
        return false;
    }

    public boolean setReadOnly(URI uri, boolean readOnly) {
        return false;
    }

    public String toDisplayString(URI uri) {
        return uri == null ? "" : uri.toString();
    }

    public String toRelativeSpec(URI uri, URI base) {
        return this.toRelativeSpec(uri, base, false);
    }

    public String toRelativeSpec(URI uri, URI base, boolean mustConsumeBase) {
        if (!this.haveSameScheme(uri, base) || !this.haveSameAuthority(uri, base)) {
            return mustConsumeBase ? null : uri.toString();
        }
        StringBuffer relativeURI = new StringBuffer();
        boolean baseFullyConsumed = this.appendRelativePath(uri, base, relativeURI, mustConsumeBase);
        if (mustConsumeBase && !baseFullyConsumed) {
            return null;
        }
        return relativeURI.toString();
    }

    public URI getBaseParent(URI uri, String relativeSpec) {
        String basePath = uri.getPath();
        int basePathIndex = basePath.lastIndexOf(47);
        if (basePathIndex < basePath.length() - 1) {
            uri = this.getParent(uri);
            basePath = uri.getPath();
        }
        String baseDir = basePath.substring(0, basePathIndex);
        int relPathIndex = relativeSpec.lastIndexOf(47);
        if (relPathIndex < 0) {
            return uri;
        }
        String relDir = relativeSpec.substring(0, relativeSpec.lastIndexOf(47));
        StringTokenizer relTokenizer = new StringTokenizer(relDir, "/");
        String relToken = relTokenizer.nextToken();
        StringTokenizer baseTokenizer = new StringTokenizer(baseDir, "/");
        int ctr = 0;
        boolean foundBasePath = false;
        while (baseTokenizer.hasMoreTokens()) {
            String baseToken = baseTokenizer.nextToken();
            if (this.areEqualPathElems(relToken, baseToken)) {
                int relCount;
                int baseCount = baseTokenizer.countTokens();
                if (baseCount != (relCount = relTokenizer.countTokens())) continue;
                if (relCount != 0) {
                    relToken = relTokenizer.nextToken();
                    ++ctr;
                    continue;
                }
                foundBasePath = true;
                break;
            }
            if (ctr == 0) continue;
            ctr = 0;
            break;
        }
        if (foundBasePath) {
            int i = ctr;
            while (i >= 0) {
                uri = this.getParent(uri);
                --i;
            }
        }
        return uri;
    }

    public URL toURL(URI uri) throws MalformedURLException {
        return uri.toURL();
    }

    protected boolean haveSameUserInfo(URI uri1, URI uri2) {
        return this.areEqual(uri1.getUserInfo(), uri2.getUserInfo());
    }

    protected boolean haveSameHost(URI uri1, URI uri2) {
        return this.areEqual(uri1.getHost(), uri2.getHost());
    }

    protected boolean haveSamePath(URI uri1, URI uri2) {
        return this.areEqual(uri1.getPath(), uri2.getPath());
    }

    protected boolean haveSameQuery(URI uri1, URI uri2) {
        return this.areEqual(uri1.getQuery(), uri2.getQuery());
    }

    protected boolean haveSameRef(URI uri1, URI uri2) {
        return this.areEqual(uri1.getFragment(), uri2.getFragment());
    }

    protected boolean haveSamePort(URI uri1, URI uri2) {
        return uri1.getPort() == uri2.getPort();
    }

    protected final boolean areEqual(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equals(s2);
    }

    protected boolean haveSameScheme(URI uri, URI base) {
        if (uri == null || base == null) {
            return false;
        }
        String uriScheme = uri.getScheme();
        String baseScheme = base.getScheme();
        return uriScheme.equals(baseScheme);
    }

    protected boolean haveSameAuthority(URI uri, URI base) {
        if (uri == base) {
            return true;
        }
        if (uri == null || base == null) {
            return false;
        }
        String uriAuthority = uri.getAuthority();
        String baseAuthority = base.getAuthority();
        if (uriAuthority == null) {
            return baseAuthority == null;
        }
        if (baseAuthority != null) {
            return uriAuthority.equals(baseAuthority);
        }
        return false;
    }

    protected boolean appendRelativePath(URI uri, URI base, StringBuffer relativeURI, boolean mustConsumeBase) {
        boolean baseFullyConsumed;
        String uriPath = uri.getPath();
        int uriLastSlash = uriPath.lastIndexOf(47);
        String uriDir = uriPath.substring(0, uriLastSlash);
        String uriFileName = uriPath.substring(uriLastSlash + 1);
        StringTokenizer uriTokenizer = new StringTokenizer(uriDir, "/");
        String basePath = base.getPath();
        String baseDir = basePath.substring(0, basePath.lastIndexOf(47));
        StringTokenizer baseTokenizer = new StringTokenizer(baseDir, "/");
        int numBaseTokens = baseTokenizer.countTokens();
        int numMatches = 0;
        String uriToken = null;
        while (uriTokenizer.hasMoreTokens() && baseTokenizer.hasMoreTokens()) {
            String baseToken;
            uriToken = uriTokenizer.nextToken();
            if (!this.areEqualPathElems(uriToken, baseToken = baseTokenizer.nextToken())) break;
            ++numMatches;
            uriToken = null;
        }
        boolean bl = baseFullyConsumed = numBaseTokens == numMatches;
        if (mustConsumeBase && !baseFullyConsumed) {
            return false;
        }
        if (numMatches == 0) {
            relativeURI.append(uriPath);
        } else {
            int numDotDotsNeeded;
            int i = numDotDotsNeeded = numBaseTokens - numMatches;
            while (i > 0) {
                relativeURI.append("../");
                --i;
            }
            if (uriToken != null && uriToken.length() > 0) {
                if (numDotDotsNeeded == 0 && uriToken.indexOf(58) >= 0) {
                    relativeURI.append("./");
                }
                relativeURI.append(uriToken).append('/');
            }
            while (uriTokenizer.hasMoreTokens()) {
                relativeURI.append(uriTokenizer.nextToken()).append('/');
            }
            relativeURI.append(uriFileName);
        }
        return baseFullyConsumed;
    }

    protected boolean areEqualPathElems(String uriElem, String baseElem) {
        return uriElem.equals(baseElem);
    }

    private URI replacePathPart(URI uri, String newPath) {
        try {
            URI uRI = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), newPath, uri.getQuery(), uri.getFragment());
            return uRI;
        }
        catch (Exception e) {
            e.printStackTrace();
            URI uRI = null;
            return uRI;
        }
    }
}

