/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.property.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.I18NStringVisitor;
import javax.ide.property.spi.PropertyPageInfo;
import javax.ide.util.MetaClass;

public final class PropertyHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "property-hook");
    private static final ElementName PROPERTY_PAGES = new ElementName("http://jcp.org/jsr/198/extension-manifest", "property-pages");
    private static final ElementName PROPERTY_PAGE = new ElementName("http://jcp.org/jsr/198/extension-manifest", "property-page");
    private static final ElementName LABEL = new ElementName("http://jcp.org/jsr/198/extension-manifest", "label");
    private static final ElementName OBJECT_CLASS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "object-class");
    private static final String KEY_INFO = "propertyInfo";
    private final ElementVisitor _propertyPagesVisitor;
    private final ElementVisitor _propertyPageVisitor;
    private final ElementVisitor _labelVisitor;
    private final ElementVisitor _objectClassVisitor;
    private Collection _propertyPageInfos;

    private void $init$() {
        this._propertyPagesVisitor = new PropertyPagesVisitor(null);
        this._propertyPageVisitor = new PropertyPageVisitor(null);
        this._labelVisitor = new LabelVisitor(null);
        this._objectClassVisitor = new ObjectClassVisitor(null);
        this._propertyPageInfos = new ArrayList();
    }

    public Collection getPropertyPageInfos() {
        return this._propertyPageInfos;
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(PROPERTY_PAGES, this._propertyPagesVisitor);
    }

    private PropertyPageInfo getInfo(ElementContext context) {
        return (PropertyPageInfo)context.getScopeData().get(KEY_INFO);
    }

    public PropertyHook() {
        this.$init$();
    }

    static ElementName ra$PROPERTY_PAGE() {
        return PROPERTY_PAGE;
    }

    static ElementVisitor ra$_propertyPageVisitor(PropertyHook propertyHook) {
        return propertyHook._propertyPageVisitor;
    }

    static PropertyPageInfo mav$getInfo(PropertyHook propertyHook, ElementContext elementContext) {
        return propertyHook.getInfo(elementContext);
    }

    static Collection ra$_propertyPageInfos(PropertyHook propertyHook) {
        return propertyHook._propertyPageInfos;
    }

    static ElementName ra$LABEL() {
        return LABEL;
    }

    static ElementVisitor ra$_labelVisitor(PropertyHook propertyHook) {
        return propertyHook._labelVisitor;
    }

    static ElementName ra$OBJECT_CLASS() {
        return OBJECT_CLASS;
    }

    static ElementVisitor ra$_objectClassVisitor(PropertyHook propertyHook) {
        return propertyHook._objectClassVisitor;
    }

    private class PropertyPagesVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            context.registerChildVisitor(PropertyHook.ra$PROPERTY_PAGE(), PropertyHook.ra$_propertyPageVisitor(PropertyHook.this));
        }

        private PropertyPagesVisitor() {
        }

        PropertyPagesVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class PropertyPageVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String clz = context.getAttributeValue("property-page-class");
            if (clz == null || (clz = clz.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Missing required attribute 'property-page-class'");
                return;
            }
            ClassLoader cl = (ClassLoader)context.getScopeData().get("classLoader");
            MetaClass pageClass = new MetaClass(cl, clz);
            PropertyPageInfo info = new PropertyPageInfo();
            info.setPageClass(pageClass);
            String parent = context.getAttributeValue("parent-page");
            info.setParentPage(parent);
            context.getScopeData().put(PropertyHook.KEY_INFO, info);
            context.registerChildVisitor(PropertyHook.ra$LABEL(), PropertyHook.ra$_labelVisitor(PropertyHook.this));
            context.registerChildVisitor(PropertyHook.ra$OBJECT_CLASS(), PropertyHook.ra$_objectClassVisitor(PropertyHook.this));
        }

        public void end(ElementEndContext context) {
            PropertyPageInfo info = PropertyHook.mav$getInfo(PropertyHook.this, context);
            if (info.getLabel() == null) {
                this.log(context, Level.SEVERE, "Label required.");
                return;
            }
            if (info.getObjectClass() == null) {
                this.log(context, Level.SEVERE, "Object class required.");
                return;
            }
            PropertyHook.ra$_propertyPageInfos(PropertyHook.this).add(info);
        }

        private PropertyPageVisitor() {
        }

        PropertyPageVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class LabelVisitor
    extends I18NStringVisitor {
        public void string(ElementContext context, String value) {
            PropertyPageInfo info = PropertyHook.mav$getInfo(PropertyHook.this, context);
            info.setLabel(value);
        }

        private LabelVisitor() {
        }

        LabelVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class ObjectClassVisitor
    extends ElementVisitor {
        public void end(ElementEndContext context) {
            String text = context.getText();
            if (text != null && (text = text.trim()).length() > 0) {
                if (!"javax.ide.IDE".equals(text) && !"javax.ide.model.Project".equals(text)) {
                    this.log(context, Level.SEVERE, "Must be either 'javax.ide.IDE' or 'javax.ide.model.Project'.");
                    return;
                }
                PropertyHook.mav$getInfo(PropertyHook.this, context).setObjectClass(text);
            }
        }

        private ObjectClassVisitor() {
        }

        ObjectClassVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

