/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph<T>
extends AbstractCollection<T> {
    protected Map<T, Vertex<T>> _vertices;

    private void $init$() {
        this._vertices = new LinkedHashMap<T, Vertex<T>>();
    }

    public Graph(Graph<T> original) {
        this.$init$();
        this._vertices.putAll(original._vertices);
    }

    public Graph() {
        this.$init$();
    }

    public Comparator<T> createComparator() throws CycleException {
        List<T> sorted = this.getSortedVertices();
        return new 1(this, sorted);
    }

    public Graph(Collection<T> vertices) {
        this.$init$();
        this.addAll(vertices);
    }

    @Override
    public boolean contains(Object vertex) {
        return this._vertices.containsKey(vertex);
    }

    @Override
    public boolean add(T vertex) {
        if (this._vertices.containsKey(vertex)) {
            throw new IllegalArgumentException("Already in graph: " + vertex);
        }
        this._vertices.put(vertex, new Vertex<T>(vertex));
        return true;
    }

    public void connect(T from, T to) {
        try {
            Vertex<T> fromVertex = this._vertices.get(from);
            if (fromVertex == null) {
                throw new IllegalArgumentException("from vertex is not in graph: " + from);
            }
            Vertex<T> toVertex = this._vertices.get(to);
            if (toVertex == null) {
                throw new IllegalArgumentException("to vertex is not in graph: " + to);
            }
            this.connectVertices(fromVertex, toVertex);
        }
        catch (CycleException ce) {
            throw new IllegalArgumentException(ce);
        }
    }

    public List<T> getOutwardEdges(T from) {
        Vertex<T> v = this._vertices.get(from);
        if (v == null) {
            throw new IllegalArgumentException("Not in graph: " + from);
        }
        return this.verticesToData(Vertex.ra$_toEdges(v));
    }

    public List<T> getInwardEdges(T to) {
        Vertex<T> v = this._vertices.get(to);
        if (v == null) {
            throw new IllegalArgumentException("Not in graph: " + to);
        }
        return this.verticesToData(Vertex.ra$_fromEdges(v));
    }

    private List<T> verticesToData(List<Vertex> l) {
        ArrayList connections = new ArrayList(l.size());
        for (Vertex vertex : l) {
            connections.add(vertex.getData());
        }
        return Collections.unmodifiableList(connections);
    }

    private void connectVertices(Vertex<T> from, Vertex<T> to) throws CycleException {
        if (from == to) {
            throw new CycleException(to.getData(), Collections.singletonList(from.getData()));
        }
        Vertex.ra$_fromEdges(to).add(from);
        Vertex.ra$_toEdges(from).add(to);
    }

    public Graph<T> subgraph(Collection<T> vertices) {
        Graph<T> newGraph = new Graph<T>(this);
        newGraph.retainAll(vertices);
        return newGraph;
    }

    @Override
    public Iterator<T> iterator() {
        Iterator<T> delegate = this._vertices.keySet().iterator();
        return new 2(this, delegate);
    }

    @Override
    public boolean remove(Object vertex) {
        this.removeAllReferencesTo(vertex);
        return this._vertices.remove(vertex) != null;
    }

    private void removeAllReferencesTo(T vertex) {
        for (Vertex<T> v : this._vertices.values()) {
            Vertex.ra$_fromEdges(v).remove(this._vertices.get(vertex));
            Vertex.ra$_toEdges(v).remove(this._vertices.get(vertex));
        }
    }

    @Override
    public int size() {
        return this._vertices.size();
    }

    public List<T> getSortedVertices() throws CycleException {
        return this.getSortedVertices(null);
    }

    public List<T> getSortedVertices(T startVertex) throws CycleException {
        HashMap colors = new HashMap(this._vertices.size());
        ArrayList sortedList = new ArrayList(this._vertices.size());
        if (startVertex != null) {
            Color c = (Color)((Object)colors.get(startVertex));
            if (c == null) {
                this.visit(new ArrayList(), colors, startVertex, sortedList);
            }
        } else {
            for (T t : this) {
                Color c = (Color)((Object)colors.get(t));
                if (c != null) continue;
                this.visit(new ArrayList(), colors, t, sortedList);
            }
        }
        Collections.reverse(sortedList);
        return Collections.unmodifiableList(sortedList);
    }

    private void visit(List<T> visiting, Map<T, Color> colors, T vertex, List<T> sortedList) throws CycleException {
        colors.put(vertex, Color.VISITING);
        visiting.add(vertex);
        for (Vertex to : this._vertices.get(vertex)) {
            Color color = colors.get(to.getData());
            if (color == Color.VISITING) {
                throw new CycleException(to.getData(), visiting);
            }
            if (color == Color.VISITED) continue;
            this.visit(visiting, colors, to.getData(), sortedList);
        }
        sortedList.add(vertex);
        visiting.remove(vertex);
        colors.put(vertex, Color.VISITED);
    }

    public List<T> getVerticesConnectedTo(T vertex) throws CycleException {
        if (vertex == null) {
            throw new NullPointerException("vertex is null");
        }
        ArrayList vertices = new ArrayList();
        HashMap colors = new HashMap();
        this.visitInReverse(colors, vertex, vertices);
        vertices.remove(vertex);
        return Collections.unmodifiableList(vertices);
    }

    private void visitInReverse(Map<T, Color> colors, T startVertex, List<T> vertices) throws CycleException {
        colors.put(startVertex, Color.VISITING);
        Vertex<T> v = this._vertices.get(startVertex);
        List from = Vertex.ra$_fromEdges(v);
        for (Vertex fromVertex : from) {
            Color color = colors.get(fromVertex.getData());
            if (color == Color.VISITING) {
                throw new CycleException(fromVertex.getData(), vertices);
            }
            if (color == Color.VISITED) continue;
            this.visitInReverse(colors, fromVertex.getData(), vertices);
        }
        vertices.add(startVertex);
        colors.put(startVertex, Color.VISITED);
    }

    public static <Z> Graph<Z> unmodifiableGraph(Graph<? extends Z> graph) {
        return new UnmodifiableGraph<Z>(graph);
    }

    static void mav$removeAllReferencesTo(Graph graph, Object object) {
        graph.removeAllReferencesTo(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class 1
    implements Comparator {
        private final /* synthetic */ List v$sorted;
        final /* synthetic */ Graph this$0;

        @Override
        public int compare(T o1, T o2) {
            return this.v$sorted.indexOf(o1) - this.v$sorted.indexOf(o2);
        }

        public 1(Graph graph, List list) {
            this.v$sorted = list;
            this.this$0 = graph;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class 2
    implements Iterator {
        private T current;
        private final /* synthetic */ Iterator v$delegate;
        final /* synthetic */ Graph this$0;

        private void $init$() {
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.v$delegate.hasNext();
        }

        public T next() {
            this.current = this.v$delegate.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException("You must use next() before remove()");
            }
            Graph.mav$removeAllReferencesTo(this.this$0, this.current);
            this.v$delegate.remove();
        }

        public 2(Graph graph, Iterator iterator) {
            this.v$delegate = iterator;
            this.this$0 = graph;
            this.$init$();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Vertex<T>
    implements Iterable<Vertex> {
        private final T _data;
        private final List<Vertex> _toEdges;
        private final List<Vertex> _fromEdges;

        private void $init$() {
            this._toEdges = new ArrayList<Vertex>();
            this._fromEdges = new ArrayList<Vertex>();
        }

        Vertex(T data) {
            this.$init$();
            this._data = data;
        }

        public T getData() {
            return this._data;
        }

        @Override
        public Iterator<Vertex> iterator() {
            return this._toEdges.iterator();
        }

        static List ra$_fromEdges(Vertex vertex) {
            return vertex._fromEdges;
        }

        static List ra$_toEdges(Vertex vertex) {
            return vertex._toEdges;
        }
    }

    public static class CycleException
    extends Exception {
        private List vertices;
        private Object vertex;

        CycleException(Object vertex, List vertices) {
            this.vertices = vertices;
            this.vertex = vertex;
        }

        public String getMessage() {
            if (this.vertices.size() == 1 && this.vertex == this.vertices.get(0)) {
                return this.vertex + " depends on itself";
            }
            return this.vertex + " is in a dependency cycle: " + this.getDependencyChain();
        }

        public String getDependencyChain() {
            StringBuffer b = new StringBuffer();
            ArrayList l = new ArrayList(this.vertices);
            Collections.reverse(l);
            b.append(String.valueOf(this.vertex));
            for (Object t : l) {
                b.append("\n->");
                b.append(String.valueOf(t));
                if (t == this.vertex) break;
            }
            b.append("\n");
            return b.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Color
    extends Enum<Color> {
        private static final /* synthetic */ Color[] $v;
        public static final /* enum */ Color VISITING;
        public static final /* enum */ Color VISITED;

        public static Color valueOf(String string) {
            return Enum.valueOf(Color.class, string);
        }

        public static final Color[] values() {
            return (Color[])$v.clone();
        }

        static {
            Color[] colorArray = new Color[2];
            colorArray[1] = VISITED = new Color("VISITED", 1);
            colorArray[0] = VISITING = new Color("VISITING", 0);
            $v = colorArray;
        }

        private Color(String string2, int n2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableGraph<E>
    extends Graph<E> {
        private Graph<E> _graph;

        UnmodifiableGraph(Graph<E> g) {
            this._graph = g;
        }

        @Override
        public boolean equals(Object o) {
            return this._graph.equals(o);
        }

        @Override
        public int hashCode() {
            return this._graph.hashCode();
        }

        @Override
        public int size() {
            return this._graph.size();
        }

        @Override
        public boolean isEmpty() {
            return this._graph.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this._graph.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this._graph.toArray();
        }

        @Override
        public <E> E[] toArray(E[] a) {
            return this._graph.toArray(a);
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void connect(E e, E e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            Iterator<E> i = this._graph.iterator();
            return new 1(this, i);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class 1
        implements Iterator {
            private final /* synthetic */ Iterator v$i;
            final /* synthetic */ UnmodifiableGraph this$0;

            @Override
            public boolean hasNext() {
                return this.v$i.hasNext();
            }

            @Override
            public E next() {
                return this.v$i.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public 1(UnmodifiableGraph unmodifiableGraph, Iterator iterator) {
                this.v$i = iterator;
                this.this$0 = unmodifiableGraph;
            }
        }
    }
}

