/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.util;

import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.ide.util.MissingIconException;

public abstract class IconDescription {
    private URL _url;

    private IconDescription() {
    }

    public static IconDescription createInstance(URL url) {
        return new 1(url);
    }

    public static IconDescription createResourceInstance(ClassLoader loader, String bundleClass, String key) {
        return new 2(bundleClass, loader, key);
    }

    public static IconDescription createPathInstance(ClassLoader loader, String path) {
        return new 3(loader, path);
    }

    protected abstract URL resolveURL() throws MissingIconException;

    public URL getURL() throws MissingIconException {
        if (this._url == null) {
            this._url = this.resolveURL();
        }
        return this._url;
    }

    IconDescription(3 var1_1) {
        this();
    }

    IconDescription(2 var1_1) {
        this();
    }

    IconDescription(1 var1_1) {
        this();
    }

    static final class 1
    extends IconDescription {
        private final /* synthetic */ URL v$url;

        protected URL resolveURL() throws MissingIconException {
            return this.v$url;
        }

        public 1(URL uRL) {
            this.v$url = uRL;
            super((1)null);
        }
    }

    static final class 2
    extends IconDescription {
        private final /* synthetic */ String v$bundleClass;
        private final /* synthetic */ ClassLoader v$loader;
        private final /* synthetic */ String v$key;

        protected URL resolveURL() throws MissingIconException {
            ResourceBundle bundle;
            try {
                bundle = ResourceBundle.getBundle(this.v$bundleClass, Locale.getDefault(), this.v$loader);
            }
            catch (MissingResourceException mre) {
                throw new MissingIconException("Resource bundle " + this.v$bundleClass + " not found.", mre);
            }
            try {
                String path = bundle.getString(this.v$key);
                if (path == null || path.trim().length() == 0) {
                    throw new MissingIconException("Icon key " + this.v$key + " has empty value in bundle " + this.v$bundleClass);
                }
                Class<?> bundleClass = bundle.getClass();
                URL result = bundleClass.getResource(path);
                if (result == null) {
                    throw new MissingIconException("Icon path " + path + " does not exist. Specified by key " + this.v$key + " in bundle " + bundleClass);
                }
                URL uRL = result;
                return uRL;
            }
            catch (MissingResourceException mre) {
                throw new MissingIconException("Icon key " + this.v$key + " not defined in bundle " + this.v$bundleClass, mre);
            }
        }

        public 2(String string, ClassLoader classLoader, String string2) {
            this.v$key = string2;
            this.v$loader = classLoader;
            this.v$bundleClass = string;
            super((2)null);
        }
    }

    static final class 3
    extends IconDescription {
        private final /* synthetic */ ClassLoader v$loader;
        private final /* synthetic */ String v$path;

        protected URL resolveURL() throws MissingIconException {
            URL resource = this.v$loader.getResource(this.v$path);
            if (resource == null) {
                throw new MissingIconException("Icon path " + this.v$path + " not found.");
            }
            return resource;
        }

        public 3(ClassLoader classLoader, String string) {
            this.v$path = string;
            this.v$loader = classLoader;
            super((3)null);
        }
    }
}

