/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.wizard.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.I18NStringVisitor;
import javax.ide.extension.IconVisitor;
import javax.ide.util.IconDescription;
import javax.ide.util.MetaClass;
import javax.ide.wizard.spi.WizardCategory;
import javax.ide.wizard.spi.WizardInfo;

public final class WizardHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "wizard-hook");
    private static final ElementName WIZARDS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "wizards");
    private static final ElementName WIZARD = new ElementName("http://jcp.org/jsr/198/extension-manifest", "wizard");
    private static final ElementName WIZARD_CATEGORY = new ElementName("http://jcp.org/jsr/198/extension-manifest", "wizard-category");
    private static final ElementName LABEL = new ElementName("http://jcp.org/jsr/198/extension-manifest", "label");
    private static final ElementName ICONPATH = new ElementName("http://jcp.org/jsr/198/extension-manifest", "iconpath");
    private static final ElementName TOOLTIP = new ElementName("http://jcp.org/jsr/198/extension-manifest", "tooltip");
    private static final String KEY_WIZARD_INFO = "wizardInfo";
    private static final String KEY_CATEGORY = "wizardCategory";
    private ElementVisitor _wizardsVisitor;
    private ElementVisitor _wizardVisitor;
    private ElementVisitor _labelVisitor;
    private ElementVisitor _iconpathVisitor;
    private ElementVisitor _tooltipVisitor;
    private ElementVisitor _wizardCategoryVisitor;
    private final Map _wizardsByClass;
    private final Map _categoriesById;
    private final Map _categoryChildren;

    private void $init$() {
        this._wizardsVisitor = new WizardsVisitor(null);
        this._wizardVisitor = new WizardVisitor(null);
        this._labelVisitor = new LabelVisitor(null);
        this._iconpathVisitor = new IconPathVisitor(null);
        this._tooltipVisitor = new ToolTipVisitor(null);
        this._wizardCategoryVisitor = new WizardCategoryVisitor(null);
        this._wizardsByClass = new HashMap();
        this._categoriesById = new HashMap();
        this._categoryChildren = new HashMap();
    }

    public WizardInfo getWizardInfo(String className) {
        WizardInfo info = (WizardInfo)this._wizardsByClass.get(className);
        if (info == null) {
            throw new IllegalArgumentException("Unknown wizard class " + className);
        }
        return info;
    }

    public Collection getChildren(WizardCategory category) {
        if (category == null) {
            throw new NullPointerException("Null category");
        }
        return Collections.unmodifiableCollection(this.getCategoryChildren(category));
    }

    private Collection getCategoryChildren(WizardCategory parent) {
        ArrayList children = (ArrayList)this._categoryChildren.get(parent);
        if (children == null) {
            children = new ArrayList();
            this._categoryChildren.put(parent, children);
        }
        return children;
    }

    public Collection getAllWizardClasses() {
        return Collections.unmodifiableCollection(this._wizardsByClass.keySet());
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(WIZARDS, this._wizardsVisitor);
    }

    private static WizardInfo getWizardInfo(ElementContext context) {
        return (WizardInfo)context.getScopeData().get(KEY_WIZARD_INFO);
    }

    public WizardHook() {
        this.$init$();
    }

    static ElementName ra$WIZARD() {
        return WIZARD;
    }

    static ElementVisitor ra$_wizardVisitor(WizardHook wizardHook) {
        return wizardHook._wizardVisitor;
    }

    static ElementName ra$WIZARD_CATEGORY() {
        return WIZARD_CATEGORY;
    }

    static ElementVisitor ra$_wizardCategoryVisitor(WizardHook wizardHook) {
        return wizardHook._wizardCategoryVisitor;
    }

    static Map ra$_categoriesById(WizardHook wizardHook) {
        return wizardHook._categoriesById;
    }

    static Collection mav$getCategoryChildren(WizardHook wizardHook, WizardCategory wizardCategory) {
        return wizardHook.getCategoryChildren(wizardCategory);
    }

    static ElementName ra$LABEL() {
        return LABEL;
    }

    static WizardInfo maS$getWizardInfo(ElementContext elementContext) {
        return WizardHook.getWizardInfo(elementContext);
    }

    static Map ra$_wizardsByClass(WizardHook wizardHook) {
        return wizardHook._wizardsByClass;
    }

    static ElementVisitor ra$_labelVisitor(WizardHook wizardHook) {
        return wizardHook._labelVisitor;
    }

    static ElementName ra$ICONPATH() {
        return ICONPATH;
    }

    static ElementVisitor ra$_iconpathVisitor(WizardHook wizardHook) {
        return wizardHook._iconpathVisitor;
    }

    static ElementName ra$TOOLTIP() {
        return TOOLTIP;
    }

    static ElementVisitor ra$_tooltipVisitor(WizardHook wizardHook) {
        return wizardHook._tooltipVisitor;
    }

    private class WizardsVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            context.registerChildVisitor(WizardHook.ra$WIZARD(), WizardHook.ra$_wizardVisitor(WizardHook.this));
            context.registerChildVisitor(WizardHook.ra$WIZARD_CATEGORY(), WizardHook.ra$_wizardCategoryVisitor(WizardHook.this));
        }

        private WizardsVisitor() {
        }

        WizardsVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class WizardCategoryVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String id = context.getAttributeValue("id");
            if (id == null || (id = id.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Missing required 'id' attribute.");
                return;
            }
            WizardCategory parent = WizardCategory.NONE;
            String parentCategory = context.getAttributeValue("parent-category");
            if (parentCategory != null) {
                parentCategory = parentCategory.trim();
                parent = (WizardCategory)WizardHook.ra$_categoriesById(WizardHook.this).get(parentCategory);
                if (parent == null) {
                    this.log(context, Level.WARNING, "Wizard category '" + parentCategory + "' not found.");
                    parent = WizardCategory.NONE;
                }
            }
            WizardCategory cat = new WizardCategory(parent, id);
            context.getScopeData().put(WizardHook.KEY_CATEGORY, cat);
            WizardHook.ra$_categoriesById(WizardHook.this).put(id, cat);
            WizardHook.mav$getCategoryChildren(WizardHook.this, parent).add(cat);
            context.registerChildVisitor(WizardHook.ra$LABEL(), new 1());
        }

        public void end(ElementEndContext context) {
            WizardCategory c = (WizardCategory)context.getScopeData().get(WizardHook.KEY_CATEGORY);
            if (c.getLabel() == null) {
                this.log(context, Level.WARNING, "Missing label element for category.");
                c.setLabel(c.getId());
            }
        }

        private WizardCategoryVisitor() {
        }

        WizardCategoryVisitor(1 var2_2) {
            this();
        }

        final class 1
        extends I18NStringVisitor {
            protected void string(ElementContext context, String string) {
                WizardCategory c = (WizardCategory)context.getScopeData().get(WizardHook.KEY_CATEGORY);
                c.setLabel(string);
            }
        }
    }

    private class WizardVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String className = context.getAttributeValue("wizard-class");
            if (className == null || (className = className.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Missing required 'wizard-class' attribute.");
                return;
            }
            String parentId = context.getAttributeValue("category-ref");
            WizardCategory parent = WizardCategory.NONE;
            if (parentId != null && (parentId = parentId.trim()).length() > 0 && (parent = (WizardCategory)WizardHook.ra$_categoriesById(WizardHook.this).get(parentId)) == null) {
                this.log(context, Level.WARNING, "Unknown category id '" + parentId + "'.");
                parent = WizardCategory.NONE;
            }
            MetaClass clazz = new MetaClass((ClassLoader)context.getScopeData().get("classLoader"), className);
            WizardInfo info = new WizardInfo(clazz);
            WizardHook.mav$getCategoryChildren(WizardHook.this, parent).add(info);
            info.setCategory(parent);
            context.getScopeData().put(WizardHook.KEY_WIZARD_INFO, info);
            context.registerChildVisitor(WizardHook.ra$LABEL(), WizardHook.ra$_labelVisitor(WizardHook.this));
            context.registerChildVisitor(WizardHook.ra$ICONPATH(), WizardHook.ra$_iconpathVisitor(WizardHook.this));
            context.registerChildVisitor(WizardHook.ra$TOOLTIP(), WizardHook.ra$_tooltipVisitor(WizardHook.this));
        }

        public void end(ElementEndContext context) {
            WizardInfo wi = WizardHook.maS$getWizardInfo(context);
            WizardHook.ra$_wizardsByClass(WizardHook.this).put(wi.getWizardClass().getClassName(), wi);
        }

        private WizardVisitor() {
        }

        WizardVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class LabelVisitor
    extends I18NStringVisitor {
        protected void string(ElementContext context, String value) {
            WizardHook.maS$getWizardInfo(context).setLabel(value);
        }

        private LabelVisitor() {
        }

        LabelVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class IconPathVisitor
    extends IconVisitor {
        protected void icon(ElementContext context, IconDescription icon) {
            WizardHook.maS$getWizardInfo(context).setIcon(icon);
        }

        private IconPathVisitor() {
        }

        IconPathVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ToolTipVisitor
    extends I18NStringVisitor {
        protected void string(ElementContext context, String value) {
            WizardHook.maS$getWizardInfo(context).setToolTip(value);
        }

        private ToolTipVisitor() {
        }

        ToolTipVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

