/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.transfer;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.transfer.TransferManager;
import oracle.ide.db.transfer.TransferState;
import oracle.ide.db.transfer.TransferTarget;
import oracle.ide.wizard.Step;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.TransferLog;
import oracle.ideimpl.db.transfer.TransferSchemaObjectDescriptor;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectManager;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransferDescriptor
extends HashStructureAdapter
implements PropertyStorage {
    public static final String KEY = "oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY";
    private static final String SCHEMA_OBJECT_DESCRIPTORS = "schemaObjectDescriptors";
    private static final String NAME_KEY = "name";
    private static final String SOURCE_APPLICATION_NAME = "sourceApplicationName";
    private static final String SOURCE_PROJECT_NAME = "sourceProjectName";
    private static final String SOURCE_CONNECTION_STORE = "sourceConnectionStore";
    private static final String SOURCE_IDENTIFIER = "sourceIdentifier";
    private static final String POLICY = "policy";
    private static final String TARGETS = "targets";
    private static final String IMPORT_GENERATE_KEY = "importOrGenerateKey";
    private static final String IMPORT_GENERATE_CONN = "importOrGenerateConn";
    private static final String REPLACE = "replace";
    private static final String CASCADEDELETE = "cascadeDelete";
    private static final String RECONCILE = "reconcile";
    private static final String MANUALRECONCILE = "manualReconcile";
    private static final String INCLUDE_DEPENDENCIES = "includeDependencies";
    private static final String INCLUDE_ALL_DEPENDENCIES = "includeAllDependencies";
    private static final String DEPENDENCY_DEPTH = "dependencyDepth";
    private static final String PLUS_SQL_SCRIPT = "plusSqlScript";
    private static final String TARGET_IDENTIFIER = "targetIdentifier";
    private static final String TARGET_SCHEMA_NAME = "targetSchemaName";
    private static final String TARGET_TABLE_SPACE = "targetTableSpace";
    private DBObjectID[] m_objectIDs;
    private TransferState m_state;
    private TransferManager m_manager;
    private SchemaObjectDescriptor[] m_descs;
    private Step[] m_reconcilePanels;
    private Step[] m_scriptPanels;

    private void $init$() {
        this.m_manager = new TransferManager();
    }

    public TransferDescriptor() {
        this(HashStructure.newInstance());
    }

    public TransferDescriptor(HashStructure hash) {
        super(hash);
        this.$init$();
    }

    public TransferDescriptor copyTo(Object target) {
        if (target == null) {
            return (TransferDescriptor)((Object)super.copyTo((Object)new TransferDescriptor(HashStructure.newInstance())));
        }
        return (TransferDescriptor)((Object)super.copyTo(target));
    }

    public String getName() {
        return this._hash.getString(NAME_KEY);
    }

    public TransferManager getTransferManager() {
        return this.m_manager;
    }

    public TransferState initialiseTransferState() {
        TransferState oldState = this.m_state;
        this.m_state = new TransferState(this);
        if (oldState != null) {
            this.m_state.copyListeners(oldState);
        }
        return this.m_state;
    }

    public TransferState getTransferState() {
        return this.m_state;
    }

    void clearTransferState() {
        this.m_state = null;
    }

    public DBObjectID[] getObjectIDs() {
        if (this.m_objectIDs == null) {
            try {
                DBObjectProvider prov = this.getSourceProvider();
                ListStructure sodList = this._hash.getOrCreateListStructure(SCHEMA_OBJECT_DESCRIPTORS);
                this.m_objectIDs = new DBObjectID[sodList.size()];
                int i = 0;
                while (i < sodList.size()) {
                    TransferSchemaObjectDescriptor tsod = new TransferSchemaObjectDescriptor((HashStructure)sodList.get(i));
                    this.m_objectIDs[i] = tsod.getDBObjectID(prov);
                    ++i;
                }
            }
            catch (DBException dbe) {
                TransferLog.getLogger().log(Level.SEVERE, "Cant retrieve Object IDs without a source provider", dbe);
            }
        }
        return this.m_objectIDs;
    }

    public void setObjectIDs(DBObjectID[] ids) {
        this.m_descs = null;
        this.m_objectIDs = ids;
        SchemaObjectDescriptor[] sods = SchemaObjectDescriptor.createDescriptors((DBObjectID[])ids);
        this.persistSchemaObjectDescriptors(sods);
    }

    private void persistSchemaObjectDescriptors(SchemaObjectDescriptor[] sods) {
        ListStructure sodList = this._hash.getOrCreateListStructure(SCHEMA_OBJECT_DESCRIPTORS);
        sodList.clear();
        SchemaObjectDescriptor[] schemaObjectDescriptorArray = sods;
        int n = 0;
        while (n < schemaObjectDescriptorArray.length) {
            SchemaObjectDescriptor sod = schemaObjectDescriptorArray[n];
            TransferSchemaObjectDescriptor tsod = new TransferSchemaObjectDescriptor(sod);
            sodList.add((Object)tsod.getProperties());
            ++n;
        }
    }

    public boolean isReplace() {
        return this._hash.getBoolean(REPLACE);
    }

    public void setReplace(boolean replace) {
        this._hash.putBoolean(REPLACE, replace);
    }

    public boolean isCascadeDelete() {
        return this._hash.getBoolean(CASCADEDELETE);
    }

    public void setCascadeDelete(boolean cascadeDelete) {
        this._hash.putBoolean(CASCADEDELETE, cascadeDelete);
    }

    public boolean isReconcile() {
        return this._hash.getBoolean(RECONCILE);
    }

    public void setReconcile(boolean reconcile) {
        this._hash.putBoolean(RECONCILE, reconcile);
    }

    public boolean isManualReconcile() {
        return this._hash.getBoolean(MANUALRECONCILE);
    }

    public void setManualReconcile(boolean manualReconcile) {
        this._hash.putBoolean(MANUALRECONCILE, manualReconcile);
    }

    public String getTargetSchemaName() {
        return this._hash.getString(TARGET_SCHEMA_NAME);
    }

    public void setTargetSchemaName(String schemaName) {
        this._hash.putString(TARGET_SCHEMA_NAME, schemaName);
    }

    public String getTargetTableSpace() {
        return this._hash.getString(TARGET_TABLE_SPACE);
    }

    public void setTargetTableSpace(String schemaName) {
        this._hash.putString(TARGET_TABLE_SPACE, schemaName);
    }

    public void setTarget(Object obj) {
        this._hash.remove(TARGET_IDENTIFIER);
        if (obj instanceof String) {
            this._hash.putString(TARGET_IDENTIFIER, (String)obj);
        } else if (obj instanceof URL) {
            this._hash.putURL(TARGET_IDENTIFIER, (URL)obj);
        } else if (obj != null) {
            throw new IllegalArgumentException("provider identifier must be a String (conn name) or URL (offlinedb)");
        }
    }

    public Object getTarget() {
        return this._hash.getObject(TARGET_IDENTIFIER);
    }

    public DBObjectProvider getTargetProvider() throws DBException {
        Object ident = this.getTarget();
        if (ident != null) {
            return DBObjectProviderFactory.findOrCreateProvider((Object)ident);
        }
        return null;
    }

    public void setReconcilePanels(Step[] reconcilePanels) {
        this.m_reconcilePanels = reconcilePanels;
    }

    public Step[] getReconcilePanels() {
        return this.m_reconcilePanels;
    }

    public void setScriptPanels(Step[] scriptPanels) {
        this.m_scriptPanels = scriptPanels;
    }

    public Step[] getScriptPanels() {
        return this.m_scriptPanels;
    }

    public void setSchemaObjectDescriptors(SchemaObjectDescriptor[] sos) {
        this.m_objectIDs = null;
        this.m_descs = sos;
        this.persistSchemaObjectDescriptors(sos);
    }

    public SchemaObjectDescriptor[] getSchemaObjectDescriptors() {
        if (this.m_descs == null) {
            ListStructure sodList = this._hash.getOrCreateListStructure(SCHEMA_OBJECT_DESCRIPTORS);
            this.m_descs = new SchemaObjectDescriptor[sodList.size()];
            int i = 0;
            while (i < sodList.size()) {
                TransferSchemaObjectDescriptor tsod = new TransferSchemaObjectDescriptor((HashStructure)sodList.get(i));
                this.m_descs[i] = new SchemaObjectDescriptor(tsod.getName(), tsod.getType(), tsod.getSchemaName());
                ++i;
            }
        }
        return this.m_descs;
    }

    public boolean getIncludeDependencies() {
        return this._hash.getBoolean(INCLUDE_DEPENDENCIES);
    }

    public void setIncludeDependencies(boolean includeDependencies) {
        this._hash.putBoolean(INCLUDE_DEPENDENCIES, includeDependencies);
    }

    public boolean getIncludeAllDependencies() {
        return this._hash.getBoolean(INCLUDE_ALL_DEPENDENCIES);
    }

    public void setIncludeAllDependencies(boolean includeAllDependencies) {
        this._hash.putBoolean(INCLUDE_ALL_DEPENDENCIES, includeAllDependencies);
    }

    public int getDependencyDepth() {
        return this._hash.getInt(DEPENDENCY_DEPTH);
    }

    public void setDependencyDepth(int dependencyDepth) {
        this._hash.putInt(DEPENDENCY_DEPTH, dependencyDepth);
    }

    public boolean isPlusSqlScript() {
        return this._hash.getBoolean(PLUS_SQL_SCRIPT);
    }

    public void setPlusSqlScrip(boolean plusSqlScrip) {
        this._hash.putBoolean(PLUS_SQL_SCRIPT, plusSqlScrip);
    }

    public void setSourceApplicationName(String source) {
        this._hash.putString(SOURCE_APPLICATION_NAME, source, true);
    }

    public String getSourceApplicationName() {
        return this._hash.getString(SOURCE_APPLICATION_NAME);
    }

    public void setSourceProjectName(String source) {
        this._hash.putString(SOURCE_PROJECT_NAME, source, true);
    }

    public String getSourceProjectName() {
        return this._hash.getString(SOURCE_PROJECT_NAME);
    }

    public void setSourceConnectionStore(String source) {
        this._hash.putString(SOURCE_CONNECTION_STORE, source);
    }

    public String getSourceConnectionStore() {
        return this._hash.getString(SOURCE_CONNECTION_STORE);
    }

    public void setSource(Object source) {
        this._hash.remove(SOURCE_IDENTIFIER);
        if (source instanceof String) {
            this._hash.putString(SOURCE_IDENTIFIER, (String)source);
        } else if (source instanceof URL) {
            this._hash.putURL(SOURCE_IDENTIFIER, (URL)source);
        } else if (source != null) {
            throw new IllegalArgumentException("provider identifier must be a String (conn name) or URL (offlinedb)");
        }
    }

    public Object getSource() {
        return this._hash.getObject(SOURCE_IDENTIFIER);
    }

    public DBObjectProvider getSourceProvider() throws DBException {
        Object provIdent = this.getSource();
        if (provIdent != null) {
            String store = this.getSourceConnectionStore();
            if (store == null || !(provIdent instanceof String)) {
                return DBObjectProviderFactory.findOrCreateProvider((Object)provIdent);
            }
            DatabaseConnections chosen = DatabaseConnectionStores.getInstance().getStore(store);
            if (chosen != null) {
                return chosen.getDatabase((String)provIdent);
            }
        }
        return null;
    }

    public void setPolicy(Class policy) {
        this._hash.putString(POLICY, policy.getName());
    }

    public Class getPolicy() {
        Class<?> result = null;
        String className = this._hash.getString(POLICY);
        if (ModelUtil.hasLength((String)className)) {
            try {
                result = Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return result;
    }

    public void setImportGenerateKey(String importGenerateKey) {
        this._hash.putString(IMPORT_GENERATE_KEY, importGenerateKey);
    }

    public String getImportGenerateKey() {
        return this._hash.getString(IMPORT_GENERATE_KEY);
    }

    public void setImportGenerateConn(String importGenerateConn) {
        this._hash.putString(IMPORT_GENERATE_CONN, importGenerateConn);
    }

    public String getImportGenerateConn() {
        return this._hash.getString(IMPORT_GENERATE_CONN);
    }

    public TransferTarget[] getTransferTargets() {
        TransferTarget[] result = null;
        HashStructure ttsHash = this._hash.getHashStructure(TARGETS);
        if (ttsHash != null) {
            TransferTargets tts = new TransferTargets(ttsHash);
            result = TransferTargets.mav$getTargets(tts, this);
        }
        return result;
    }

    public <T extends TransferTarget> T getTransferTarget(Class<T> targetClass) {
        TransferTarget result = null;
        HashStructure ttsHash = this._hash.getHashStructure(TARGETS);
        if (ttsHash != null) {
            TransferTargets tts = new TransferTargets(ttsHash);
            result = TransferTargets.mav$getTarget(tts, this, targetClass);
        }
        return (T)result;
    }

    public <T extends TransferTarget> T getOrCreateTransferTarget(Class<T> targetClass) {
        TransferTarget result = null;
        HashStructure ttsHash = this._hash.getHashStructure(TARGETS);
        TransferTargets tts = null;
        if (ttsHash != null) {
            tts = new TransferTargets(ttsHash);
            result = TransferTargets.mav$getTarget(tts, this, targetClass);
        } else {
            tts = new TransferTargets();
            this._hash.putHashStructure(TARGETS, tts.getProperties());
        }
        result = TransferTargets.mav$getOrCreateTarget(tts, this, targetClass);
        return (T)result;
    }

    public <T extends TransferTarget> T removeTransferTarget(Class<T> targetClass) {
        HashStructure ttsHash = this._hash.getHashStructure(TARGETS);
        if (ttsHash != null) {
            TransferTargets tts = new TransferTargets(ttsHash);
            return (T)TransferTargets.mav$removeTarget(tts, this, targetClass);
        }
        return null;
    }

    public SchemaObject[] getSchemaObjects() {
        try {
            SchemaObject[] schemaObjectArray = this.getSchemaObjects(true);
            return schemaObjectArray;
        }
        catch (DBException dbe) {
            TransferLog.getLogger().log(Level.SEVERE, "Failed to get source objects for transfer", dbe);
            return null;
        }
    }

    public SchemaObject[] getSchemaObjects(boolean ignorErrors) throws DBException {
        SchemaObject[] sos;
        block11: {
            sos = null;
            try {
                if (this.m_objectIDs == null) {
                    SchemaObjectDescriptor[] sods = this.getSchemaObjectDescriptors();
                    if (sods == null || sods.length <= 0) break block11;
                    DBObjectProvider sourceProv = this.getSourceProvider();
                    sos = new SchemaObject[sods.length];
                    int i = 0;
                    while (i < sods.length) {
                        block12: {
                            try {
                                sos[i] = sods[i].unwrapDescriptor(sourceProv);
                            }
                            catch (DBException dbe) {
                                TransferLog.getLogger().log(Level.SEVERE, "Failed to get source object " + sods[i] + " for transfer", dbe);
                                if (ignorErrors) break block12;
                                throw dbe;
                            }
                        }
                        if (sos[i] == null) {
                            String type = sods[i].getType();
                            String schema = sods[i].getSchema();
                            String name = sods[i].getName();
                            if (!ModelUtil.hasLength((String)type)) {
                                type = "";
                            }
                            if (!ModelUtil.hasLength((String)schema)) {
                                schema = "";
                            }
                            if (!ModelUtil.hasLength((String)name)) {
                                name = "";
                            }
                            throw new DBException(null, TransferArb.format(108, type, schema, name));
                        }
                        ++i;
                    }
                    break block11;
                }
                sos = new SchemaObject[this.m_objectIDs.length];
                int i = 0;
                while (i < this.m_objectIDs.length) {
                    sos[i] = null;
                    sos[i] = (SchemaObject)this.m_objectIDs[i].resolveID();
                    ++i;
                }
            }
            catch (DBException dbe) {
                TransferLog.getLogger().log(Level.WARNING, "Failed to get source objects for transferdbe");
                if (ignorErrors) break block11;
                throw dbe;
            }
        }
        return sos;
    }

    public SchemaObject[] getSchemaObjectsAndDependencies() {
        try {
            SchemaObject[] schemaObjectArray = this.getSchemaObjectsAndDependencies(true);
            return schemaObjectArray;
        }
        catch (DBException dbe) {
            TransferLog.getLogger().log(Level.SEVERE, "Failed to get source objects for transfer", dbe);
            return null;
        }
    }

    public SchemaObject[] getSchemaObjectsAndDependencies(boolean ignorErrors) throws DBException {
        SchemaObject[] sos = this.getSchemaObjects(ignorErrors);
        if (sos == null || sos.length == 0) {
            return sos;
        }
        HashSet<SchemaObject> result = new HashSet<SchemaObject>(Arrays.asList(sos));
        HashSet<SchemaObject> newDeps = new HashSet<SchemaObject>(result);
        int dd = 0;
        boolean incAllDeps = false;
        if (this.getIncludeDependencies()) {
            incAllDeps = this.getIncludeAllDependencies();
            dd = this.getDependencyDepth();
        }
        int i = 0;
        while (incAllDeps || i < dd) {
            HashSet<SchemaObject> deps = new HashSet<SchemaObject>(newDeps);
            for (SchemaObject so : deps) {
                SchemaObject[] dsos;
                SchemaObject[] schemaObjectArray = dsos = SchemaObjectManager.getDependencies((SchemaObject)so, (DBObjectProvider)this.getSourceProvider(), (boolean)false);
                int n = 0;
                while (n < schemaObjectArray.length) {
                    SchemaObject dso = schemaObjectArray[n];
                    if (!(dso == null || dso instanceof DataType && DataTypeRegistry.getInstance().isRegisteredType((DataType)dso))) {
                        newDeps.add(dso);
                    }
                    ++n;
                }
            }
            newDeps.removeAll(result);
            if (newDeps.size() == 0) break;
            result.addAll(newDeps);
            ++i;
        }
        return result.toArray(new SchemaObject[result.size()]);
    }

    public HashStructure getProperties() {
        return this._hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransferTargets
    extends HashStructureAdapter
    implements PropertyStorage {
        public static final String KEY = "oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY";

        public TransferTargets() {
            this(HashStructure.newInstance());
        }

        public TransferTargets(HashStructure hash) {
            super(hash);
        }

        private TransferTargets createCopy() {
            return (TransferTargets)((Object)this.copyTo((Object)new TransferTargets(HashStructure.newInstance())));
        }

        private <T extends TransferTarget> T removeTarget(TransferDescriptor td, Class<T> targetClass) {
            String targetName = targetClass.getName();
            if (this._hash.containsKey(targetName)) {
                T target = this.getTarget(td, targetClass);
                this._hash.remove(targetName);
                return target;
            }
            return null;
        }

        private <T extends TransferTarget> T getOrCreateTarget(TransferDescriptor td, Class<T> targetClass) {
            T target = this.getTarget(td, targetClass);
            if (target == null) {
                this._hash.putHashStructure(targetClass.getName(), HashStructure.newInstance());
                target = this.getTarget(td, targetClass);
            }
            return target;
        }

        private <T extends TransferTarget> T getTarget(TransferDescriptor td, Class<T> targetClass) {
            TransferTarget target = null;
            try {
                HashStructure targetHash = this._hash.getHashStructure(targetClass.getName());
                if (targetHash != null) {
                    Constructor<T> targetConstructor = targetClass.getConstructor(TransferDescriptor.class);
                    target = (TransferTarget)targetConstructor.newInstance(new Object[]{td});
                }
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InstantiationException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            return (T)target;
        }

        private TransferTarget[] getTargets(TransferDescriptor td) {
            Set keys = this._hash.keySet();
            TransferTarget[] targets = new TransferTarget[keys.size()];
            int i = 0;
            for (Object key : keys) {
                try {
                    Class<?> targetClass = Class.forName((String)key);
                    targets[i++] = this.getTarget(td, targetClass);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            return targets;
        }

        public HashStructure getProperties() {
            return this._hash;
        }

        static TransferTarget mav$removeTarget(TransferTargets transferTargets, TransferDescriptor transferDescriptor, Class clazz) {
            return transferTargets.removeTarget(transferDescriptor, clazz);
        }

        static TransferTarget mav$getTarget(TransferTargets transferTargets, TransferDescriptor transferDescriptor, Class clazz) {
            return transferTargets.getTarget(transferDescriptor, clazz);
        }

        static TransferTarget mav$getOrCreateTarget(TransferTargets transferTargets, TransferDescriptor transferDescriptor, Class clazz) {
            return transferTargets.getOrCreateTarget(transferDescriptor, clazz);
        }

        static TransferTarget[] mav$getTargets(TransferTargets transferTargets, TransferDescriptor transferDescriptor) {
            return transferTargets.getTargets(transferDescriptor);
        }
    }
}

