/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.transfer;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Index;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.ReconcileHelper;
import oracle.javatools.db.diff.ResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferHelper {
    public static String getUpdateDDL(DBObjectProvider source, SchemaObject[] schemaObjects, DBObjectProvider target, Schema targetSchema) throws DBException {
        if (!(source instanceof Database)) {
            throw new IllegalArgumentException("source expected to be an instance of Database");
        }
        if (!(target instanceof Database)) {
            throw new IllegalArgumentException("target expected to be an instance of Database");
        }
        SchemaObject[] eos = new SchemaObject[schemaObjects.length];
        int i = 0;
        while (i < schemaObjects.length) {
            SchemaObject eo;
            eos[i] = eo = target.getObject(schemaObjects[i].getType(), targetSchema, schemaObjects[i].getName());
            ++i;
        }
        SchemaObject[] tos = new SchemaObject[schemaObjects.length];
        IDPolicy.DefaultIDPolicy cp = new IDPolicy.DefaultIDPolicy();
        int i2 = 0;
        while (i2 < schemaObjects.length) {
            tos[i2] = (SchemaObject)((AbstractDBObject)schemaObjects[i2]).copyTo(null, (IDPolicy)cp);
            tos[i2].setSchema(targetSchema);
            if (tos[i2] instanceof Table) {
                Index[] inds = ((Table)tos[i2]).getIndexes();
                int j = 0;
                while (j < inds.length) {
                    if (!TransferHelper.isIndexForCopy(target, inds[j])) {
                        ((Table)tos[i2]).removeIndex(inds[j]);
                    }
                    ++j;
                }
            }
            ++i2;
        }
        Map idMap = cp.getIDMap();
        int i3 = 0;
        while (i3 < schemaObjects.length) {
            DBUtil.replaceReferenceIDs((DBObject)tos[i3], (Map)idMap);
            ++i3;
        }
        idMap.clear();
        int i4 = 0;
        while (i4 < schemaObjects.length) {
            if (eos[i4] != null) {
                TransferHelper.replaceExistingIDs((DBObject)tos[i4], (DBObject)eos[i4], idMap);
            }
            ++i4;
        }
        int i5 = 0;
        while (i5 < schemaObjects.length) {
            DBUtil.replaceReferenceIDs((DBObject)tos[i5], (Map)idMap);
            ++i5;
        }
        List<SchemaObject> aList = Arrays.asList(eos);
        List<SchemaObject> bList = Arrays.asList(tos);
        ResultSet rs = new ResultSet(null, aList, aList, null, "LIST");
        DiffContext diffContext = new DiffContext(ReconcileHelper.getDiffEngine(), rs);
        diffContext.getEngine().diff(aList, bList, rs, diffContext);
        DDLGenerator ddlGen = target.getDescriptor().getDDLGenerator(target);
        DDL ddl = ddlGen.getUpdateDDL(new DDLOptions(false, false), rs);
        return ddl.toString();
    }

    public static void replaceExistingIDs(DBObject temp, DBObject existing, Map<DBObjectID, DBObjectID> idMap) {
        DBObject[] children;
        DBObjectID tempID = temp.getID();
        DBObjectID existingID = existing.getID();
        if (!idMap.containsKey(tempID)) {
            temp.setID(existingID);
            idMap.put(tempID, existingID);
        }
        DBObject[] dBObjectArray = children = temp.getOwnedObjects();
        int n = 0;
        while (n < dBObjectArray.length) {
            DBObject tchild = dBObjectArray[n];
            DBObject existingChild = existing.findOwnedObject(tchild.getType(), tchild.getName());
            if (existingChild != null) {
                TransferHelper.replaceExistingIDs(tchild, existingChild, idMap);
            }
            ++n;
        }
    }

    private static boolean isIndexForCopy(DBObjectProvider target, Index source) {
        boolean result = true;
        String indexName = source.getName();
        Table table = source.getTable();
        Constraint[] cons = table.getConstraints();
        int i = cons.length - 1;
        while (i >= 0) {
            if (indexName.equals(cons[i].getName())) {
                result = false;
                break;
            }
            --i;
        }
        if (result) {
            try {
                target.validateObject((DBObject)source);
            }
            catch (ValidationException ve) {
                result = false;
            }
        }
        return result;
    }
}

