/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.transfer;

import java.awt.Component;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.db.transfer.TransferFailedException;
import oracle.ide.db.transfer.TransferPolicy;
import oracle.ide.db.transfer.TransferState;
import oracle.ide.db.transfer.TransferTarget;
import oracle.ideimpl.db.transfer.ProviderTransferTarget;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.TransferLog;
import oracle.ideimpl.db.transfer.TransferProps;
import oracle.ideimpl.db.transfer.TransferUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.dictionary.DictionaryDatabase;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.dialogs.MessageDialog;

public final class TransferManager {
    private long m_millis;

    public void prepare(TransferDescriptor td) throws TransferFailedException {
        TransferState state = td.getTransferState();
        if (state == null || state.isPrepDone() || state.hasFailed()) {
            state = td.initialiseTransferState();
        } else {
            state.notifyStateChange();
        }
        TransferUtil.checkWeHaveATransfer(td);
        TransferPolicy policy = state.getPolicy();
        DBObjectProvider srcProvider = null;
        try {
            try {
                try {
                    srcProvider = td.getSourceProvider();
                    if (srcProvider instanceof DictionaryDatabase) {
                        ((DictionaryDatabase)srcProvider).suspendTimestampQueries("TransferManager.prepare");
                    }
                }
                catch (DBException e) {
                    // empty catch block
                }
                this.m_millis = System.currentTimeMillis();
                TransferLog.log("Starting findExistingObjects", new Object[0]);
                SchemaObject[] existing = state.getExistingObjects();
                if (existing == null) {
                    existing = policy.findExistingObjects(td);
                    state.setExistingObjects(existing);
                }
                TransferTarget[] tt = td.getTransferTargets();
                boolean hasProviderTransferTarget = false;
                TransferTarget[] transferTargetArray = tt;
                int n = 0;
                while (n < transferTargetArray.length) {
                    TransferTarget t = transferTargetArray[n];
                    if (t instanceof ProviderTransferTarget) {
                        hasProviderTransferTarget = true;
                        break;
                    }
                    ++n;
                }
                if (!td.isReconcile() && !td.isReplace() && hasProviderTransferTarget) {
                    StringBuffer eoNames = new StringBuffer();
                    SchemaObject[] schemaObjectArray = existing;
                    int n2 = 0;
                    while (n2 < schemaObjectArray.length) {
                        SchemaObject eo = schemaObjectArray[n2];
                        if (eo != null) {
                            eoNames.append(eo.getName()).append(", ");
                        }
                        ++n2;
                    }
                    if (eoNames.length() > 0) {
                        String message = TransferArb.format(75, eoNames.toString());
                        throw new TransferFailedException(message);
                    }
                }
                TransferLog.log("Starting copyForTransfer", new Object[0]);
                SchemaObject[] copies = policy.copyForTransfer(td, existing);
                state.setCopiedObjects(copies);
                state.prepDone();
            }
            catch (Exception e) {
                state.setFailed(true);
                if (e instanceof TransferFailedException) {
                    throw (TransferFailedException)e;
                }
                TransferLog.getLogger().log(Level.SEVERE, "Prepare failed", e);
                throw new TransferFailedException("Prepare for transfer failed unexpectedly.", e);
            }
        }
        finally {
            if (srcProvider instanceof DictionaryDatabase) {
                ((DictionaryDatabase)srcProvider).resumeTimestampQueries("TransferManager.prepare");
            }
        }
    }

    public SchemaObject[] transfer(TransferDescriptor td) throws TransferFailedException {
        SchemaObject[] transferedObjects = null;
        TransferState state = td.getTransferState();
        if (state == null || !state.isPrepDone()) {
            throw new IllegalStateException("Must call prepare(TransferDescriptor) before calling transfer()");
        }
        DBObjectProvider srcProvider = null;
        TransferUtil.checkWeHaveATransfer(td);
        try {
            try {
                TransferTarget[] targets;
                TransferLog.log("Starting Transfer", new Object[0]);
                state.checkNotCancelled();
                if (state.getResultSet() == null) {
                    this.createResultSet(td);
                } else {
                    this.updateChildren(state.getResultSet());
                }
                ResultSet rs = state.getResultSet();
                TransferUtil.checkWeHaveATransfer(rs);
                try {
                    srcProvider = td.getSourceProvider();
                    if (srcProvider instanceof DictionaryDatabase) {
                        ((DictionaryDatabase)srcProvider).suspendTimestampQueries("TransferManager.transfer");
                    }
                }
                catch (DBException e) {
                    // empty catch block
                }
                long transferTime = System.currentTimeMillis();
                TransferTarget[] transferTargetArray = targets = td.getTransferTargets();
                int n = 0;
                while (n < transferTargetArray.length) {
                    TransferTarget tt = transferTargetArray[n];
                    state.setActiveTarget(tt);
                    SchemaObject[] sos = tt.transfer(rs);
                    if (sos != null && sos.length > 0) {
                        transferedObjects = sos;
                    }
                    ++n;
                }
                state.checkNotCancelled();
                transferTime = System.currentTimeMillis() - transferTime;
                TransferLog.getLogger().log(TransferLog.getTimingLogLevel(), "Objects created timing: {0} ms.", transferTime);
            }
            catch (Exception e) {
                state.setFailed(true);
                if (e instanceof TransferFailedException) {
                    throw (TransferFailedException)e;
                }
                TransferLog.getLogger().log(Level.SEVERE, "Transfer failed", e);
                throw new TransferFailedException("Transfer failed unexpectedly.", e);
            }
        }
        finally {
            String[] messages = state.getMessages();
            if (messages.length > 0) {
                SwingUtilities.invokeLater(new 1(this, messages));
            }
            state.setActiveTarget(null);
            td.clearTransferState();
            if (srcProvider instanceof DictionaryDatabase) {
                ((DictionaryDatabase)srcProvider).resumeTimestampQueries("TransferManager.transfer");
            }
        }
        long millis = System.currentTimeMillis() - this.m_millis;
        TransferLog.getLogger().log(TransferLog.getTimingLogLevel(), "TransferManager : preparing and transfering {0} objects took {1}ms", new Object[]{transferedObjects != null ? transferedObjects.length : 0, Long.toString(millis)});
        return transferedObjects;
    }

    private boolean updateChildren(ResultSet rs) {
        boolean same = rs.isSame();
        if (!same) {
            boolean shuttled = TransferProps.isShuttled(rs);
            same = shuttled ^ true;
            if ("LIST".equals(rs.getType())) {
                for (ResultSet rk : rs.getNotSameObjectList()) {
                    same &= this.updateChildren(rk);
                }
            } else if ("MAP".equals(rs.getType())) {
                for (ResultSet rp : rs.getNotSameObjectMap().values()) {
                    same &= this.updateChildren(rp);
                }
            }
            rs.setSame(same);
        }
        return same;
    }

    public SchemaObject[] prepareAndTransfer(TransferDescriptor td) throws TransferFailedException {
        this.prepare(td);
        return this.transfer(td);
    }

    private void createResultSet(TransferDescriptor td) {
        TransferState state = td.getTransferState();
        SchemaObject[] existing = state.getExistingObjects();
        SchemaObject[] existingObjects = new SchemaObject[existing.length];
        int i = 0;
        while (i < existing.length) {
            existingObjects[i] = td.isReconcile() ? existing[i] : null;
            ++i;
        }
        TransferPolicy policy = state.getPolicy();
        ResultSet rs = policy.getDifferences(existingObjects, state.getCopiedObjects());
        state.setResultSet(rs);
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ String[] v$messages;
        final /* synthetic */ TransferManager this$0;

        public void run() {
            StringBuffer allMessages = new StringBuffer(this.v$messages[0]);
            int i = 1;
            while (i < this.v$messages.length) {
                allMessages.append("\n").append(this.v$messages[i]);
                ++i;
            }
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)allMessages, (String)"", null);
        }

        public 1(TransferManager transferManager, String[] stringArray) {
            this.v$messages = stringArray;
            this.this$0 = transferManager;
        }
    }
}

