/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.transfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import oracle.ide.db.transfer.TransferCancelledException;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.db.transfer.TransferPolicy;
import oracle.ide.db.transfer.TransferTarget;
import oracle.ideimpl.db.transfer.TransferLog;
import oracle.ideimpl.db.transfer.TransferStateListener;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.diff.ResultSet;

public final class TransferState {
    private Collection<TransferStateListener> m_listeners;
    private TransferDescriptor m_td;
    private TransferPolicy m_policy;
    private SchemaObject[] m_copiedObjects;
    private SchemaObject[] m_existingObjects;
    private ResultSet m_rs;
    private boolean m_prepDone;
    private boolean m_cancelled;
    private boolean m_failed;
    private TransferTarget m_activeTarget;
    private List<String> m_messages;

    private void $init$() {
        this.m_listeners = new ArrayList<TransferStateListener>();
        this.m_messages = new ArrayList<String>();
    }

    public TransferState(TransferDescriptor td) {
        this.$init$();
        if (td == null) {
            throw new IllegalArgumentException("TransferState must have a TransferDescriptor");
        }
        this.m_td = td;
    }

    public TransferDescriptor getDescriptor() {
        return this.m_td;
    }

    void prepDone() {
        this.m_prepDone = true;
        this.notifyStateChange();
    }

    public boolean isPrepDone() {
        return this.m_prepDone;
    }

    void setActiveTarget(TransferTarget tt) {
        this.m_activeTarget = tt;
        this.notifyStateChange();
    }

    public TransferTarget getActiveTarget() {
        return this.m_activeTarget;
    }

    public void setFailed(boolean failed) {
        this.m_failed = true;
        this.notifyStateChange();
    }

    public boolean hasFailed() {
        return this.m_failed;
    }

    public void cancel() {
        this.m_cancelled = true;
    }

    public void checkNotCancelled() throws TransferCancelledException {
        if (this.m_cancelled) {
            this.m_cancelled = false;
            throw new TransferCancelledException();
        }
    }

    public ResultSet getResultSet() {
        return this.m_rs;
    }

    public void setResultSet(ResultSet rs) {
        this.m_rs = rs;
    }

    public SchemaObject[] getCopiedObjects() {
        return this.m_copiedObjects;
    }

    void setCopiedObjects(SchemaObject[] copies) {
        this.m_copiedObjects = copies;
    }

    public SchemaObject[] getExistingObjects() {
        return this.m_existingObjects;
    }

    public void setExistingObjects(SchemaObject[] existing) {
        this.m_existingObjects = existing;
    }

    public void addMessage(String message) {
        this.m_messages.add(message);
    }

    String[] getMessages() {
        return this.m_messages.toArray(new String[this.m_messages.size()]);
    }

    public void clearMessages() {
        this.m_messages.clear();
    }

    public TransferPolicy getPolicy() {
        if (this.m_policy == null) {
            Class policyClass = this.m_td.getPolicy();
            try {
                this.m_policy = (TransferPolicy)policyClass.newInstance();
            }
            catch (Exception e) {
                TransferLog.getLogger().log(Level.WARNING, "Cannot create transfer policy " + policyClass.getName(), e);
                throw new RuntimeException("Cannot create transfer policy " + policyClass.getName() + ". Transfer failed.");
            }
        }
        return this.m_policy;
    }

    void copyListeners(TransferState otherState) {
        this.m_listeners.addAll(otherState.m_listeners);
    }

    public void addStateListener(TransferStateListener l) {
        if (!this.m_listeners.contains(l)) {
            this.m_listeners.add(l);
        }
    }

    public boolean removeStateListener(TransferStateListener l) {
        return this.m_listeners.remove(l);
    }

    protected void notifyStateChange() {
        ArrayList<TransferStateListener> tmpListeners = new ArrayList<TransferStateListener>(this.m_listeners);
        for (TransferStateListener l : tmpListeners) {
            try {
                l.stateChanged(this);
            }
            catch (Exception e) {
                TransferLog.log("TransferStateListener failed " + l.getClass().getName(), e);
            }
        }
    }
}

