/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.transfer.generate;

import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.db.transfer.TransferFailedException;
import oracle.ide.db.transfer.TransferPolicy;
import oracle.ide.db.transfer.TransferState;
import oracle.ide.db.transfer.TransferTarget;
import oracle.ide.db.transfer.generate.GenerateTargetRegistry;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.ideimpl.db.transfer.ProviderTransferTarget;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.TransferLog;
import oracle.ideimpl.db.transfer.TransferRunnable;
import oracle.ideimpl.db.transfer.TransferUtil;
import oracle.ideimpl.db.transfer.panels.ChooseOpFull;
import oracle.ideimpl.db.transfer.panels.GeneratorSummaryPanel;
import oracle.ideimpl.db.transfer.panels.TransferProgressBar;
import oracle.ideimpl.db.transfer.panels.TransferSelectionPanel;
import oracle.javatools.db.DBException;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.AppDatabaseConnections;
import oracle.jdeveloper.db.DatabaseConnections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenerateController
implements Controller,
CommitListener {
    private static final String TARGET_KEY = "TransferTarget";
    private static final String NAME_KEY = "TransferTargetName";
    protected static final String GENERATE_CMD = "database-generate";
    public static final int GENERATE_CMD_ID = Ide.createCmdID((String)"database-generate");

    protected GenerateController() {
    }

    protected abstract Namespace createNamespace(TransferDescriptor var1, Context var2) throws DBException;

    public boolean update(IdeAction action, Context context) {
        boolean retval = false;
        int id = action.getCommandId();
        if (id == GENERATE_CMD_ID) {
            retval = this.isGenerateEnabled(context);
            action.setEnabled(retval);
        }
        return retval;
    }

    protected boolean isGenerateEnabled(Context context) {
        return this.getSourceIdentifier(context) != null;
    }

    protected boolean canGenerate(Context context) {
        return this.isGenerateEnabled(context);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        boolean retval = false;
        if (this.canGenerate(context)) {
            int id = action.getCommandId();
            if (id == GENERATE_CMD_ID) {
                retval = true;
                TransferDescriptor desc = this.createDescriptor(null, null, context);
                if (desc != null) {
                    this.invokeWizard(desc, context);
                }
            } else {
                String name = (String)action.getValue(NAME_KEY);
                Class<? extends ProviderTransferTarget> target = (Class<? extends ProviderTransferTarget>)action.getValue(TARGET_KEY);
                if (name != null && target == null) {
                    target = this.getDBTarget();
                }
                if (target != null) {
                    retval = true;
                    TransferDescriptor desc = this.createDescriptor(name, target, context);
                    if (desc != null) {
                        this.invokeWizard(desc, context);
                    }
                }
            }
        }
        return retval;
    }

    protected void invokeWizard(TransferDescriptor td, Context context) {
        TransferTarget[] targs = td.getTransferTargets();
        if (targs == null || targs.length != 1) {
            this.invokeFullWizard(td, context);
        } else {
            if (td.getTarget() instanceof String) {
                AppDatabaseConnections.ensureInApplicationResources((String)((String)td.getTarget()), (Context)context);
            }
            ArrayList<Step> allSteps = null;
            GenerateTargetRegistry registry = GenerateTargetRegistry.getInstance();
            if (targs.length != 1) {
                throw new IllegalArgumentException("can't quick generate to more than one target");
            }
            if (targs[0] instanceof ProviderTransferTarget) {
                allSteps = new ArrayList<Step>();
                allSteps.add(GenerateTargetRegistry.getSQLScriptStep());
            } else {
                Step[] targetSteps = registry.getSteps(targs[0].getClass());
                if (targetSteps != null) {
                    allSteps = new ArrayList();
                    allSteps.addAll(Arrays.asList(targetSteps));
                }
            }
            if (allSteps != null) {
                this.invokeTargettedWizard(td, allSteps, context);
            } else {
                try {
                    this.doTransfer(td);
                }
                catch (TransferFailedException tfe) {
                    TransferUtil.showExceptionDialog((Component)Ide.getMainWindow(), tfe, this.getTitle(td), null);
                }
            }
        }
    }

    protected SchemaObject[] doTransfer(TransferDescriptor td) throws TransferFailedException {
        TransferRunnable runner = td.isReconcile() && td.isManualReconcile() ? TransferRunnable.createTransferRunnable(td) : TransferRunnable.createPrepareAndTransferRunnable(td);
        TransferProgressBar bar = new TransferProgressBar(this.getTitle(td), runner);
        bar.start(null, null);
        if (!bar.hasUserCancelled()) {
            return runner.getTransferResult();
        }
        return null;
    }

    private void invokeFullWizard(TransferDescriptor desc, Context context) {
        try {
            MyFSMBuilder fsmBuilder = this.buildFSM(context, desc);
            this.showWizard(fsmBuilder, this.createNamespace(desc, context), TransferUtil.createStateName(this.getChooseOpStep()));
        }
        catch (DBException dbe) {
            DBExceptionDialog.showErrorDialog((Component)Ide.getMainWindow(), (String)this.getTitle(desc), (DBException)dbe);
        }
    }

    protected void invokeTargettedWizard(TransferDescriptor desc, List<Step> steps, Context context) {
        try {
            MyFSMBuilder fsmBuilder = this.buildFSM(context, desc);
            Namespace namespace = this.createNamespace(desc, context);
            namespace.put("FirstNonDefaultPanel", (Object)fsmBuilder.getFirstTraversable());
            this.showWizard(fsmBuilder, namespace, TransferUtil.createStateName(this.getChooseOpStep()));
        }
        catch (DBException dbe) {
            DBExceptionDialog.showErrorDialog((Component)Ide.getMainWindow(), (String)this.getTitle(desc), (DBException)dbe);
        }
    }

    protected abstract Step getSourceStep();

    protected abstract Step getTargetStep();

    private Step getChooseOpStep() {
        return new Step(TransferArb.getString(4), ChooseOpFull.class, "f1_ondbgeneratesqlwizardchoose_html");
    }

    protected abstract Step getManualReconcileStep();

    private Step getFinishStep() {
        return new Step(TransferArb.getString(76), GeneratorSummaryPanel.class, "f1_ondbgeneratesqlwizardfinish_html");
    }

    private MyFSMBuilder buildFSM(Context context, TransferDescriptor desc) {
        Object firstPanel = null;
        MyFSMBuilder fsmBuilder = new MyFSMBuilder();
        GenerateTargetRegistry registry = GenerateTargetRegistry.getInstance();
        Step sourceStep = this.getSourceStep();
        if (desc.getSource() != null) {
            fsmBuilder.setFirstTraversable("GeneratorConnectionPanelTarget");
        }
        Step targetStep = this.getTargetStep();
        String targetState = TransferUtil.createStateName(targetStep);
        if (desc.getTarget() != null) {
            fsmBuilder.setFirstTraversable("TransferSelectionPanel");
        }
        Step selectStep = new Step(TransferArb.getString(141), TransferSelectionPanel.class, "f1_ondbgeneratesqlwizardselectobj_html");
        String selectState = TransferUtil.createStateName(selectStep);
        if (desc.getSchemaObjectDescriptors().length > 0) {
            fsmBuilder.setFirstTraversable("ChooseOp");
        }
        Step chooseOp = this.getChooseOpStep();
        String chooseOpState = TransferUtil.createStateName(chooseOp);
        Step manualR = this.getManualReconcileStep();
        String manualState = TransferUtil.createStateName(manualR);
        Step finish = this.getFinishStep();
        String finishStep = TransferUtil.createStateName(finish);
        fsmBuilder.newFinalState(finishStep, finish);
        fsmBuilder.newStartState(sourceStep, targetState);
        HashMap<String, String> firstTargetSteps = new HashMap<String, String>();
        for (Class<? extends TransferTarget> tt : registry.getTargets(context)) {
            Step[] steps = registry.getSteps(tt);
            String name = registry.getDisplayName(tt);
            String lastStep = finishStep;
            if (steps != null) {
                int i = steps.length - 1;
                while (i >= 0) {
                    Step step = steps[i];
                    String stepName = name + TransferUtil.createStateName(step);
                    fsmBuilder.newState(stepName, step, lastStep);
                    lastStep = stepName;
                    --i;
                }
            }
            firstTargetSteps.put(name, lastStep);
        }
        String db = "db";
        Step sqlStep = GenerateTargetRegistry.getSQLScriptStep();
        String sqlState = "db" + TransferUtil.createStateName(sqlStep);
        fsmBuilder.newState(sqlState, sqlStep, finishStep);
        firstTargetSteps.put("db", sqlState);
        boolean first = true;
        for (String targetName : firstTargetSteps.keySet()) {
            if (first) {
                fsmBuilder.newState(targetState, targetStep, targetName + selectState);
                first = false;
            }
            fsmBuilder.addStateTrans(targetName, targetName + selectState);
        }
        for (String targetName : firstTargetSteps.keySet()) {
            String nextStep = (String)firstTargetSteps.get(targetName);
            fsmBuilder.newState(targetName + manualState, manualR, nextStep);
            fsmBuilder.newState(targetName + chooseOpState, chooseOp, desc.isManualReconcile() ? targetName + manualState : nextStep);
            fsmBuilder.addStateTrans(true, targetName + manualState);
            fsmBuilder.addStateTrans(false, nextStep);
            fsmBuilder.newState(targetName + selectState, selectStep, targetName + chooseOpState);
        }
        return fsmBuilder;
    }

    private void showWizard(MyFSMBuilder fsmBuilder, Namespace namespace, String startPage) {
        FSM fsm = null;
        try {
            fsm = fsmBuilder.getFSM();
        }
        catch (FSMInvalidException fie) {
            TransferLog.getLogger().log(Level.SEVERE, "Failed to create Generate Wizard", fie);
        }
        if (fsm != null) {
            TransferDescriptor td;
            TransferState state;
            FSMWizard wiz = new FSMWizard(fsm, namespace);
            wiz.setWizardTitle(TransferArb.getString(227));
            TransferUtil.setWizardLogo((BaseWizard)wiz, TransferArb.getImage(102));
            wiz.setRoadmapVisible(true);
            wiz.addCommitListener((CommitListener)this);
            WizardDialog dialog = wiz.getDialog((Frame)Ide.getMainWindow());
            boolean done = dialog.runDialog();
            if (done && (state = (td = (TransferDescriptor)((Object)namespace.get("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY"))).getTransferState()) != null && !state.hasFailed() && state.isPrepDone()) {
                TransferRunnable runner = TransferRunnable.createTransferRunnable(td);
                try {
                    this.doTransfer(td);
                }
                catch (TransferFailedException tfe) {
                    TransferUtil.showExceptionDialog((Component)Ide.getMainWindow(), tfe, this.getTitle(td), null);
                }
            }
            dialog.dispose();
        }
    }

    protected abstract Object getSourceIdentifier(Context var1);

    protected abstract Class<? extends ProviderTransferTarget> getDBTarget();

    protected abstract Class<? extends TransferPolicy> getTransferPolicy(TransferDescriptor var1);

    protected TransferDescriptor createDescriptor(String name, Class<? extends TransferTarget> target, Context context) {
        Object sourceProvider = this.getSourceIdentifier(context);
        TransferDescriptor desc = new TransferDescriptor();
        desc.setSource(sourceProvider);
        if (target != null) {
            desc.getOrCreateTransferTarget(target);
            if (ProviderTransferTarget.class.isAssignableFrom(target)) {
                desc.setTarget(name);
            }
        }
        this.setupDescriptor(desc, context);
        return desc;
    }

    protected void setupDescriptor(TransferDescriptor desc, Context context) {
        desc.setPolicy(this.getTransferPolicy(desc));
        this.setDescriptorObjects(desc, context);
    }

    protected abstract void setDescriptorObjects(TransferDescriptor var1, Context var2);

    protected String getTitle(TransferDescriptor td) {
        return TransferArb.getString(227);
    }

    protected abstract String getDefaultConnection(Context var1);

    public void commit(ApplyEvent event) throws TraversalException {
        TraversableContext tc = event.getTraversableContext();
        TransferDescriptor td = (TransferDescriptor)((Object)tc.get("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY"));
        try {
            this.doTransfer(td);
        }
        catch (TransferFailedException tfe) {
            throw new TraversalException(tfe.getMessage());
        }
    }

    public void cancel(ApplyEvent event) {
    }

    public void checkCommit(ApplyEvent event) throws TraversalException {
    }

    public void rollback(ApplyEvent event) {
    }

    protected static IdeAction createGenerateAction(String name, Class<? extends TransferTarget> target, GenerateController controller) {
        GenerateTargetRegistry reg = GenerateTargetRegistry.getInstance();
        String stripped = StringUtils.stripMnemonic((String)name);
        String cmd = target != null ? reg.getDisplayName(target) : GENERATE_CMD + name;
        boolean dots = target == null || reg.getSteps(target) != null;
        int id = Ide.createCmdID((String)cmd);
        IdeAction action = IdeAction.get((int)id, (String)(stripped + (dots ? "..." : "")), (Integer)StringUtils.getMnemonicKeyCode((String)name));
        action.addController((Controller)controller);
        action.putValue(TARGET_KEY, target);
        action.putValue(NAME_KEY, (Object)stripped);
        return action;
    }

    public static JMenu createGenerateMenu(ContextMenu cm, String name, GenerateController controller) {
        Collection<Object> arnames;
        DatabaseConnections dc;
        if (controller == null) {
            throw new IllegalArgumentException("controller cannot be null");
        }
        if (!ModelUtil.hasLength((String)name)) {
            name = TransferArb.getString(96);
        }
        JMenu submenu = cm.createSubMenu(StringUtils.stripMnemonic((String)name), Integer.valueOf(StringUtils.getMnemonicKeyCode((String)name)));
        Context context = cm.getContext();
        float weight = 1.0f;
        String defaultConn = controller.getDefaultConnection(context);
        JMenuItem defaultItem = null;
        if (ModelUtil.hasLength((String)defaultConn)) {
            IdeAction action = GenerateController.createGenerateAction(defaultConn, null, controller);
            defaultItem = cm.createMenuItem((ToggleAction)action, weight);
            defaultItem.setEnabled(false);
            cm.add((Component)defaultItem, submenu, weight);
            weight += 1.0f;
        }
        if ((dc = AppDatabaseConnections.getAppDatabaseConnections((Context)context)) == null) {
            arnames = Collections.emptyList();
        } else {
            arnames = dc.listConnections(true);
            for (String string : arnames) {
                if (string.equals(defaultConn)) {
                    defaultItem.setEnabled(true);
                    continue;
                }
                IdeAction action = GenerateController.createGenerateAction(string, null, controller);
                cm.add((Component)cm.createMenuItem((ToggleAction)action, weight), submenu, weight);
            }
            weight += 1.0f;
        }
        DatabaseConnections central = DatabaseConnections.getInstance();
        for (String cname : central.listConnections(true)) {
            if (arnames.contains(cname)) continue;
            IdeAction action = GenerateController.createGenerateAction("&" + cname, null, controller);
            cm.add((Component)cm.createMenuItem((ToggleAction)action, weight), submenu, weight);
        }
        weight += 1.0f;
        GenerateTargetRegistry reg = GenerateTargetRegistry.getInstance();
        for (Class<? extends TransferTarget> target : reg.getTargets(context)) {
            String tname = "&" + reg.getDisplayName(target);
            IdeAction action = GenerateController.createGenerateAction(tname, target, controller);
            cm.add((Component)cm.createMenuItem((ToggleAction)action, weight), submenu, weight);
        }
        MnemonicSolver solver = new MnemonicSolver(submenu);
        solver.solve();
        return submenu;
    }

    public static final IdeAction getGenerateAction() {
        IdeAction gen = IdeAction.find((int)GENERATE_CMD_ID);
        if (gen == null) {
            String text = TransferArb.getString(36);
            gen = IdeAction.get((int)GENERATE_CMD_ID, (String)StringUtils.stripMnemonic((String)text), (Integer)StringUtils.getMnemonicKeyCode((String)text));
        }
        return gen;
    }

    private class MyFSMBuilder
    extends FSMBuilder {
        private String m_firstTraversable;

        public void setFirstTraversable(String firstTraversable) {
            this.m_firstTraversable = firstTraversable;
        }

        public String getFirstTraversable() {
            return this.m_firstTraversable;
        }
    }
}

