/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.db.transfer.TransferState;
import oracle.ide.db.transfer.TransferTarget;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransferTarget
extends HashStructureAdapter
implements TransferTarget {
    protected TransferDescriptor m_td;
    private static HashSet<String> s_immutableProperties = new HashSet<String>(Arrays.asList(new String[0]));

    private AbstractTransferTarget() {
        super(HashStructure.newInstance());
    }

    protected AbstractTransferTarget(TransferDescriptor td) {
        super(td.getProperties());
        this.m_td = td;
    }

    protected void displaySummary(SchemaObject[] result) {
    }

    protected void validateResultSet(ResultSet rs) {
    }

    private void validateResultSetImpl(ResultSet rs) {
        ArrayList<ResultSet> trail = new ArrayList<ResultSet>();
        this.walk(rs, trail);
    }

    private void walk(ResultSet rs, ArrayList<ResultSet> trail) {
        if (!rs.isSame() && rs.a() != null && rs.b() != null) {
            this.validate(rs, trail);
            int trailIndex = trail.size();
            Iterator i = rs.getChildIterator();
            while (i.hasNext()) {
                ResultSet child = (ResultSet)i.next();
                while (trailIndex < trail.size()) {
                    trail.remove(trailIndex);
                }
                trail.add(trailIndex, rs);
                this.walk(child, trail);
            }
        }
    }

    private void validate(ResultSet rs, ArrayList<ResultSet> trail) {
        String name = rs.getName();
        if (s_immutableProperties.contains(name)) {
            String fullName = this.getFullName(trail, name);
            String message = TransferArb.format(8, fullName, DisplayProps.getAVal((ResultSet)rs), DisplayProps.getBVal((ResultSet)rs));
            TransferState ts = this.m_td.getTransferState();
            ts.addMessage(message);
            rs.setSame(true);
        }
    }

    private String getFullName(ArrayList<ResultSet> trail, String name) {
        StringBuffer result = new StringBuffer();
        for (ResultSet rs : trail) {
            if (!ModelUtil.hasLength((String)rs.getName())) continue;
            if (result.length() > 0) {
                result.append(".");
            }
            result.append(rs.getName());
        }
        return result.toString() + "." + name;
    }
}

