/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer;

import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.transfer.generate.GenerateController;
import oracle.ide.model.Element;
import oracle.ideimpl.db.transfer.OnlineGenerateController;
import oracle.javatools.icons.OracleIcons;

public final class DBToDBTransferContextMenuListener
implements ContextMenuListener {
    private static final float TRANSFER_SECTION_CTXT_MENU = MenuConstants.increment((float)MenuConstants.SECTION_TOOLS_CTXT_MENU);

    public void menuWillShow(ContextMenu contextMenu) {
        Context c = contextMenu.getContext();
        Element e = c.getElement();
        boolean online = this.isConnectionElement(e);
        if (online) {
            if (e instanceof DBObjectNode) {
                JMenu submenu = GenerateController.createGenerateMenu(contextMenu, null, new OnlineGenerateController());
                contextMenu.add((Component)submenu, TRANSFER_SECTION_CTXT_MENU);
            } else {
                IdeAction transferDBToDB = GenerateController.getGenerateAction();
                JMenuItem mi = contextMenu.createMenuItem((ToggleAction)transferDBToDB);
                mi.setIcon(OracleIcons.getIcon((String)"sqlfile.png"));
                contextMenu.add((Component)mi, TRANSFER_SECTION_CTXT_MENU);
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private boolean isConnectionElement(Element e) {
        return DBObjectNodeUtil.getConnectionName((Object)e) != null;
    }
}

