/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer;

import java.io.IOException;
import java.net.URL;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.db.model.SqlNode;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.db.transfer.TransferFailedException;
import oracle.ide.dialogs.ExceptionDialog;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.FilePath;
import oracle.ideimpl.db.transfer.AbstractTransferTarget;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.TransferLog;
import oracle.ideimpl.db.transfer.TransferUtil;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.data.HashStructure;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.diff.ResultSet;

public class DDLTransferTarget
extends AbstractTransferTarget {
    private static final String SQLFILE = "sqlFile";
    private static final String SQLPLUS = "sqlPlus";
    private static final String SPOOLCOMMANDS = "spoolCommands";
    private static final String SCHEMANAMES = "schemaNames";
    public static final String KEY = "oracle.ideimpl.db.transfer.handlers.DDLTransfer.KEY";
    protected static final String NAME_KEY = "DDLTransfer";

    public DDLTransferTarget(TransferDescriptor td) {
        super(td);
    }

    public DDLTransferTarget copyTo(Object target) {
        if (target != null) {
            TransferLog.log("DDLTransfer.copyTo() cant cope with a copy target", new Object[0]);
            throw new IllegalArgumentException("Attempt to copy from an object of type " + this.getClass().getName() + " to an object of type " + target.getClass().getName());
        }
        TransferDescriptor td = this.m_td.copyTo(null);
        return this.copyTo(new DDLTransferTarget(td));
    }

    public SchemaObject[] transfer(ResultSet rs) throws TransferFailedException {
        DDLGenerator ddlGen = this.createDDLGenerator();
        if (ddlGen == null) {
            TransferLog.getLogger().severe("\"SQL Script\" transfer target cannot find a DDL generator.");
        } else {
            this.validateResultSet(rs);
            DDLOptions options = new DDLOptions();
            options.setReplace(this.m_td.isReplace());
            options.setCascade(this.m_td.isCascadeDelete());
            options.setIncludePrompts(this.isGenerateSQLPlus());
            options.setPrefixSchemaName(this.isGenerateSchemaNames());
            if (this.isGenerateSpoolCommands()) {
                options.setSpoolFile(this.getSpoolFilename(this.getSQLFileURL(), this.isGenerateSQLPlus(), true));
            }
            DDL ddl = ddlGen.getUpdateDDL(options, rs);
            this.createSQLNode(this.getSQLFileURL(), ddl.toString());
        }
        return null;
    }

    public String getDescription() {
        String name = "";
        URL url = this.getSQLFileURL();
        if (url != null) {
            name = URLFileSystem.getName((URL)url);
        }
        return TransferArb.format(197, name);
    }

    private DDLGenerator createDDLGenerator() {
        DDLGenerator result = null;
        try {
            DBObjectProvider prov = this.m_td.getTargetProvider();
            if (prov != null) {
                result = prov.getDescriptor().getDDLGenerator(prov);
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (result == null) {
            try {
                DBObjectProvider prov = this.m_td.getSourceProvider();
                if (prov != null) {
                    result = prov.getDescriptor().getDDLGenerator(prov);
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        return result;
    }

    private void createSQLNode(URL sqlFileURL, String ddlString) {
        try {
            SqlNode sqlNode = (SqlNode)NodeFactory.findOrCreate(SqlNode.class, (URL)sqlFileURL);
            TextBuffer tb = sqlNode.acquireTextBuffer();
            tb.removeToEnd(0);
            tb.append(ddlString.toCharArray());
            sqlNode.releaseTextBuffer();
            try {
                sqlNode.save();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new 1(this, sqlNode));
        }
        catch (Exception ex) {
            ExceptionDialog.showExceptionDialog((Context)Context.newIdeContext(), (Throwable)ex, (String)ex.getMessage());
        }
    }

    private String getSpoolFilename(URL sqlFileURL, boolean sqlPlusExt, boolean spooling) {
        String spoolFilename = null;
        if (sqlPlusExt && spooling) {
            spoolFilename = FilePath.getName((String)sqlFileURL.getPath()) + ".log";
        }
        return spoolFilename;
    }

    public HashStructure getProperties() {
        return this._hash;
    }

    public URL getSQLFileURL() {
        Object sourceIdent;
        URL sqlFilename = this._hash.getURL(SQLFILE);
        if (sqlFilename == null && this.m_td != null && (sourceIdent = this.m_td.getSource()) instanceof URL) {
            URL proURL = (URL)sourceIdent;
            sqlFilename = TransferUtil.getDefaultSqlFilename(proURL);
        }
        return sqlFilename;
    }

    public void setSQLFileURL(URL url) {
        this._hash.putURL(SQLFILE, url);
    }

    public boolean isGenerateSQLPlus() {
        return this._hash.getBoolean(SQLPLUS);
    }

    public void setGenerateSQLPlus(boolean sqlPlus) {
        this._hash.putBoolean(SQLPLUS, sqlPlus);
    }

    public boolean isGenerateSpoolCommands() {
        return this._hash.getBoolean(SPOOLCOMMANDS);
    }

    public void setGenerateSpoolCommands(boolean spool) {
        this._hash.putBoolean(SPOOLCOMMANDS, spool);
    }

    public boolean isGenerateSchemaNames() {
        return this._hash.getBoolean(SCHEMANAMES);
    }

    public void setGenerateSchemaNames(boolean schemaName) {
        this._hash.putBoolean(SCHEMANAMES, schemaName);
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ SqlNode v$sqlNode;
        final /* synthetic */ DDLTransferTarget this$0;

        public void run() {
            EditorUtil.openDefaultEditorInFrame((Node)this.v$sqlNode);
        }

        public 1(DDLTransferTarget dDLTransferTarget, SqlNode sqlNode) {
            this.v$sqlNode = sqlNode;
            this.this$0 = dDLTransferTarget;
        }
    }
}

