/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer;

import java.util.HashMap;
import java.util.Map;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.db.transfer.TransferFailedException;
import oracle.ideimpl.db.transfer.AbstractTransferPolicy;
import oracle.ideimpl.db.transfer.DBToDBCopyPolicy;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.reconcile.ReconcileUI;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Index;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.ResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnToOnPolicy
extends AbstractTransferPolicy {
    private Database m_target;
    private Schema m_targetSchema;

    @Override
    public SchemaObject[] findExistingObjects(TransferDescriptor td) throws TransferFailedException {
        SchemaObject[] eos = null;
        try {
            this.m_target = (Database)td.getTargetProvider();
            if (this.m_targetSchema == null && this.m_target != null) {
                this.m_targetSchema = this.m_target.getDefaultSchema();
            }
            SchemaObject[] sos = td.getSchemaObjectsAndDependencies();
            eos = new SchemaObject[sos.length];
            if (this.m_target != null) {
                int i = 0;
                while (i < sos.length) {
                    SchemaObject eo;
                    td.getTransferState().checkNotCancelled();
                    eos[i] = eo = this.m_target.getObject(sos[i].getType(), this.m_targetSchema, sos[i].getName());
                    ++i;
                }
            } else {
                int i = 0;
                while (i < sos.length) {
                    eos[i] = null;
                    ++i;
                }
            }
        }
        catch (DBException dbe) {
            throw new TransferFailedException(dbe);
        }
        return eos;
    }

    @Override
    public SchemaObject[] copyForTransfer(TransferDescriptor td, SchemaObject[] eos) throws TransferFailedException {
        this.m_td = td;
        SchemaObject[] sos = td.getSchemaObjectsAndDependencies();
        SchemaObject[] tos = new SchemaObject[sos.length];
        DBToDBCopyPolicy cp = new DBToDBCopyPolicy();
        int i = 0;
        while (i < sos.length) {
            td.getTransferState().checkNotCancelled();
            HashMap<DBObjectID, DBObjectID> stoe = new HashMap<DBObjectID, DBObjectID>();
            this.buildStoEMap(stoe, (DBObject)sos[i], (DBObject)eos[i]);
            cp.setSourceToExistingMap(stoe);
            tos[i] = (SchemaObject)sos[i].copyTo(null, (IDPolicy)cp);
            this.setTargetSchema((DBObjectProvider)this.m_target, tos[i]);
            if (tos[i] instanceof Table) {
                Index[] inds = ((Table)tos[i]).getIndexes();
                int j = 0;
                while (j < inds.length) {
                    if (!this.isIndexForCopy(inds[j])) {
                        ((Table)tos[i]).removeIndex(inds[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        Map idMap = cp.getIDMap();
        int i2 = 0;
        while (i2 < sos.length) {
            td.getTransferState().checkNotCancelled();
            DBUtil.replaceReferenceIDs((DBObject)tos[i2], (Map)idMap);
            ++i2;
        }
        return tos;
    }

    @Override
    public ResultSet getDifferences(SchemaObject[] existingObjects, SchemaObject[] copiedObjects) {
        ReconcileUI rui = new ReconcileUI();
        DiffContext dc = rui.runDiffNoProgress(existingObjects, copiedObjects);
        return dc.getResult();
    }

    public String getTitle(TransferDescriptor td) {
        return TransferArb.getString(12);
    }

    private boolean isIndexForCopy(Index source) {
        boolean result = true;
        String indexName = source.getName();
        Table table = source.getTable();
        Constraint[] cons = table.getConstraints();
        int i = cons.length - 1;
        while (i >= 0) {
            if (indexName.equals(cons[i].getName())) {
                result = false;
                break;
            }
            --i;
        }
        if (result && this.m_target != null) {
            try {
                this.m_target.validateObject((DBObject)source);
            }
            catch (ValidationException ve) {
                result = false;
            }
        }
        return result;
    }

    private void buildStoEMap(Map<DBObjectID, DBObjectID> stoe, DBObject so, DBObject eo) {
        if (eo != null) {
            stoe.put(so.getID(), eo.getID());
            DBObject[] dBObjectArray = so.getOwnedObjects();
            int n = 0;
            while (n < dBObjectArray.length) {
                DBObject sc = dBObjectArray[n];
                this.buildStoEMap(stoe, sc, eo.findOwnedObject(sc.getType(), sc.getName()));
                ++n;
            }
        }
    }
}

