/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer;

import java.util.HashSet;
import oracle.ide.Context;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.db.transfer.TransferPolicy;
import oracle.ide.db.transfer.generate.GenerateController;
import oracle.ide.model.Element;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.Step;
import oracle.ideimpl.db.transfer.OnToOnPolicy;
import oracle.ideimpl.db.transfer.ProviderTransferTarget;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.panels.DBtoDBReconcilePanel;
import oracle.ideimpl.db.transfer.panels.GeneratorConnectionPanelSource;
import oracle.ideimpl.db.transfer.panels.GeneratorConnectionPanelTarget;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.SchemaObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnlineGenerateController
extends GenerateController {
    @Override
    protected Namespace createNamespace(TransferDescriptor desc, Context context) throws DBException {
        Namespace namespace = new Namespace();
        namespace.put("DBObjectProvider", (Object)desc.getSourceProvider());
        namespace.put(Context.class.getName(), (Object)context);
        namespace.put("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY", (Object)desc);
        return namespace;
    }

    @Override
    protected Step getSourceStep() {
        return new Step(TransferArb.getString(38), GeneratorConnectionPanelSource.class, "f1_ondbgeneratesqlwizardsource_html");
    }

    @Override
    protected Step getTargetStep() {
        return new Step(TransferArb.getString(28), GeneratorConnectionPanelTarget.class, "f1_ondbgeneratesqlwizardtarget_html");
    }

    @Override
    protected Step getManualReconcileStep() {
        return new Step(TransferArb.getString(21), DBtoDBReconcilePanel.class, "f1_odbcopyreconcile_html");
    }

    @Override
    protected Object getSourceIdentifier(Context context) {
        Element e = context.getElement();
        return DBObjectNodeUtil.getConnectionName((Object)e);
    }

    @Override
    protected Class<? extends ProviderTransferTarget> getDBTarget() {
        return ProviderTransferTarget.class;
    }

    @Override
    protected Class<? extends TransferPolicy> getTransferPolicy(TransferDescriptor desc) {
        return OnToOnPolicy.class;
    }

    @Override
    protected void setDescriptorObjects(TransferDescriptor td, Context context) {
        Element[] selection = context.getSelection();
        HashSet<SchemaObjectDescriptor> sods = new HashSet<SchemaObjectDescriptor>();
        int i = 0;
        while (i < selection.length) {
            DBObject dbo;
            if (selection[i] instanceof DBObjectNode && (dbo = ((DBObjectNode)selection[i]).getDBObject()) instanceof SchemaObject) {
                sods.add(new SchemaObjectDescriptor(dbo.getName(), dbo.getType(), ((SchemaObject)dbo).getSchema().getName()));
            }
            ++i;
        }
        td.setSchemaObjectDescriptors(sods.toArray(new SchemaObjectDescriptor[sods.size()]));
    }

    @Override
    protected String getDefaultConnection(Context context) {
        return null;
    }
}

