/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer;

import java.util.logging.Level;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.db.transfer.TransferFailedException;
import oracle.ideimpl.db.transfer.AbstractTransferTarget;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.TransferLog;
import oracle.javatools.data.HashStructure;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.util.ModelUtil;

public class ProviderTransferTarget
extends AbstractTransferTarget {
    public static final String KEY = "oracle.ideimpl.db.transfer.handlers.ProviderTransfer.KEY";
    protected static final String NAME_KEY = "ProviderTransfer";

    public ProviderTransferTarget(TransferDescriptor td) {
        super(td);
    }

    public ProviderTransferTarget copyTo(Object target) {
        if (target != null) {
            TransferLog.log("ProviderTransferTarget.copyTo() cant cope with a copy target", new Object[0]);
            throw new IllegalArgumentException("Attempt to copy from an object of type " + this.getClass().getName() + " to an object of type " + target.getClass().getName());
        }
        TransferDescriptor td = this.m_td.copyTo(null);
        return (ProviderTransferTarget)super.copyTo((Object)new ProviderTransferTarget(td));
    }

    public SchemaObject[] transfer(ResultSet rs) throws TransferFailedException {
        SchemaObject[] result = null;
        this.validateResultSet(rs);
        try {
            DBObjectProvider prov = this.m_td.getTargetProvider();
            this.createTargetSchema(prov);
            prov.updateObjects(rs, this.m_td.isReplace(), this.m_td.isCascadeDelete());
            result = this.getTransferredObjects(this.m_td.getTransferState().getCopiedObjects(), prov);
            this.setImportGenerateIDs(result);
            this.displaySummary(result);
            this.openNodes(result);
        }
        catch (DBException dbe) {
            throw new TransferFailedException(dbe.getMessage(), (Exception)((Object)dbe));
        }
        return result;
    }

    public String getDescription() {
        return TransferArb.format(165, this.m_td.getTarget().toString());
    }

    private SchemaObject[] getTransferredObjects(SchemaObject[] sos, DBObjectProvider prov) {
        SchemaObject[] result = new SchemaObject[sos.length];
        String targetSchemaName = this.m_td.getTargetSchemaName();
        Schema targetSchema = null;
        if (targetSchemaName != null) {
            try {
                targetSchema = prov.getSchema(targetSchemaName);
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        int i = 0;
        while (i < sos.length) {
            if (sos[i] != null) {
                String name = sos[i].getName();
                String type = sos[i].getType();
                Schema schema = targetSchema != null ? targetSchema : sos[i].getSchema();
                try {
                    result[i] = prov.getObject(type, schema, name);
                }
                catch (Exception e) {
                    result[i] = null;
                    TransferLog.getLogger().log(Level.SEVERE, "Failed to find Transferred " + type + " " + schema.getName() + "." + name + " after transfer", e);
                }
            } else {
                result[i] = null;
            }
            ++i;
        }
        return result;
    }

    private void createTargetSchema(DBObjectProvider prov) throws DBException {
        if (ModelUtil.hasLength((String)this.m_td.getTargetSchemaName())) {
            this.createTargetSchema(prov, this.m_td.getTargetSchemaName());
        } else {
            SchemaObjectDescriptor[] sods;
            SchemaObjectDescriptor[] schemaObjectDescriptorArray = sods = this.m_td.getSchemaObjectDescriptors();
            int n = 0;
            while (n < schemaObjectDescriptorArray.length) {
                SchemaObjectDescriptor sod = schemaObjectDescriptorArray[n];
                String schemaName = sod.getSchema();
                this.createTargetSchema(prov, schemaName);
                ++n;
            }
        }
    }

    private void createTargetSchema(DBObjectProvider prov, String schemaName) throws DBException {
        Schema schema = null;
        try {
            schema = prov.getSchema(schemaName);
        }
        catch (DBException dbe) {
            // empty catch block
        }
        if (schema == null && ModelUtil.hasLength((String)schemaName)) {
            schema = new Schema(schemaName);
            prov.createSchema(schema, false);
        }
    }

    protected void setImportGenerateIDs(SchemaObject[] newObjects) {
    }

    protected void openNodes(SchemaObject[] newObjects) {
    }

    public HashStructure getProperties() {
        return this._hash;
    }
}

