/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer;

import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.db.transfer.TransferFailedException;
import oracle.ide.db.transfer.TransferManager;
import oracle.ide.db.transfer.TransferState;
import oracle.ideimpl.db.transfer.TransferStateListener;
import oracle.javatools.db.SchemaObject;

public final class TransferRunnable
implements Runnable {
    public static final int PREP = 0;
    public static final int TRAN = 1;
    public static final int BOTH = 2;
    private TransferDescriptor m_td;
    private int m_action;
    private TransferFailedException m_error;
    private SchemaObject[] m_result;

    private TransferRunnable(TransferDescriptor d, int action) {
        this.m_td = d;
        this.m_action = action;
    }

    public TransferDescriptor getDescriptor() {
        return this.m_td;
    }

    public int getAction() {
        return this.m_action;
    }

    public void addStateListener(TransferStateListener list) {
        TransferState s = this.m_td.getTransferState();
        if (s == null) {
            s = this.m_td.initialiseTransferState();
        }
        s.addStateListener(list);
    }

    public void run() {
        try {
            TransferManager m = this.m_td.getTransferManager();
            if (this.m_action == 0) {
                m.prepare(this.m_td);
            } else if (this.m_action == 1) {
                this.m_result = m.transfer(this.m_td);
            } else if (this.m_action == 2) {
                this.m_result = m.prepareAndTransfer(this.m_td);
            }
        }
        catch (TransferFailedException e) {
            this.m_error = e;
        }
    }

    public SchemaObject[] getTransferResult() throws TransferFailedException {
        if (this.m_error != null) {
            throw this.m_error;
        }
        return this.m_result;
    }

    public static TransferRunnable createPrepareRunnable(TransferDescriptor d) {
        return new TransferRunnable(d, 0);
    }

    public static TransferRunnable createTransferRunnable(TransferDescriptor d) {
        return new TransferRunnable(d, 1);
    }

    public static TransferRunnable createPrepareAndTransferRunnable(TransferDescriptor d) {
        return new TransferRunnable(d, 2);
    }
}

