/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer;

import java.util.logging.Level;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ideimpl.db.transfer.TransferLog;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.util.ModelUtil;

public final class TransferSchemaObjectDescriptor
extends HashStructureAdapter
implements PropertyStorage {
    public static final String KEY = "oracle.ideimpl.db.transfer.model.TransferSchemaObjectDescriptor.KEY";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String SCHEMA_NAME = "schemaName";
    SchemaObjectDescriptor m_sod;

    public TransferSchemaObjectDescriptor() {
        this(HashStructure.newInstance());
    }

    public TransferSchemaObjectDescriptor(HashStructure hash) {
        super(hash);
    }

    public TransferSchemaObjectDescriptor(SchemaObjectDescriptor sod) {
        this();
        if (sod != null) {
            this.setName(sod.getName());
            this.setType(sod.getType());
            this.setSchemaName(sod.getSchema());
        }
    }

    public TransferSchemaObjectDescriptor createCopy() {
        return (TransferSchemaObjectDescriptor)((Object)this.copyTo((Object)new TransferSchemaObjectDescriptor(HashStructure.newInstance())));
    }

    public String getName() {
        return this._hash.getString(NAME);
    }

    public void setName(String name) {
        this._hash.putString(NAME, name);
    }

    public String getType() {
        return this._hash.getString(TYPE);
    }

    public void setType(String name) {
        this._hash.putString(TYPE, name);
    }

    public String getSchemaName() {
        return this._hash.getString(SCHEMA_NAME);
    }

    public void setSchemaName(String schemaName) {
        this._hash.putString(SCHEMA_NAME, schemaName);
    }

    public SchemaObjectDescriptor getSchemaObjectDescriptor() {
        if (this.m_sod == null) {
            Object sod = null;
            String name = this.getName();
            String type = this.getType();
            String schemaName = this.getSchemaName();
            if (ModelUtil.hasLength((String)name) && ModelUtil.hasLength((String)type) && ModelUtil.hasLength((String)schemaName)) {
                this.m_sod = new SchemaObjectDescriptor(name, type, schemaName);
            }
        }
        return this.m_sod;
    }

    public void setSchemaObjectDescriptor(SchemaObjectDescriptor sod) {
        this.m_sod = sod;
        this.setName(sod.getName());
        this.setType(sod.getType());
        this.setSchemaName(sod.getSchema());
    }

    public DBObjectID getDBObjectID(DBObjectProvider prov) {
        DBObjectID id = null;
        String name = this.getName();
        String type = this.getType();
        String schemaName = this.getSchemaName();
        if (ModelUtil.hasLength((String)name) && ModelUtil.hasLength((String)type) && ModelUtil.hasLength((String)schemaName)) {
            try {
                Schema schema = prov.getSchema(schemaName);
                SchemaObject dbo = prov.getObject(type, schema, name);
                id = dbo.getID();
            }
            catch (DBException dbe) {
                TransferLog.getLogger().log(Level.SEVERE, "Cant get Object from TransferSchemaObjectDescriptor", dbe);
            }
        }
        return id;
    }

    public void setSchemaObjectID(DBObjectID dbObjectID) throws DBException {
        SchemaObject so = (SchemaObject)dbObjectID.resolveID();
        this.setName(so.getName());
        this.setType(so.getType());
        this.setSchemaName(so.getSchema().getName());
    }

    public HashStructure getProperties() {
        return this._hash;
    }
}

