/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.tree.TreeNode;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.ide.Ide;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.db.transfer.TransferFailedException;
import oracle.ide.db.transfer.TransferState;
import oracle.ide.db.transfer.TransferTarget;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.wizard.Step;
import oracle.ideimpl.db.transfer.DDLTransferTarget;
import oracle.ideimpl.db.transfer.ProviderTransferTarget;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.TransferLog;
import oracle.ideimpl.db.transfer.reconcile.ReconcileTreeNode;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.dialogs.MessageDialog;

public final class TransferUtil {
    public static final String FILE_EXT = ".sql";
    public static final String BASE_FILENAME = "script";
    public static final String EXTENSION_ID = "oracle.ide.db.transfer";
    private static final Color startHeaderColor = new Color(255, 255, 255);
    private static final Color endHeaderColor = new Color(206, 223, 230);

    private TransferUtil() {
    }

    public static String getTitle(boolean isSource, TransferDescriptor td) {
        Object target;
        Object source;
        String title = "";
        title = isSource ? ((source = td.getSource()) instanceof String ? TransferArb.format(69, source) : TransferUtil.getSourceOfflineDBtitle(td)) : ((target = td.getTarget()) instanceof String ? TransferArb.format(69, target) : TransferUtil.getOfflineDBtitle(target));
        return title;
    }

    public static String getSourceOfflineDBtitle(TransferDescriptor td) {
        int dot;
        Project project;
        String projectName = td.getSourceProjectName();
        if (projectName == null && (project = Ide.getActiveProject()) != null) {
            projectName = project.getShortLabel();
        }
        if (projectName != null && (dot = projectName.lastIndexOf(".")) > 0) {
            projectName = projectName.substring(0, dot);
        }
        Object db = td.getSource();
        String databaseName = "";
        if (db instanceof URL) {
            databaseName = URLFileSystem.getName((URL)((URL)db));
        }
        if (projectName == null) {
            return TransferArb.format(149, databaseName);
        }
        return TransferArb.format(68, projectName, databaseName);
    }

    public static String getOfflineDBtitle(Object offlinedb) {
        Project project = Ide.getActiveProject();
        String projectName = project.getShortLabel();
        int dot = projectName.lastIndexOf(".");
        if (dot > 0) {
            projectName = projectName.substring(0, dot);
        }
        String databaseName = "";
        if (offlinedb instanceof URL) {
            databaseName = URLFileSystem.getName((URL)((URL)offlinedb));
        }
        return TransferArb.format(68, projectName, databaseName);
    }

    public static URL getDefaultSqlFilename(URL proURL) {
        URL tryMe = null;
        try {
            String path = proURL.getPath();
            String protocol = proURL.getProtocol();
            String host = proURL.getHost();
            int port = proURL.getPort();
            path = path.substring(0, path.lastIndexOf("/"));
            URL base = new URL(protocol, host, path);
            boolean exists = true;
            int i = 1;
            while (exists) {
                tryMe = URLFactory.newURL((URL)base, (String)(BASE_FILENAME + i++ + FILE_EXT));
                exists = URLFileSystem.exists((URL)tryMe);
            }
        }
        catch (MalformedURLException e) {
            TransferLog.getLogger().log(Level.SEVERE, "Cant create default SQL filename", e);
        }
        return tryMe;
    }

    public static boolean isJustGenerateToScript(TransferDescriptor td) {
        boolean isJustDDLTransferTarget = false;
        TransferTarget[] tt = td.getTransferTargets();
        if (tt != null && tt.length == 1) {
            TransferTarget[] transferTargetArray = tt;
            int n = 0;
            while (n < transferTargetArray.length) {
                TransferTarget t = transferTargetArray[n];
                if (t instanceof DDLTransferTarget) {
                    isJustDDLTransferTarget = true;
                    break;
                }
                ++n;
            }
        }
        return isJustDDLTransferTarget;
    }

    public static boolean isGenerateToProvider(TransferDescriptor td) {
        boolean hasProviderTransferTarget = false;
        TransferTarget[] tt = td.getTransferTargets();
        if (tt != null) {
            TransferTarget[] transferTargetArray = tt;
            int n = 0;
            while (n < transferTargetArray.length) {
                TransferTarget t = transferTargetArray[n];
                if (t instanceof ProviderTransferTarget) {
                    hasProviderTransferTarget = true;
                    break;
                }
                ++n;
            }
        }
        return hasProviderTransferTarget;
    }

    public static String createStateName(Step step) {
        return step.getTraversableClass().getSimpleName();
    }

    public static void checkWeHaveATransfer(ResultSet rs) throws TransferFailedException {
        if (rs.isSame()) {
            throw new TransferFailedException(TransferArb.getString(184));
        }
    }

    public static void checkWeHaveATransfer(TransferDescriptor td) throws TransferFailedException {
        try {
            if (td.getSchemaObjects(false).length == 0) {
                throw new TransferFailedException(TransferArb.getString(184));
            }
        }
        catch (DBException dbe) {
            TransferState state = td.getTransferState();
            if (state != null) {
                state.setFailed(true);
            }
            throw new TransferFailedException(dbe);
        }
    }

    public static void setWizardLogo(BaseWizard wiz, Image image) {
        wiz.setLogoImage(image);
        wiz.setHeaderGradientBackground(new Color[]{startHeaderColor, endHeaderColor});
    }

    public static void showExceptionDialog(Component parent, TransferFailedException tfe, String title, String helpid) {
        Throwable cause = tfe.getCause();
        if (cause instanceof DBException) {
            DBExceptionDialog.showErrorDialog((Component)parent, (String)title, (DBException)((DBException)cause), (String)helpid);
        } else if (cause == null) {
            TransferLog.getLogger().log(TransferLog.getTraceLogLevel(), tfe.getMessage(), tfe);
            MessageDialog.error((Component)parent, (Object)tfe.getMessage(), (String)title, (String)helpid);
        } else {
            TransferLog.getLogger().log(Level.SEVERE, tfe.getMessage(), cause);
        }
    }

    public static ReconcileTreeNode ccIfPartOfColumnConstraint(ReconcileTreeNode node) {
        return TransferUtil.ccIfPartOfColumnConstraintImpl(node, node);
    }

    private static ReconcileTreeNode ccIfPartOfColumnConstraintImpl(ReconcileTreeNode node, ReconcileTreeNode ancestor) {
        ReconcileTreeNode result = node;
        TreeNode parent = ancestor.getParent();
        if (parent instanceof ReconcileTreeNode) {
            ResultSet rs = ((ReconcileTreeNode)parent).getResultSet();
            result = "MAP".equals(rs.getType()) && ColumnConstraint.class.isAssignableFrom(rs.getResultSetClass()) ? (ReconcileTreeNode)parent : TransferUtil.ccIfPartOfColumnConstraintImpl(node, (ReconcileTreeNode)parent);
        }
        return result;
    }
}

