/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.browser;

import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.model.Attributes;
import oracle.ide.model.DataContainer;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.icons.OracleIcons;

public class TransferDeploymentNode
extends DataContainer {
    private static final String TRANSFER_DESC_NAMESPACE = "http://xmlns.oracle.com/jdeveloper/110000transfer-descriptor";
    public static final String FILE_EXT = ".generate";
    private static final String ROOT_TAG = "TransferDescriptor";
    protected TransferDescriptor m_td;
    private Attributes m_attributes;

    public TransferDescriptor getDescriptor() {
        if (!this.isOpen() && URLFileSystem.exists((URL)this.getURL())) {
            this.ensureOpen();
        }
        return this.m_td;
    }

    public void setDescriptor(TransferDescriptor desc) {
        if (desc == null) {
            throw new IllegalArgumentException("descriptor cannot be null");
        }
        this.m_td = desc;
        this.setOpen(true);
        this.markDirty(true);
        UpdateMessage.fireStructureChanged((Subject)this);
    }

    protected void closeImpl() throws IOException {
        this.m_td = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveImpl() throws IOException {
        URL url = this.getURL();
        if (url != null) {
            TransferDescriptor transferDescriptor = this.m_td;
            synchronized (transferDescriptor) {
                HashStructureIO hsio = new HashStructureIO(TRANSFER_DESC_NAMESPACE, ROOT_TAG);
                try {
                    hsio.save(url, (Object)this.m_td.getProperties());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl() throws IOException {
        URL url = this.getURL();
        if (url != null) {
            URL uRL = url;
            synchronized (uRL) {
                HashStructureIO hsio = new HashStructureIO(TRANSFER_DESC_NAMESPACE, ROOT_TAG);
                HashStructure hash = null;
                hash = (HashStructure)hsio.load(url);
                this.m_td = new TransferDescriptor(hash);
            }
        }
    }

    public Attributes getAttributes() {
        if (this.m_attributes == null) {
            this.m_attributes = new ElementAttributes();
            this.m_attributes.set(ElementAttributes.SAVEABLE);
            this.m_attributes.set(ElementAttributes.ERASEABLE);
            this.m_attributes.set(ElementAttributes.RENAMEABLE);
            this.m_attributes.set(ElementAttributes.NON_HISTORIED);
        }
        return this.m_attributes;
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"log.png");
    }
}

