/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.explorer;

import java.awt.Component;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import oracle.ide.Context;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.db.transfer.TransferTarget;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.explorer.Explorer;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.db.transfer.DDLTransferTarget;
import oracle.ideimpl.db.transfer.ProviderTransferTarget;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.TransferUtil;
import oracle.ideimpl.db.transfer.browser.TransferDeploymentNode;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class TransferDescriptorExplorer
extends Explorer
implements Observer {
    private JTree m_tree;
    private DefaultTreeModel m_model;
    private JScrollPane m_scrollPane;
    private boolean m_observing;
    private Subject m_obj;
    private static TreeCellRenderer s_rend = null;

    protected final void setSubject(Subject subj) {
        this.m_obj = subj;
    }

    public final Component getGUI() {
        if (this.m_scrollPane == null) {
            this.m_scrollPane = new JScrollPane();
            this.m_scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.m_scrollPane.setViewportView(this.createComponent(this.m_obj));
        }
        return this.m_scrollPane;
    }

    private void startObserving() {
        if (!this.m_observing && this.m_obj != null) {
            this.m_observing = true;
            this.m_obj.attach((Observer)this);
        }
    }

    private void stopObserving() {
        if (this.m_observing && this.m_obj != null) {
            this.m_observing = false;
            this.m_obj.detach((Observer)this);
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (this.m_observing && this.m_obj != null && updateMessage.getMessageID() == UpdateMessage.STRUCTURE_CHANGED && this.m_scrollPane != null) {
            this.m_scrollPane.setViewportView(this.createComponent(this.m_obj));
        }
    }

    public void stateChanged(int state) {
        switch (state) {
            case 0: {
                if (this.m_scrollPane == null) break;
                this.m_scrollPane.setViewportView(this.createComponent(this.m_obj));
                this.startObserving();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.stopObserving();
                break;
            }
        }
    }

    public void setContext(Context context) {
        super.setContext(context);
        if (this.defaultNode instanceof TransferDeploymentNode) {
            this.setSubject((Subject)this.defaultNode);
        }
    }

    public Component createComponent(Subject node) {
        TransferDescriptor td;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        TransferDescriptor transferDescriptor = td = node == null ? null : ((TransferDeploymentNode)node).getDescriptor();
        if (td != null) {
            TransferDescriptorExplorer.buildTree(td, root);
        }
        if (this.m_tree == null) {
            this.m_model = new DefaultTreeModel(root);
            this.m_tree = new JTree(this.m_model);
            this.m_tree.setCellRenderer(TransferDescriptorExplorer.getCellRenderer());
            this.m_tree.setShowsRootHandles(true);
            this.m_tree.setRootVisible(true);
        } else {
            this.m_model.setRoot(root);
            this.m_model.reload();
        }
        IdeUtil.expandTreeToDepth((JTree)this.m_tree, (int)2);
        this.m_tree.setSelectionPath(null);
        return this.m_tree;
    }

    public static void buildTree(TransferDescriptor td, DefaultMutableTreeNode treeRoot) {
        if (td != null) {
            TransferTarget[] tts = td.getTransferTargets();
            String one = "";
            String two = "";
            String top = "";
            String createOrReplace = "";
            if (td.isReconcile()) {
                one = TransferArb.getString(33);
            } else {
                createOrReplace = td.isReplace() ? TransferArb.getString(109) : TransferArb.getString(242);
            }
            Icon sourceIcon = null;
            String source = TransferArb.getString(26);
            if (td.getSource() instanceof String) {
                if (!ModelUtil.hasLength((String)one)) {
                    one = TransferArb.getString(194);
                }
                two = TransferArb.getString(61);
                source = source + TransferArb.format(69, (String)td.getSource());
                sourceIcon = OracleIcons.getIcon((String)"dbconn.png");
            } else {
                if (!ModelUtil.hasLength((String)one)) {
                    one = TransferArb.getString(198);
                }
                two = tts.length == 1 && tts[0] instanceof DDLTransferTarget ? TransferArb.getString(83) : TransferArb.getString(243);
                source = source + TransferUtil.getSourceOfflineDBtitle(td);
                sourceIcon = OracleIcons.getIcon((String)"project.png");
            }
            top = TransferArb.format(251, one, two);
            treeRoot.setUserObject(top);
            JLabel sourceObj = new JLabel();
            sourceObj.setText(source);
            sourceObj.setIcon(sourceIcon);
            DefaultMutableTreeNode sourceNode = new DefaultMutableTreeNode(sourceObj);
            treeRoot.add(sourceNode);
            String target = TransferArb.getString(11);
            Icon targetIcon = null;
            if (td.getTarget() instanceof String) {
                if (tts.length == 1) {
                    targetIcon = TransferDescriptorExplorer.getTargetIcon(tts[0]);
                    target = target + tts[0].getDescription();
                }
            } else {
                String databaseName = "";
                if (tts.length == 1 && tts[0] instanceof DDLTransferTarget) {
                    targetIcon = OracleIcons.getIcon((String)"sqlfile.png");
                    target = target + tts[0].getDescription();
                } else if (td.getTarget() instanceof URL) {
                    target = target + TransferUtil.getOfflineDBtitle(td.getTarget());
                    targetIcon = OracleIcons.getIcon((String)"project.png");
                }
            }
            JLabel targetObj = new JLabel();
            targetObj.setText(target);
            targetObj.setIcon(targetIcon);
            DefaultMutableTreeNode targetNode = new DefaultMutableTreeNode(targetObj);
            treeRoot.add(targetNode);
            if (tts.length > 1) {
                TransferTarget[] transferTargetArray = tts;
                int n = 0;
                while (n < transferTargetArray.length) {
                    TransferTarget tt = transferTargetArray[n];
                    JLabel obj = new JLabel();
                    obj.setText(tt.getDescription());
                    obj.setIcon(TransferDescriptorExplorer.getTargetIcon(tt));
                    DefaultMutableTreeNode ttNode = new DefaultMutableTreeNode(obj);
                    targetNode.add(ttNode);
                    ++n;
                }
            }
            DefaultMutableTreeNode objsFolder = new DefaultMutableTreeNode(TransferArb.getString(29));
            treeRoot.add(objsFolder);
            SchemaObjectDescriptor[] descs = td.getSchemaObjectDescriptors();
            int i = 0;
            while (i < descs.length) {
                if (descs[i] != null) {
                    objsFolder.add(new DefaultMutableTreeNode(descs[i]));
                }
                ++i;
            }
            DefaultMutableTreeNode chooseFolder = new DefaultMutableTreeNode(TransferArb.getString(94));
            treeRoot.add(chooseFolder);
            String op = TransferArb.format(25, one);
            if (td.isReplace()) {
                op = TransferArb.format(13, td.isCascadeDelete() ? TransferArb.getString(101) : "");
            } else if (td.isReconcile()) {
                op = TransferArb.format(170, td.isManualReconcile() ? TransferArb.getString(0) : "");
            }
            JLabel chooseObj = new JLabel();
            chooseObj.setText(op);
            DefaultMutableTreeNode chooseNode = new DefaultMutableTreeNode(chooseObj);
            chooseFolder.add(chooseNode);
            String targetSchemaName = td.getTargetSchemaName();
            if (ModelUtil.hasLength((String)targetSchemaName)) {
                JLabel orideSchemaObj = new JLabel();
                orideSchemaObj.setText(TransferArb.format(238, targetSchemaName));
                DefaultMutableTreeNode orideSchemaNode = new DefaultMutableTreeNode(orideSchemaObj);
                chooseFolder.add(orideSchemaNode);
            }
            int dependencyDepth = td.getDependencyDepth();
            boolean includeAllDependencies = td.getIncludeAllDependencies();
            String incDep = null;
            if (dependencyDepth > 0) {
                incDep = TransferArb.format(43, dependencyDepth);
            }
            if (includeAllDependencies) {
                incDep = TransferArb.getString(45);
            }
            if (ModelUtil.hasLength(incDep)) {
                JLabel incDepObj = new JLabel();
                incDepObj.setText(incDep);
                DefaultMutableTreeNode incDepNode = new DefaultMutableTreeNode(incDepObj);
                chooseFolder.add(incDepNode);
            }
        }
    }

    private static Icon getTargetIcon(TransferTarget tt) {
        Icon result = null;
        if (tt instanceof ProviderTransferTarget) {
            result = OracleIcons.getIcon((String)"dbconn.png");
        } else if (tt instanceof DDLTransferTarget) {
            result = OracleIcons.getIcon((String)"sqlfile.png");
        }
        return result;
    }

    public static TreeCellRenderer getCellRenderer() {
        if (s_rend == null) {
            s_rend = new Renderer(null);
        }
        return s_rend;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Renderer
    extends DBObjectRenderer {
        private Renderer() {
            super(true);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object obj;
            Component result = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode && (obj = ((DefaultMutableTreeNode)value).getUserObject()) instanceof JLabel && result instanceof JLabel) {
                ((JLabel)result).setText(((JLabel)obj).getText());
            }
            return result;
        }

        Renderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

