/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.panels.SkippingTraversable;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.db.transfer.TransferFailedException;
import oracle.ide.db.transfer.TransferTarget;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.transfer.DDLTransferTarget;
import oracle.ideimpl.db.transfer.ProviderTransferTarget;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.TransferRunnable;
import oracle.ideimpl.db.transfer.TransferUtil;
import oracle.ideimpl.db.transfer.panels.TargetConnPanel;
import oracle.ideimpl.db.transfer.panels.TransferProgressBar;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.util.ModelUtil;

public class ChooseOp
extends SkippingTraversable
implements ActionListener {
    public static final String PANEL_ID = "ChooseOp";
    protected WizardCallbacks m_wizCallbacks;
    private boolean m_hasTables;
    protected TransferDescriptor m_td;
    private JWrappedLabel m_desc;
    protected JRadioButton m_create;
    protected JRadioButton m_replace;
    protected JRadioButton m_alter;
    private JCheckBox m_cascadeDelete;

    private void $init$() {
        this.m_desc = new JWrappedLabel();
        this.m_create = new JRadioButton();
        this.m_replace = new JRadioButton();
        this.m_alter = new JRadioButton();
        this.m_cascadeDelete = new JCheckBox();
    }

    public ChooseOp() {
        this.$init$();
    }

    protected void layoutComponents() {
        DBUIResourceHelper resHelper = new DBUIResourceHelper(PANEL_ID);
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.m_desc.setText(TransferArb.getString(77));
        this.add((Component)this.m_desc, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_create);
        bg.add(this.m_replace);
        bg.add(this.m_alter);
        this.m_create.setSelected(true);
        this.m_create.addActionListener(this);
        this.m_replace.addActionListener(this);
        this.m_alter.addActionListener(this);
        resHelper.resButton((AbstractButton)this.m_create, TransferArb.getString(92), "m_create");
        resHelper.resButton((AbstractButton)this.m_replace, TransferArb.getString(147), "m_replace");
        resHelper.resButton((AbstractButton)this.m_alter, TransferArb.getString(52), "m_alter");
        this.add(this.m_create, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_replace, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_cascadeDelete.addActionListener(this);
        this.m_cascadeDelete.setEnabled(false);
        this.m_cascadeDelete.setSelected(false);
        resHelper.resButton((AbstractButton)this.m_cascadeDelete, TransferArb.getString(248), "m_cascadeDelete");
        this.add(this.m_cascadeDelete, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 20, 5, 0), 0, 0));
        this.add(this.m_alter, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        JCheckBox manualReconcile = this.getManualReconcile();
        if (manualReconcile != null) {
            this.add(manualReconcile, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 20, 5, 0), 0, 0));
            TargetConnPanel conn = this.getConnection();
            if (conn != null) {
                this.add((Component)((Object)conn), new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 20, 5, 0), 0, 0));
            }
        }
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, y++, 10, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel otherBits = this.getOtherBits();
        if (otherBits != null) {
            // empty if block
        }
        this.add(otherBits, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected JPanel getOtherBits() {
        return null;
    }

    protected JCheckBox getManualReconcile() {
        return null;
    }

    protected TargetConnPanel getConnection() {
        return null;
    }

    protected String getTraversableName() {
        return PANEL_ID;
    }

    private boolean isConnectionRequired() {
        boolean isRequired = this.m_td.getTransferTarget(DDLTransferTarget.class) != null && this.m_td.getTransferTarget(ProviderTransferTarget.class) == null;
        return isRequired;
    }

    public void onEntry(TraversableContext tc) {
        super.onEntry(tc);
        this.m_wizCallbacks = tc.getWizardCallbacks();
        this.m_td = (TransferDescriptor)((Object)tc.get("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY"));
        SchemaObjectDescriptor[] sods = this.m_td.getSchemaObjectDescriptors();
        if (sods != null) {
            this.m_hasTables = false;
            int i = 0;
            while (i < sods.length) {
                if (sods[i].getType().equals("TABLE") || sods[i].getType().equals("SEQUENCE")) {
                    this.m_hasTables = true;
                    break;
                }
                ++i;
            }
            boolean replace = this.m_td.isReplace();
            this.m_replace.setSelected(replace);
            this.m_cascadeDelete.setEnabled(replace && this.m_hasTables);
            this.m_cascadeDelete.setSelected(this.m_td.isCascadeDelete());
            boolean reconcile = this.m_td.isReconcile();
            this.m_alter.setSelected(reconcile);
            TargetConnPanel conn = this.getConnection();
            if (conn != null) {
                if (this.isConnectionRequired()) {
                    Object target = this.m_td.getTarget();
                    if (target != null) {
                        conn.setConnectionName(target.toString());
                    }
                    conn.setVisible(true);
                    conn.enableActiveComponents(this.m_alter.isSelected());
                } else {
                    conn.setVisible(false);
                }
            }
        }
        this.checkWizardButtons();
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        if (this.m_td == null) {
            this.m_td = new TransferDescriptor();
            tc.put("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY", (Object)this.m_td);
        }
        this.m_td.setReplace(this.m_replace.isSelected());
        this.m_td.setCascadeDelete(this.m_cascadeDelete.isSelected());
        this.m_td.setReconcile(this.m_alter.isSelected());
        this.m_td.setManualReconcile(this.isManualReconcile());
        TargetConnPanel conn = this.getConnection();
        boolean genDB = TransferUtil.isGenerateToProvider(this.m_td);
        if (conn != null && !genDB && this.m_td.isReconcile()) {
            conn.onExit(tc);
        }
        if (tc.getDirection() == 1) {
            try {
                Schema targetSchema;
                DBObjectProvider targetProv = this.m_td.getTargetProvider();
                String targetSchemaName = this.m_td.getTargetSchemaName();
                if (!ModelUtil.hasLength((String)targetSchemaName)) {
                    SchemaObject[] sos = this.m_td.getSchemaObjects();
                    targetSchemaName = sos[0].getSchema().getName();
                }
                if (targetProv != null && (targetSchema = targetProv.getSchema(targetSchemaName)) == null && !this.isCopyToProject()) {
                    throw new TraversalException(TransferArb.format(174, targetSchemaName, this.m_td.getTarget()));
                }
            }
            catch (DBException dbe) {
                throw new TraversalException((Object)dbe);
            }
        }
        if (tc.getDirection() == 1 && this.m_td.isReconcile() && this.m_td.isManualReconcile()) {
            try {
                TransferRunnable runner = TransferRunnable.createPrepareRunnable(this.m_td);
                TransferProgressBar bar = new TransferProgressBar("Prepare for reconcile", runner);
                bar.start(null, null);
                if (!bar.hasUserCancelled()) {
                    runner.getTransferResult();
                }
            }
            catch (TransferFailedException tfe) {
                throw new TraversalException(tfe.getMessage());
            }
        }
    }

    protected boolean isCopyToProject() {
        return this.m_td.getTarget() instanceof URL;
    }

    private boolean isManualReconcile() {
        JCheckBox manualReconcile = this.getManualReconcile();
        return this.m_alter.isSelected() && manualReconcile != null && manualReconcile.isSelected();
    }

    private boolean isGenerateSqlScripts() {
        return this.m_td.getTransferTarget(DDLTransferTarget.class) != null || this.m_td.getTarget() instanceof String;
    }

    public Object getExitTransition() {
        return this.isManualReconcile();
    }

    protected void updateWizardTransition() {
        if (this.m_wizCallbacks != null) {
            this.m_wizCallbacks.wizardUpdateExpectedTransition(this.getExitTransition());
        }
    }

    private boolean isGenSQLScript() {
        TransferTarget[] tts;
        boolean result = false;
        TransferTarget[] transferTargetArray = tts = this.m_td.getTransferTargets();
        int n = 0;
        while (n < transferTargetArray.length) {
            TransferTarget tt = transferTargetArray[n];
            if (tt instanceof DDLTransferTarget) {
                result = true;
                break;
            }
            ++n;
        }
        return result;
    }

    protected void checkWizardButtons() {
        if (this.m_wizCallbacks != null) {
            boolean canFinish;
            Object source = this.m_td.getSource();
            boolean projectSource = source instanceof URL;
            Object target = this.m_td.getTarget();
            boolean projectTarget = target instanceof URL;
            boolean projToProj = projectSource && projectTarget;
            boolean haveDB = false;
            boolean needDB = this.m_alter.isSelected() && !projToProj;
            boolean haveURL = this.m_td.getSource() instanceof URL;
            boolean needURL = this.isGenSQLScript();
            if (needDB) {
                TargetConnPanel connUI = this.getConnection();
                boolean isConnPanelPop = false;
                if (connUI != null) {
                    String connName = connUI.getConnectionName();
                    isConnPanelPop = ModelUtil.hasLength((String)connName);
                }
                boolean haveTargetConn = target instanceof String;
                haveDB = isConnPanelPop || haveTargetConn;
            }
            JCheckBox manualReconcile = this.getManualReconcile();
            boolean isManualReconcile = this.m_alter.isSelected() && manualReconcile != null && manualReconcile.isSelected();
            boolean canNext = !needDB || haveDB;
            boolean bl = canFinish = canNext && !isManualReconcile;
            if (needURL && !haveURL) {
                canFinish = false;
            }
            this.m_wizCallbacks.wizardEnableButtons(null, Boolean.valueOf(canNext), Boolean.valueOf(canFinish));
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (this.m_create == event.getSource()) {
            this.m_cascadeDelete.setEnabled(false);
            this.m_cascadeDelete.setSelected(false);
        } else if (this.m_replace == event.getSource()) {
            this.m_cascadeDelete.setEnabled(this.m_hasTables);
        } else if (this.m_alter == event.getSource()) {
            this.m_cascadeDelete.setEnabled(false);
            this.m_cascadeDelete.setSelected(false);
        }
        this.checkWizardButtons();
    }
}

