/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.panels;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import oracle.ide.db.panels.SkippingTraversable;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.db.transfer.generate.GenerateTargetRegistry;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.transfer.DDLTransferTarget;
import oracle.ideimpl.db.transfer.OnToOnPolicy;
import oracle.ideimpl.db.transfer.ProviderTransferTarget;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.TransferUtil;
import oracle.ideimpl.db.transfer.panels.TargetConnPanel;

public class GeneratorConnectionPanelTarget
extends SkippingTraversable
implements ActionListener {
    public static final String PANEL_ID = "GeneratorConnectionPanelTarget";
    private static final String GENERATE_TO_SCRIPT = "SQL Script";
    private static final String GENERATE_TO_DB = "Database";
    private WizardCallbacks m_wizCallbacks;
    private final JRadioButton m_rdbDB;
    private final JRadioButton m_rdbScript;
    private ButtonGroup m_rbgDest;
    private TargetConnPanel m_connPanel;

    private void $init$() {
        this.m_rdbDB = new JRadioButton();
        this.m_rdbScript = new JRadioButton();
        this.m_rbgDest = new ButtonGroup();
        this.m_connPanel = new TargetConnPanel();
    }

    public GeneratorConnectionPanelTarget() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void layoutComponents() {
        DBUIResourceHelper resHelper = new DBUIResourceHelper("GenerateConnectionPanelTarget");
        this.m_rbgDest.add(this.m_rdbScript);
        this.m_rbgDest.add(this.m_rdbDB);
        this.m_rdbDB.setActionCommand(GENERATE_TO_DB);
        this.m_rdbScript.setActionCommand(GENERATE_TO_SCRIPT);
        this.m_rdbDB.addActionListener(this);
        this.m_rdbScript.addActionListener(this);
        resHelper.resButton((AbstractButton)this.m_rdbDB, TransferArb.getString(180), "m_rdbDB");
        resHelper.resButton((AbstractButton)this.m_rdbScript, TransferArb.getString(106), "m_rdbScript");
        this.setLayout(new GridBagLayout());
        int y = 0;
        Insets i = new Insets(0, 0, 5, 0);
        this.add(this.m_rdbScript, this.gbc(0, ++y, 1, 1, 0.0, 0.0, 18, 2, i));
        this.add(this.m_rdbDB, this.gbc(0, ++y, 1, 1, 0.0, 0.0, 18, 2, i));
        i = new Insets(10, 0, 5, 0);
        this.add((Component)((Object)this.m_connPanel), this.gbc(0, ++y, 1, 1, 1.0, 0.0, 18, 1, i));
        this.add(Box.createVerticalGlue(), this.gbc(0, ++y, 1, 1, 0.0, 1.0, 18, 3, i));
    }

    private void initRadioBtns(TransferDescriptor td) {
        boolean genSQL;
        boolean genDB = TransferUtil.isGenerateToProvider(td);
        boolean bl = genSQL = td.getTransferTarget(DDLTransferTarget.class) != null;
        if (genDB) {
            this.m_rdbDB.setSelected(true);
        } else {
            this.m_rdbScript.setSelected(true);
        }
        this.m_connPanel.setEnabled(genDB);
    }

    private void setScriptOrDB(TransferDescriptor td) {
        if (this.m_rdbScript.isSelected()) {
            td.getOrCreateTransferTarget(DDLTransferTarget.class);
        } else if (!td.isPlusSqlScript()) {
            td.removeTransferTarget(DDLTransferTarget.class);
        }
        if (this.m_rdbDB.isSelected()) {
            this.addProviderTarget(td);
        } else {
            this.removeProviderTarget(td);
        }
    }

    protected void addProviderTarget(TransferDescriptor td) {
        td.getOrCreateTransferTarget(ProviderTransferTarget.class);
    }

    protected void removeProviderTarget(TransferDescriptor td) {
        td.removeTransferTarget(ProviderTransferTarget.class);
    }

    protected String getTraversableName() {
        return PANEL_ID;
    }

    public void actionPerformed(ActionEvent e) {
        boolean boo = true;
        if (GENERATE_TO_SCRIPT.equals(e.getActionCommand())) {
            boo = false;
        } else if (GENERATE_TO_DB.equals(e.getActionCommand())) {
            boo = true;
        }
        this.m_connPanel.setEnabled(boo);
        this.checkWizardButtons();
    }

    private void checkWizardButtons() {
        if (this.m_wizCallbacks != null) {
            if (this.m_rdbDB.isSelected()) {
                this.m_connPanel.checkWizardButtons();
            } else {
                this.m_wizCallbacks.wizardEnableButtons(null, Boolean.valueOf(true), null);
            }
        }
    }

    protected void setConnectionName(TransferDescriptor td, String connectionName) {
        td.setTarget(connectionName);
        if (td.getSource() instanceof String) {
            td.setPolicy(OnToOnPolicy.class);
        }
        if (this.m_rdbScript.isSelected()) {
            td.getOrCreateTransferTarget(DDLTransferTarget.class);
            this.removeProviderTarget(td);
        } else {
            this.addProviderTarget(td);
            if (!td.isPlusSqlScript()) {
                td.removeTransferTarget(DDLTransferTarget.class);
            }
        }
    }

    public void onEntry(TraversableContext tc) {
        super.onEntry(tc);
        if (this.isSkipping()) {
            return;
        }
        this.m_connPanel.onEntry(tc);
        TransferDescriptor descriptor = (TransferDescriptor)((Object)tc.get("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY"));
        if (descriptor != null) {
            this.initRadioBtns(descriptor);
        }
        this.m_wizCallbacks = tc.getWizardCallbacks();
        this.checkWizardButtons();
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        TransferDescriptor descriptor = (TransferDescriptor)((Object)tc.get("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY"));
        if (descriptor != null && !this.isSkipping()) {
            this.setScriptOrDB(descriptor);
            if (this.m_rdbDB.isSelected()) {
                this.m_connPanel.onExit(tc);
            }
        }
    }

    private void updateWizardTransistion() {
        GenerateTargetRegistry registry = GenerateTargetRegistry.getInstance();
        if (this.m_rdbDB.isSelected()) {
            String state = registry.getDisplayName(DDLTransferTarget.class);
        } else {
            String state = "db";
        }
    }
}

