/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.logging.Level;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.db.transfer.TransferManager;
import oracle.ide.db.transfer.TransferState;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.db.transfer.TransferLog;
import oracle.ideimpl.db.transfer.TransferUtil;
import oracle.ideimpl.db.transfer.reconcile.DependancyManager;
import oracle.ideimpl.db.transfer.reconcile.ReconcilePanel;
import oracle.ideimpl.db.transfer.reconcile.ReconcileUI;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Differ;
import oracle.javatools.db.diff.IDByNameComparator;
import oracle.javatools.db.diff.IDByNameDiffer;
import oracle.javatools.db.diff.ResultSet;

public abstract class GeneratorReconcilePanel
extends DefaultTraversablePanel {
    protected TransferDescriptor m_td;
    private WizardCallbacks m_wizCallbacks;
    private ReconcilePanel m_reconcilePanel;

    private void $init$() {
        this.m_reconcilePanel = new ReconcilePanel();
    }

    public GeneratorReconcilePanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void layoutComponents() {
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.add((Component)((Object)this.m_reconcilePanel), new GridBagConstraints(0, y++, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext tc) {
        this.m_wizCallbacks = tc.getWizardCallbacks();
        if (this.m_wizCallbacks != null) {
            this.m_wizCallbacks.wizardSetInitialFocus(null);
        }
        this.m_td = (TransferDescriptor)((Object)tc.get("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY"));
        SchemaObjectDescriptor[] sos = this.m_td.getSchemaObjectDescriptors();
        if (sos != null) {
            DBObjectProvider source = null;
            DBObjectProvider target = null;
            try {
                source = this.m_td.getSourceProvider();
                target = this.m_td.getTargetProvider();
            }
            catch (DBException dbe) {
                // empty catch block
            }
            if (source == null) {
                TransferLog.getLogger().log(Level.SEVERE, "Transfer must have source");
            }
            String sourceName = TransferUtil.getTitle(true, this.m_td);
            String targetName = TransferUtil.getTitle(false, this.m_td);
            boolean srcIsOffline = this.m_td.getSource() instanceof URL;
            boolean tgtIsOffline = this.m_td.getTarget() instanceof URL;
            boolean projToProj = srcIsOffline && tgtIsOffline;
            TransferState state = this.m_td.getTransferState();
            SchemaObject[] dbua = state.getCopiedObjects();
            SchemaObject[] dbma = state.getExistingObjects();
            DependancyManager dm = (DependancyManager)tc.get("RECONCILE_KEY");
            if (dm == null) {
                ReconcileUI rui = this.getReconcileUI(dbua, dbma);
                dm = rui.getDependancyManager();
                DiffContext dc = dm.getDiffContext();
                dc.setIsSrcOffline(srcIsOffline);
                dc.setIsTgtOffline(tgtIsOffline);
                if (projToProj) {
                    DiffEngine de = new DiffEngine(dc.getEngine());
                    dc.setEngine(de);
                    de.registerDiffer((Differ)new IDByNameDiffer(), DBObjectID.class);
                    de.registerComparator((Comparator)new IDByNameComparator(), DBObjectID.class);
                }
                rui.setFullDiffTreeRequired(true);
                boolean ok = rui.runProgressBar();
                if (ok) {
                    String reconcilePanelDesc = this.getReconcilePanelDesc(sourceName, targetName);
                    tc.put("RECONCILE_KEY", (Object)dm);
                    tc.put("RECONCILE_DESC", (Object)reconcilePanelDesc);
                }
            }
            this.m_reconcilePanel.setFromLabel(sourceName);
            this.m_reconcilePanel.setToLabel(targetName);
            this.m_reconcilePanel.setFromA(this.isReconcileFromAtoB());
            this.m_reconcilePanel.onEntry(tc);
        }
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        TransferDescriptor td = (TransferDescriptor)((Object)tc.get("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY"));
        TransferManager tm = td.getTransferManager();
        this.m_reconcilePanel.onExit(tc);
        if (tc.getDirection() == 1) {
            DependancyManager dm = (DependancyManager)tc.get("RECONCILE_KEY");
            if (dm != null) {
                ResultSet rs = dm.getResultSet();
                td.getTransferState().setResultSet(rs);
            }
        } else if (tc.getDirection() == 2) {
            TransferState state = td.getTransferState();
            if (state != null) {
                state.setResultSet(null);
            }
            tc.remove("RECONCILE_KEY");
        }
    }

    private SchemaObject[] getObjects(DBObjectProvider pro, SchemaObjectDescriptor[] sos) {
        ArrayList<SchemaObject> obs = new ArrayList<SchemaObject>();
        SchemaObjectDescriptor[] schemaObjectDescriptorArray = sos;
        int n = 0;
        while (n < schemaObjectDescriptorArray.length) {
            SchemaObjectDescriptor sod = schemaObjectDescriptorArray[n];
            String schemaName = sod.getSchema();
            try {
                Schema schema = pro.getSchema(schemaName);
                obs.add(pro.getObject(sod.getType(), schema, sod.getName()));
            }
            catch (DBException dbe) {
                obs.add(null);
            }
            ++n;
        }
        SchemaObject[] result = obs.toArray(new SchemaObject[sos.length]);
        return result;
    }

    protected abstract ReconcileUI getReconcileUI(SchemaObject[] var1, SchemaObject[] var2);

    protected abstract boolean isReconcileFromAtoB();

    protected abstract String getReconcilePanelDesc(String var1, String var2);
}

