/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.component.NewFilePanel;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.transfer.DDLTransferTarget;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.TransferUtil;

public class GeneratorSqlPanel
extends DefaultTraversablePanel
implements ActionListener,
DocumentListener {
    private boolean m_entered;
    private boolean m_canFinishIfSQLGen;
    private boolean m_canAlwaysFinish;
    private WizardCallbacks m_wizC;
    private JLabel m_desc;
    private JCheckBox m_genSQL;
    private JPanel m_panelOfBits;
    private NewFilePanel m_filePanel;
    private boolean m_fileChanged;
    private JCheckBox m_sqlPlus;
    private JCheckBox m_spool;
    private JCheckBox m_generateSchemaName;

    private void $init$() {
        this.m_desc = new JLabel();
        this.m_genSQL = new JCheckBox();
        this.m_panelOfBits = new JPanel();
        this.m_filePanel = new NewFilePanel();
        this.m_fileChanged = true;
        this.m_sqlPlus = new JCheckBox();
        this.m_spool = new JCheckBox();
        this.m_generateSchemaName = new JCheckBox();
    }

    public GeneratorSqlPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void layoutComponents() {
        DBUIResourceHelper resHelper = new DBUIResourceHelper("GeneratorSqlPanel");
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.m_desc.setText(TransferArb.getString(188));
        this.add(this.m_desc, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 10, 0), 0, 0));
        resHelper.resButton((AbstractButton)this.m_genSQL, TransferArb.getString(49), "m_genSQL");
        this.m_genSQL.addActionListener(this);
        this.add(this.m_genSQL, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 10, 0), 0, 0));
        this.layoutMain(this.m_panelOfBits, resHelper);
        this.m_panelOfBits.setBorder(BorderFactory.createEtchedBorder());
        this.add(this.m_panelOfBits, new GridBagConstraints(0, y++, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.enableBits(false);
    }

    private void layoutMain(JPanel panel, DBUIResourceHelper resHelper) {
        panel.setLayout(new GridBagLayout());
        int y = 0;
        resHelper.resButton((AbstractButton)this.m_generateSchemaName, TransferArb.getString(86), "m_generateSchemaName");
        this.m_generateSchemaName.setSelected(false);
        panel.add((Component)this.m_generateSchemaName, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 15, 5), 0, 0));
        this.m_sqlPlus.addActionListener(this);
        resHelper.resButton((AbstractButton)this.m_sqlPlus, TransferArb.getString(146), "m_sqlPlus");
        this.m_sqlPlus.setSelected(false);
        panel.add((Component)this.m_sqlPlus, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.m_spool.addActionListener(this);
        this.m_spool.setSelected(false);
        this.m_spool.setEnabled(this.m_sqlPlus.isSelected());
        resHelper.resButton((AbstractButton)this.m_spool, TransferArb.getString(93), "m_spool");
        panel.add((Component)this.m_spool, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 20, 5, 5), 0, 0));
        this.m_filePanel.setFileExtension(".sql");
        this.m_filePanel.setDirectoryPrompt(TransferArb.getString(119));
        this.m_filePanel.setFilePrompt(TransferArb.getString(181));
        this.m_filePanel.setFileType("SQL");
        this.m_filePanel.setShowExtension(true);
        this.m_filePanel.setInteractiveMode(true);
        this.m_filePanel.setSupportsAutoFill(false);
        this.m_filePanel.setCanOverwriteOpenNodes(true);
        this.m_filePanel.setFileName("untitled");
        this.m_filePanel.getDirectoryField().getDocument().addDocumentListener(this);
        this.m_filePanel.getFileField().getDocument().addDocumentListener(this);
        panel.add((Component)this.m_filePanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 18, 1, new Insets(10, 5, 15, 5), 0, 0));
        panel.add(Box.createVerticalGlue(), new GridBagConstraints(0, y++, 1, 1, 0.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext tc) {
        DDLTransferTarget target;
        TransferDescriptor td = (TransferDescriptor)((Object)tc.get("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY"));
        if (!this.m_entered) {
            this.m_fileChanged = true;
            Object sourceIdent = td.getSource();
            if (sourceIdent instanceof URL) {
                URL proURL = (URL)sourceIdent;
                this.m_filePanel.setDirectoryURL(URLFileSystem.getParent((URL)proURL));
                URL tryMe = TransferUtil.getDefaultSqlFilename(proURL);
                this.m_filePanel.setFileName(URLFileSystem.getFileName((URL)tryMe));
            }
        }
        boolean gensql = (target = td.getTransferTarget(DDLTransferTarget.class)) != null;
        boolean genDB = TransferUtil.isGenerateToProvider(td);
        this.m_genSQL.getModel().setSelected(gensql);
        this.m_genSQL.setEnabled(!gensql || genDB);
        this.enableBits(gensql);
        if (gensql) {
            URL fileURL = target.getSQLFileURL();
            boolean sqlPlus = target.isGenerateSQLPlus();
            boolean spool = target.isGenerateSpoolCommands();
            boolean schema = target.isGenerateSchemaNames();
            if (fileURL != null) {
                this.m_filePanel.setDirectoryURL(URLFileSystem.getParent((URL)fileURL));
                this.m_filePanel.setFileName(URLFileSystem.getName((URL)fileURL));
                this.m_fileChanged = false;
            }
            this.m_sqlPlus.setSelected(sqlPlus);
            this.m_spool.setSelected(spool);
            this.m_spool.setEnabled(sqlPlus);
            this.m_generateSchemaName.setSelected(schema);
        }
        if (!(this.m_entered || genDB || gensql)) {
            this.m_genSQL.getModel().setSelected(true);
            this.enableBits(true);
        }
        this.m_wizC = tc.getWizardCallbacks();
        if (this.m_wizC != null) {
            this.m_canFinishIfSQLGen = true;
            this.m_canAlwaysFinish = genDB;
            this.m_wizC.wizardEnableButtons(null, null, Boolean.valueOf(this.m_canAlwaysFinish || this.m_canFinishIfSQLGen && this.m_genSQL.isSelected()));
        }
        this.m_entered = true;
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        TransferDescriptor td = (TransferDescriptor)((Object)tc.get("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY"));
        if (this.m_genSQL.isEnabled()) {
            td.setPlusSqlScrip(this.m_genSQL.isSelected());
        }
        if (this.m_genSQL.isSelected()) {
            DDLTransferTarget target = td.getOrCreateTransferTarget(DDLTransferTarget.class);
            if (this.m_fileChanged) {
                URL url = this.m_filePanel.getFileURL();
                if (url == null) {
                    throw new TraversalException(null);
                }
                target.setSQLFileURL(url);
            }
            target.setGenerateSQLPlus(this.m_sqlPlus.isSelected());
            target.setGenerateSpoolCommands(this.m_spool.isSelected());
            target.setGenerateSchemaNames(this.m_generateSchemaName.isSelected());
        } else {
            td.removeTransferTarget(DDLTransferTarget.class);
        }
    }

    private void enableBits(boolean boo) {
        this.m_filePanel.setEnabled(boo);
        this.m_sqlPlus.setEnabled(boo);
        this.m_spool.setEnabled(this.m_sqlPlus.isSelected());
        this.m_generateSchemaName.setEnabled(boo);
        if (this.m_wizC != null) {
            this.m_wizC.wizardEnableButtons(null, null, Boolean.valueOf(this.m_canAlwaysFinish || this.m_canFinishIfSQLGen && boo));
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_sqlPlus) {
            this.m_spool.setEnabled(this.m_sqlPlus.isSelected());
        } else if (source == this.m_genSQL) {
            this.enableBits(this.m_genSQL.isSelected());
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.m_entered) {
            this.m_fileChanged = true;
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.m_entered) {
            this.m_fileChanged = true;
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.m_entered) {
            this.m_fileChanged = true;
        }
    }
}

