/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.ide.Context;
import oracle.ide.component.NewFilePanel;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.browser.TransferDeploymentNode;
import oracle.ideimpl.db.transfer.explorer.TransferDescriptorExplorer;

public class GeneratorSummaryPanel
extends DefaultTraversablePanel
implements ActionListener {
    public static final String KEY_HIDE_DEPLOYMENT_PROFILE = "GeneratorSummaryPanel.hideDeploymentProfile";
    private TransferDescriptor m_td;
    private boolean m_entered;
    private JWrappedLabel m_desc;
    private DefaultMutableTreeNode m_treeRoot;
    private DefaultTreeModel m_treeModel;
    private JTree m_tree;
    private JCheckBox m_fileCheck;
    private NewFilePanel m_newFilePanel;

    private void $init$() {
        this.m_desc = new JWrappedLabel();
        this.m_treeRoot = new DefaultMutableTreeNode(TransferArb.getString(15));
        this.m_treeModel = new DefaultTreeModel(this.m_treeRoot);
        this.m_tree = new JTree(this.m_treeModel);
        this.m_fileCheck = new JCheckBox();
        this.m_newFilePanel = new NewFilePanel();
    }

    public GeneratorSummaryPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    private void layoutComponents() {
        DBUIResourceHelper resHelper = new DBUIResourceHelper("GeneratorSummaryPanel");
        this.setLayout(new GridBagLayout());
        this.m_desc.setText(TransferArb.getString(51));
        this.add((Component)this.m_desc, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setCellRenderer(TransferDescriptorExplorer.getCellRenderer());
        this.add(new JScrollPane(this.m_tree), new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 15, 0), 0, 0));
        resHelper.resButton((AbstractButton)this.m_fileCheck, TransferArb.getString(35), "m_fileCheck");
        this.m_fileCheck.addActionListener(this);
        this.add(this.m_fileCheck, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.m_newFilePanel.setCanOverwriteOpenNodes(true);
        this.m_newFilePanel.setInteractiveMode(true);
        this.m_newFilePanel.setSupportsAutoFill(false);
        this.m_newFilePanel.setShowExtension(true);
        this.m_newFilePanel.setFilePrompt(TransferArb.getString(98));
        this.m_newFilePanel.setFileType(TransferArb.getString(138));
        this.m_newFilePanel.setFileExtension(".generate");
        this.m_newFilePanel.setFileName(TransferArb.getString(64));
        this.m_newFilePanel.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.m_newFilePanel.setEnabled(false);
        this.add((Component)this.m_newFilePanel, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext dataContext) {
        Boolean hideDeploymentProfile;
        dataContext.getWizardCallbacks().wizardSetInitialFocus((Component)this.m_fileCheck);
        this.m_td = (TransferDescriptor)((Object)dataContext.get("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY"));
        if (!this.m_entered) {
            Object def = this.m_td.getSource();
            if (!(def instanceof URL)) {
                def = this.m_td.getTarget();
            }
            if (!(def instanceof URL)) {
                Context c = (Context)dataContext.get(Context.class);
                Project proj = c.getProject();
                def = proj.getURL();
            }
            if (def instanceof URL) {
                URL proURL = (URL)def;
                this.m_newFilePanel.setDirectoryURL(URLFileSystem.getParent((URL)proURL));
            }
            this.m_entered = true;
        }
        if (dataContext.contains(KEY_HIDE_DEPLOYMENT_PROFILE) && (hideDeploymentProfile = (Boolean)dataContext.get(KEY_HIDE_DEPLOYMENT_PROFILE)).booleanValue()) {
            this.m_fileCheck.setVisible(false);
            this.m_newFilePanel.setVisible(false);
        }
        this.transferSummary();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        if (1 == dataContext.getDirection() && this.m_fileCheck.isSelected()) {
            URL fileURL = this.m_newFilePanel.getFileURL();
            if (fileURL == null) {
                throw new TraversalException("Need filename");
            }
            try {
                this.saveDescriptor(fileURL);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new TraversalException(e.getMessage());
            }
        }
    }

    private void transferSummary() {
        this.m_treeRoot.removeAllChildren();
        TransferDescriptorExplorer.buildTree(this.m_td, this.m_treeRoot);
        this.m_treeModel.reload();
        IdeUtil.expandTreeToDepth((JTree)this.m_tree, (int)2);
    }

    private void saveDescriptor(URL url) throws Exception {
        if (this.m_td != null) {
            TransferDeploymentNode node = (TransferDeploymentNode)NodeFactory.findOrCreate(TransferDeploymentNode.class, (URL)url);
            node.setDescriptor(this.m_td);
            node.save();
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_fileCheck) {
            this.m_newFilePanel.setEnabled(this.m_fileCheck.isSelected());
        }
    }
}

