/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import oracle.ide.db.panels.SkippingTraversable;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.controls.ConnectionPicker;
import oracle.jdeveloper.db.panels.GlobalConnectionPanelUI;

public class SourceConnPanel
extends SkippingTraversable {
    private Insets m_defaultInsets;
    private GridBagConstraints m_gbc;
    private GlobalConnectionPanelUI m_conn;
    private WizardCallbacks m_wizCallbacks;

    private void $init$() {
        this.m_defaultInsets = new Insets(10, 5, 5, 5);
        this.m_gbc = this.gbc(0, 0, 1, 1, 1.0, 0.0, 17, 2, this.m_defaultInsets, 0, 0);
    }

    public SourceConnPanel() {
        this(true, true);
    }

    public SourceConnPanel(boolean oracleOnly, boolean showDetails) {
        this.$init$();
        try {
            this.m_conn = new GlobalConnectionPanelUI(oracleOnly);
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.m_gbc.gridx = 0;
        this.m_gbc.gridy = y++;
        this.add((Component)this.m_conn, this.m_gbc);
        this.m_gbc.gridy = y++;
        this.m_gbc.weighty = 1.0;
        this.add(Box.createVerticalGlue(), this.m_gbc);
    }

    public void onEntry(TraversableContext tc) {
        super.onEntry(tc);
        if (this.isSkipping()) {
            return;
        }
        this.m_wizCallbacks = tc.getWizardCallbacks();
        this.m_wizCallbacks.wizardEnableButtons(null, null, Boolean.FALSE);
        String storeName = null;
        String connName = null;
        ConnectionPicker picker = (ConnectionPicker)this.m_conn.getPicker();
        picker.addItemListener((ItemListener)new 1(this, picker));
        if (connName != null) {
            picker.setSelectedConnection(storeName, connName);
        }
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        if (!this.isSkipping()) {
            Database prov = null;
            ConnectionPicker picker = (ConnectionPicker)this.m_conn.getPicker();
            String store = picker.getStoreName();
            String connName = picker.getConnectionName();
            DatabaseConnections chosen = DatabaseConnectionStores.getInstance().getStore(store);
            if (chosen != null) {
                try {
                    prov = chosen.getDatabase(connName);
                }
                catch (DBException dbe) {
                    DatabaseConnectionStores stores = DatabaseConnectionStores.getInstance();
                    String storeDisplayName = stores.getShortLabel(store);
                    throw new TraversalException(TransferArb.format(178, storeDisplayName, connName, dbe.getMessage()), TransferArb.getString(67));
                }
            }
            if (prov == null) {
                throw new TraversalException(TransferArb.getString(231));
            }
            TransferDescriptor td = (TransferDescriptor)((Object)tc.get("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY"));
            tc.put("DBObjectProvider", (Object)prov);
            td.setSourceConnectionStore(store);
            td.setSource(connName);
        }
    }

    protected String getEntryConnection(TraversableContext tc) {
        Object source;
        TransferDescriptor descriptor = (TransferDescriptor)((Object)tc.get("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY"));
        if (descriptor != null && (source = descriptor.getSource()) instanceof String) {
            return (String)source;
        }
        return null;
    }

    protected String getTraversableName() {
        return null;
    }

    static WizardCallbacks ra$m_wizCallbacks(SourceConnPanel sourceConnPanel) {
        return sourceConnPanel.m_wizCallbacks;
    }

    final class 1
    implements ItemListener {
        private final /* synthetic */ ConnectionPicker v$picker;
        final /* synthetic */ SourceConnPanel this$0;

        public void itemStateChanged(ItemEvent ie) {
            SourceConnPanel.ra$m_wizCallbacks(this.this$0).wizardEnableButtons(null, Boolean.valueOf(this.v$picker.getConnectionName() != null), Boolean.FALSE);
        }

        public 1(SourceConnPanel sourceConnPanel, ConnectionPicker connectionPicker) {
            this.v$picker = connectionPicker;
            this.this$0 = sourceConnPanel;
        }
    }
}

