/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.panels;

import java.awt.Component;
import java.net.URL;
import java.util.logging.Level;
import oracle.ide.Ide;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.db.transfer.TransferState;
import oracle.ide.db.transfer.TransferTarget;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.TransferLog;
import oracle.ideimpl.db.transfer.TransferRunnable;
import oracle.ideimpl.db.transfer.TransferStateListener;

public class TransferProgressBar
extends ProgressBar
implements TransferStateListener {
    private TransferRunnable m_runnable;
    private boolean m_doneLoop;

    public TransferProgressBar(String title, TransferRunnable runnable) {
        super((Component)Ide.getMainWindow(), title, (Runnable)runnable, true);
        runnable.addStateListener(this);
        this.m_runnable = runnable;
    }

    public void stateChanged(TransferState ts) {
        if (ts.hasFailed()) {
            this.setDoneStatus();
            return;
        }
        if (ts.isPrepDone()) {
            if (this.m_runnable.getAction() == 0) {
                this.setDoneStatus();
            } else if (ts.getResultSet() == null) {
                if (ts.getDescriptor().isReconcile()) {
                    this.updateProgress(TransferArb.getString(162), null);
                } else {
                    this.updateProgress(TransferArb.getString(135), null);
                }
                this.sleepForUIToRepaint();
            } else {
                TransferTarget tt = ts.getActiveTarget();
                if (tt == null) {
                    this.setDoneStatus();
                } else {
                    String target = tt.getDescription();
                    this.updateProgress(TransferArb.format(160, target), null);
                    this.sleepForUIToRepaint();
                }
            }
        } else {
            Object source = ts.getDescriptor().getSource();
            if (source instanceof URL) {
                source = URLFileSystem.getName((URL)((URL)source));
            }
            this.updateProgress(TransferArb.format(88, source), null);
            this.sleepForUIToRepaint();
        }
    }

    public synchronized void setDoneStatus() {
        if (!this.m_doneLoop) {
            try {
                this.m_doneLoop = true;
                super.setDoneStatus();
                if (this.hasUserCancelled()) {
                    TransferDescriptor desc = this.m_runnable.getDescriptor();
                    if (desc == null) {
                        TransferLog.getLogger().log(Level.SEVERE, "No Tranferdescriptor");
                    } else {
                        TransferState ts = desc.getTransferState();
                        if (ts == null) {
                            TransferLog.getLogger().log(Level.SEVERE, "No TransferState on Tranferdescriptor");
                        } else {
                            ts.cancel();
                        }
                    }
                }
            }
            finally {
                this.m_doneLoop = false;
            }
        }
    }
}

