/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.panels;

import java.util.ArrayList;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.controls.DBObjectSourcePicker;
import oracle.ide.db.controls.SchemaObjectTargetPicker;
import oracle.ide.db.panels.SelectDBObjectsPanel;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.TransferLog;
import oracle.ideimpl.db.transfer.panels.TransferSourcePicker;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;

public class TransferSelectionPanel
extends SelectDBObjectsPanel {
    public static final String PANEL_ID = "TransferSelectionPanel";
    private static final String TRANSFER_PREFS_KEY = "TransferSelectionPanel";
    protected DBObjectProvider m_targetProv;
    private TransferSourcePicker m_from;

    protected void init(boolean providerChanged, TraversableContext dataContext) {
        TransferDescriptor td = (TransferDescriptor)((Object)dataContext.get("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY"));
        DBObjectID[] ids = td.getObjectIDs();
        SchemaObjectDescriptor[] descs = SchemaObjectDescriptor.createDescriptors((DBObjectID[])ids);
        if (descs.length == 0) {
            try {
                SchemaObjectDescriptor[] sods = (SchemaObjectDescriptor[])dataContext.get("SelectDBObjectsPanel.SELECTED_OBJECTS");
                DBObjectProvider sourceDB = td.getSourceProvider();
                ArrayList<SchemaObjectDescriptor> psos = new ArrayList<SchemaObjectDescriptor>();
                SchemaObject[] sos = SchemaObjectDescriptor.unwrapDescriptors((SchemaObjectDescriptor[])sods, (DBObjectProvider)sourceDB);
                if (sos != null) {
                    SchemaObject[] schemaObjectArray = sos;
                    int n = 0;
                    while (n < schemaObjectArray.length) {
                        SchemaObject so = schemaObjectArray[n];
                        if (so != null) {
                            psos.add(new SchemaObjectDescriptor(so));
                        }
                        ++n;
                    }
                    if (psos.size() > 0) {
                        descs = psos.toArray(new SchemaObjectDescriptor[psos.size()]);
                    }
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        if (this.m_callBacks != null) {
            this.m_callBacks.wizardEnableButtons(Boolean.TRUE, null, null);
        }
        try {
            this.m_targetProv = td.getTargetProvider();
            if (this.m_targetProv != null) {
                dataContext.put("TargetDBObjectProvider", (Object)this.m_targetProv);
            }
        }
        catch (DBException dbe) {
            TransferLog.log("failed to get a target provider", new Object[0]);
        }
        SchemaObjectTargetPicker to = (SchemaObjectTargetPicker)this.getToPicker();
        to.getListModel().removeAllElements();
        if (descs != null) {
            int i = 0;
            while (i < descs.length) {
                to.getListModel().addElement(descs[i]);
                ++i;
            }
        }
        to.onEntry(dataContext);
        super.init(providerChanged, dataContext);
        this.checkWizardButtons();
    }

    protected String getSettingsKey() {
        return "TransferSelectionPanel";
    }

    protected void commit(TraversableContext dataContext) throws TraversalException {
        SchemaObjectDescriptor[] descs = (SchemaObjectDescriptor[])this.getSelectedObjects();
        if ((descs == null || descs.length < 1) && 1 == dataContext.getDirection()) {
            throw new TraversalException(TransferArb.getString(246));
        }
        super.commit(dataContext);
        TransferDescriptor descriptor = (TransferDescriptor)((Object)dataContext.get("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY"));
        descriptor.setSchemaObjectDescriptors(descs);
    }

    protected String getTraversableName() {
        return "TransferSelectionPanel";
    }

    private DBObjectID[] getIDs(SchemaObjectDescriptor[] descs) {
        DBObjectID[] ids = descs == null ? null : new DBObjectID[descs.length];
        int i = 0;
        while (i < ids.length && ids != null) {
            ids[i] = descs[i].getObject().getID();
            ++i;
        }
        return ids;
    }

    protected DBObjectProvider getProvider(TraversableContext tc) {
        DBObjectProvider prov = null;
        TransferDescriptor td = (TransferDescriptor)((Object)tc.get("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY"));
        try {
            prov = td.getSourceProvider();
        }
        catch (DBException dbe) {
            TransferLog.log("cant get source provider", new Object[0]);
        }
        return prov;
    }

    protected DBObjectSourcePicker getFromPicker() {
        if (this.m_from == null) {
            this.m_from = new TransferSourcePicker(this.getProvider(), (SchemaObjectTargetPicker)this.getToPicker());
        }
        return this.m_from;
    }
}

