/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.reconcile;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ideimpl.db.transfer.reconcile.ReconcileTreeNode;
import oracle.javatools.util.ModelUtil;

public class CompareTreeCellRenderer
implements TreeCellRenderer {
    private TreeCellRenderer m_treeDelegate;
    private boolean m_iconify;
    private static LineBorder m_lineBorder;
    private static EmptyBorder m_emptyBorder;

    private void $init$() {
        this.m_iconify = true;
    }

    public CompareTreeCellRenderer() {
        this.$init$();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        TreeNode parent;
        Object obj;
        if (this.m_treeDelegate == null) {
            this.m_treeDelegate = new DefaultTreeCellRenderer();
        }
        JLabel retval = (JLabel)this.m_treeDelegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        retval.setOpaque(false);
        retval.setBackground(Color.WHITE);
        retval.setForeground(Color.BLACK);
        if (hasFocus) {
            if (m_lineBorder == null) {
                m_lineBorder = new LineBorder(Color.ORANGE);
            }
            retval.setBorder(m_lineBorder);
        } else {
            if (m_emptyBorder == null) {
                m_emptyBorder = new EmptyBorder(1, 1, 1, 1);
            }
            retval.setBorder(m_emptyBorder);
        }
        if (value instanceof ReconcileTreeNode) {
            ReconcileTreeNode rtn = (ReconcileTreeNode)value;
            retval.setIcon(rtn.isShuttled() ? rtn.getShuttledIcon() : rtn.getIcon());
            retval.setOpaque(true);
            retval.setBackground(rtn.getBackground());
            retval.setFont(retval.getFont().deriveFont(0));
            if (rtn.isHighLighted()) {
                retval.setFont(retval.getFont().deriveFont(1));
                retval.setBackground(rtn.getHighLightBackground());
            } else if (rtn.isShuttled()) {
                retval.setBackground(rtn.getShuttledBackground());
            } else if (rtn.isChildShuttled()) {
                retval.setBackground(rtn.getShuttledBackground());
            }
            retval.setText(rtn.isShuttled() || rtn.isChildShuttled() ? rtn.getShuttledText() : rtn.getText());
        } else if (value instanceof DefaultMutableTreeNode && (obj = ((DefaultMutableTreeNode)value).getUserObject()) instanceof String && this.m_iconify) {
            retval.setIcon(DBTypeDisplayRegistry.getFolderIcon((String)((String)obj)));
        }
        String tooltipPrefix = "";
        if (value instanceof ReconcileTreeNode) {
            tooltipPrefix = ((ReconcileTreeNode)value).getTooltipPrefix();
        }
        if (!ModelUtil.hasLength((String)tooltipPrefix) && value instanceof TreeNode && (parent = ((TreeNode)value).getParent()) instanceof ReconcileTreeNode) {
            tooltipPrefix = ((ReconcileTreeNode)parent).getTooltipPrefix();
        }
        String tooltip = "<html>" + tooltipPrefix + retval.getText() + "</html>";
        retval.setToolTipText(tooltip);
        return retval;
    }
}

