/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.reconcile;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ideimpl.db.transfer.TransferLog;
import oracle.ideimpl.db.transfer.reconcile.DependancySeeker;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.util.ModelUtil;

public class DependancyManager {
    public static final String DEPENDANCY_DIRECTION_ADD = "add";
    public static final String DEPENDANCY_DIRECTION_REVERT = "revert";
    private DiffContext m_diffContext;
    private ResultSet m_root;
    private String m_dependency_direction;
    private HashMap m_dependancies;
    private HashMap m_seekers;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this.m_dependancies = new HashMap();
        this.m_seekers = new HashMap();
    }

    public DependancyManager(DiffContext dc) {
        this.$init$();
        this.m_diffContext = dc;
        this.m_root = dc.getResult();
    }

    public void registerDependancySeeker(Class c, DependancySeeker ds) {
        this.m_seekers.put(c, ds);
    }

    public void analyseDependencies() {
        if (this.m_root != null) {
            this.walker(null, this.m_root);
        }
    }

    private Set getDependancies(ResultSet resultSet, String type) {
        Set allDependancies = (Set)this.m_dependancies.get(resultSet);
        HashSet<ResultSet> result = new HashSet<ResultSet>();
        for (Dependancy d : allDependancies) {
            if (ModelUtil.hasLength((String)type) && !Dependancy.mav$getDirection(d).equals(type)) continue;
            result.add(Dependancy.mav$getResultSet(d));
        }
        return result;
    }

    public Set getRevertDependancies(ResultSet resultSet) {
        return this.getDependancies(resultSet, DEPENDANCY_DIRECTION_ADD);
    }

    public Set getAddDependancies(ResultSet resultSet) {
        return this.getDependancies(resultSet, DEPENDANCY_DIRECTION_REVERT);
    }

    public Set getDependancies(ResultSet resultSet) {
        return this.getDependancies(resultSet, null);
    }

    public Set getResultSetsWithDependancies() {
        return this.m_dependancies.keySet();
    }

    public void setResultSet(ResultSet rs) {
        this.m_root = rs;
    }

    public ResultSet getResultSet() {
        return this.m_root;
    }

    public DiffContext getDiffContext() {
        return this.m_diffContext;
    }

    public void print() {
        if (this.m_dependancies.size() > 0) {
            TransferLog.log("Dependancies...", new Object[0]);
        } else {
            TransferLog.log("No dependancies.", new Object[0]);
        }
        for (ResultSet r : this.m_dependancies.keySet()) {
            r.printOne();
            TransferLog.log("Related to ...", new Object[0]);
            TransferLog.log("<<<", new Object[0]);
            for (Dependancy dep : (Set)this.m_dependancies.get(r)) {
                ResultSet d = Dependancy.mav$getResultSet(dep);
                String direction = Dependancy.mav$getDirection(dep);
                if (DEPENDANCY_DIRECTION_ADD.equals(direction)) {
                    TransferLog.log("ADD", new Object[0]);
                } else if (DEPENDANCY_DIRECTION_REVERT.equals(direction)) {
                    TransferLog.log("REVERT", new Object[0]);
                }
                d.printOne();
            }
            TransferLog.log(">>>", new Object[0]);
        }
    }

    private void walker(ResultSet parent, ResultSet rs) {
        this.m_diffContext.getEngine().checkProgress();
        if (!rs.isSame()) {
            Iterator<Object> notSameChildIterator = null;
            if ("MAP".equals(rs.getType()) || "LEAF".equals(rs.getType())) {
                Class rsc = rs.getResultSetClass();
                DependancySeeker seeker = (DependancySeeker)DiffEngine.searchMap((Map)this.m_seekers, (Class)rsc);
                if (seeker != null) {
                    this.updateDependancies(rs, seeker.getDependancies(this.m_root, parent, rs));
                }
                if ("MAP".equals(rs.getType())) {
                    notSameChildIterator = rs.getNotSameObjectMap().values().iterator();
                }
            } else if ("LIST".equals(rs.getType())) {
                notSameChildIterator = rs.getNotSameObjectList().iterator();
            }
            if (notSameChildIterator != null) {
                while (notSameChildIterator.hasNext()) {
                    this.walker(rs, (ResultSet)notSameChildIterator.next());
                }
            }
        }
    }

    static {
        $assertionsDisabled = DependancyManager.class.desiredAssertionStatus() ^ true;
    }

    private void updateDependancies(ResultSet r, List dependancies) {
        for (ResultSet d : dependancies) {
            if (!$assertionsDisabled && d == null) {
                throw new AssertionError();
            }
            if (d.a() == null && this.m_diffContext.isSrcOffline() || d.a() != null && !this.m_diffContext.isSrcOffline()) {
                this.addDependancy(d, r, DEPENDANCY_DIRECTION_ADD);
                this.addDependancy(r, d, DEPENDANCY_DIRECTION_REVERT);
                continue;
            }
            this.addDependancy(r, d, DEPENDANCY_DIRECTION_ADD);
            this.addDependancy(d, r, DEPENDANCY_DIRECTION_REVERT);
        }
    }

    private void addDependancy(ResultSet r1, ResultSet r2, String direction) {
        HashSet<Dependancy> lone = (HashSet<Dependancy>)this.m_dependancies.get(r1);
        Dependancy d = new Dependancy(r2, direction);
        if (lone == null) {
            lone = new HashSet<Dependancy>();
            lone.add(d);
            this.m_dependancies.put(r1, lone);
        } else {
            lone.add(d);
        }
    }

    private class Dependancy {
        ResultSet m_resultSet;
        String m_direction;

        Dependancy(ResultSet rs, String direction) {
            this.m_resultSet = rs;
            this.m_direction = direction;
        }

        private ResultSet getResultSet() {
            return this.m_resultSet;
        }

        private String getDirection() {
            return this.m_direction;
        }

        static ResultSet mav$getResultSet(Dependancy dependancy) {
            return dependancy.getResultSet();
        }

        static String mav$getDirection(Dependancy dependancy) {
            return dependancy.getDirection();
        }
    }
}

