/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.reconcile;

import java.awt.Component;
import java.awt.Container;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareModelFactory;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewBias;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.EditableContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.util.ModelUtil;

class ReconcileCompareView {
    private CompareView m_compareView;
    private String m_leftTitle;
    private String m_rightTitle;
    private String m_type;
    private boolean m_rightUpdateable;

    private void $init$() {
        this.m_leftTitle = "";
        this.m_rightTitle = "";
        this.m_type = "";
        this.m_rightUpdateable = false;
    }

    private Component getCompareView(String left, String right) throws CompareFailedException {
        TextBuffer buffer1 = TextBufferFactory.createTextBuffer();
        TextBuffer buffer2 = TextBufferFactory.createTextBuffer();
        if (ModelUtil.hasLength((String)left)) {
            buffer1.append(left.toCharArray());
            buffer2.clearModified();
        }
        if (ModelUtil.hasLength((String)right)) {
            buffer2.append(right.toCharArray());
            buffer2.clearModified();
        }
        buffer1.setReadOnly(true);
        if (!this.m_rightUpdateable) {
            buffer2.setReadOnly(true);
        }
        SimpleTextCompareContributor contributor1 = new SimpleTextCompareContributor(buffer1, this.m_leftTitle, this.m_type, true);
        SimpleTextCompareContributor contributor2 = new SimpleTextCompareContributor(buffer2, this.m_rightTitle, this.m_type, false);
        SequenceCompareModel compareModel = (SequenceCompareModel)CompareModelFactory.createCompareModel((CompareContributor)contributor1, (CompareContributor)contributor2, (CompareType)CompareType.TEXT);
        if (this.m_compareView == null) {
            this.m_compareView = CompareViewFactory.createCompareView((CompareModel)compareModel, (CompareViewBias)CompareViewBias.LEFT);
        } else {
            this.m_compareView.setModel((CompareModel)compareModel);
        }
        return this.m_compareView.getGUI();
    }

    public ReconcileCompareView() {
        this.$init$();
    }

    public void setTitles(String left, String right) {
        this.m_leftTitle = left;
        this.m_rightTitle = right;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public void setRightUpdateable(boolean rightUpdatable) {
        this.m_rightUpdateable = rightUpdatable;
    }

    public boolean isModified() {
        boolean result = false;
        if (this.m_compareView != null) {
            result = ((EditableContributor)this.m_compareView.getModel().getContributor(ContributorKind.SECOND)).isModified();
        }
        return result;
    }

    public String getRight() {
        String result = "";
        if (this.m_compareView != null) {
            TextBuffer tb = ((TextCompareContributor)this.m_compareView.getModel().getContributor(ContributorKind.SECOND)).getTextBuffer();
            result = tb.getString(0, tb.getLength());
        }
        return result;
    }

    public void compare(String a, String b, Container c) {
        try {
            c.add(this.getCompareView(a, b));
        }
        catch (CompareFailedException cfe) {
            cfe.printStackTrace();
        }
    }

    private class SimpleTextCompareContributor
    extends TextCompareContributor
    implements EditableContributor {
        private final TextBuffer m_textBuffer;
        private final String m_label;
        private final String m_type;
        private final boolean m_left;

        SimpleTextCompareContributor(TextBuffer textBuffer, String label, String type, boolean left) {
            this.m_textBuffer = textBuffer;
            this.m_label = label;
            this.m_type = type;
            this.m_left = left;
        }

        public TextBuffer getTextBuffer() {
            return this.m_textBuffer;
        }

        public String getShortLabel() {
            return this.m_label;
        }

        public String getLongLabel() {
            return this.m_label;
        }

        public String getType() {
            return this.m_type;
        }

        public boolean isEditable() {
            return this.m_textBuffer.isReadOnly() ^ true;
        }

        public boolean isModified() {
            return !this.m_left && this.m_textBuffer.isModified();
        }
    }
}

