/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.reconcile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.ide.Ide;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.DialogCallbacks;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Assert;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.TransferLog;
import oracle.ideimpl.db.transfer.TransferProps;
import oracle.ideimpl.db.transfer.TransferUtil;
import oracle.ideimpl.db.transfer.reconcile.DependancyManager;
import oracle.ideimpl.db.transfer.reconcile.ReconcilePicker;
import oracle.ideimpl.db.transfer.reconcile.ReconcileTextPanel;
import oracle.ideimpl.db.transfer.reconcile.ReconcileTreeNode;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.util.ModelUtil;

public class ReconcilePanel
extends DefaultTraversablePanel
implements ActionListener,
ItemListener,
TreeSelectionListener,
TreeExpansionListener,
ShuttleListener {
    public static final String HELP_ID = "f1_offdbgeneratereconcile_html";
    private static final DBUIResourceHelper s_uiResHelper = new DBUIResourceHelper("ReconcilePanel");
    private TransferDescriptor m_td;
    private String m_fromLabel;
    private String m_toLabel;
    private boolean m_fromA;
    private JWrappedLabel m_lblTop;
    private JLabel m_lblFrom;
    private JLabel m_lblTo;
    private Shuttle m_shuttle;
    private ReconcilePicker m_from;
    private ReconcilePicker m_chosen;
    private JCheckBox m_cbxOnlyShowDiffs;
    private JButton m_btnCompareText;
    private JPanel m_pnlControls;
    private WizardCallbacks m_wcallbacks;
    private DialogCallbacks m_dcallbacks;
    private GridBagLayout layCenter;
    private DependancyManager m_diff;
    private ReconcileTreeNode m_lastSelectedNode;
    private static final String ACTION_TEXT_COMPARE = "ActionTextCompare";

    private void $init$() {
        this.m_fromLabel = TransferArb.getString(157);
        this.m_toLabel = TransferArb.getString(30);
        this.m_lblTop = new JWrappedLabel();
        this.m_lblFrom = new JLabel();
        this.m_lblTo = new JLabel();
        this.m_shuttle = new Shuttle();
        this.m_cbxOnlyShowDiffs = new JCheckBox();
        this.m_btnCompareText = new JButton();
        this.m_pnlControls = new JPanel();
        this.layCenter = new GridBagLayout();
    }

    public ReconcilePanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        Component[] shuttleComponents;
        this.setHelpID(HELP_ID);
        this.m_lblTop.setText(TransferArb.getString(230));
        s_uiResHelper.resButton((AbstractButton)this.m_cbxOnlyShowDiffs, TransferArb.getString(23), "m_cbxOnlyShowDiffs");
        s_uiResHelper.resButton((AbstractButton)this.m_btnCompareText, TransferArb.getString(72), "m_btnCompareText");
        this.m_cbxOnlyShowDiffs.addItemListener(this);
        this.m_btnCompareText.setEnabled(false);
        this.m_btnCompareText.setActionCommand(ACTION_TEXT_COMPARE);
        this.m_btnCompareText.addActionListener(this);
        this.m_pnlControls.setLayout(new BorderLayout());
        this.m_pnlControls.add((Component)this.m_cbxOnlyShowDiffs, "West");
        this.m_pnlControls.add((Component)this.m_btnCompareText, "East");
        this.setLayout(this.layCenter);
        this.add((Component)this.m_lblTop, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)this.m_shuttle, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_pnlControls, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 16, 2, new Insets(5, 0, 0, 0), 0, 0));
        Component[] componentArray = shuttleComponents = this.m_shuttle.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component c = componentArray[n];
            if (c instanceof JPanel) {
                Component[] shuttlePanelComponents;
                s_uiResHelper.setName(c, "ShuttlePanel");
                Component[] componentArray2 = shuttlePanelComponents = ((JPanel)c).getComponents();
                int n2 = 0;
                while (n2 < componentArray2.length) {
                    Component pc = componentArray2[n2];
                    if (pc instanceof JButton) {
                        s_uiResHelper.setName(pc, pc.getName());
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public String getHeaderTitle() {
        return TransferArb.getString(187);
    }

    public String getHeaderDescription() {
        return TransferArb.getString(116);
    }

    protected ReconcilePicker getFromPicker() {
        if (this.m_from == null) {
            this.m_from = new ReconcilePicker();
        }
        return this.m_from;
    }

    protected ReconcilePicker getToPicker() {
        if (this.m_chosen == null) {
            this.m_chosen = new ReconcilePicker();
        }
        return this.m_chosen;
    }

    public void setToLabel(String toLabel) {
        this.m_toLabel = toLabel;
    }

    public void setFromLabel(String fromLabel) {
        this.m_fromLabel = fromLabel;
    }

    public void setFromA(boolean fromA) {
        this.m_fromA = fromA;
    }

    public void onEntry(TraversableContext dataContext) {
        String description;
        this.m_td = (TransferDescriptor)((Object)dataContext.get("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY"));
        this.m_from = null;
        this.m_chosen = null;
        s_uiResHelper.resLabel(this.m_lblFrom, (Component)this.getFromPicker().getJTree(), this.m_fromLabel, "m_lblFrom");
        s_uiResHelper.resLabel(this.m_lblTo, (Component)this.getToPicker().getJTree(), this.m_toLabel, "m_lblTo");
        this.m_diff = (DependancyManager)dataContext.find("RECONCILE_KEY");
        if (dataContext.contains("RECONCILE_DESC") && (description = (String)dataContext.find("RECONCILE_DESC")) != null) {
            this.m_lblTop.setText(description);
        }
        this.init(this.m_diff);
        this.m_wcallbacks = dataContext.getWizardCallbacks();
        if (this.m_wcallbacks == null) {
            this.m_dcallbacks = dataContext.getDialogCallbacks();
            if (this.m_dcallbacks != null) {
                this.m_dcallbacks.enableOKButton(false);
            }
        } else {
            this.m_dcallbacks = null;
            this.m_wcallbacks.wizardEnableButtons(Boolean.TRUE, Boolean.FALSE, Boolean.FALSE);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commit(this.m_diff, dataContext.getDirection() != 2);
    }

    private void init(DependancyManager diff) {
        this.m_shuttle.setButtonLabels(new String[]{"", TransferArb.getString(161), "", TransferArb.getString(58), TransferArb.getString(134), TransferArb.getString(208)});
        ReconcilePicker fromPicker = this.getFromPicker();
        fromPicker.setFromA(this.m_fromA);
        fromPicker.buildTree(true, diff);
        ReconcilePicker toPicker = this.getToPicker();
        toPicker.setFromA(this.m_fromA);
        toPicker.buildTree(false, diff);
        this.buildDependancies(this.getFromPicker(), this.getToPicker(), diff);
        JTree tree = this.getFromPicker().getJTree();
        this.m_shuttle.setFromPicker((ItemPicker)this.getFromPicker());
        this.m_shuttle.setToPicker((ItemPicker)this.getToPicker());
        this.m_shuttle.setMode(1);
        this.m_shuttle.add((Component)this.m_lblFrom, (Object)"FromHeader");
        this.m_shuttle.add((Component)this.m_lblTo, (Object)"ToHeader");
        this.m_shuttle.addShuttleListener((ShuttleListener)this);
        this.getFromPicker().addTreeExpansionListener(this);
        this.getFromPicker().addTreeSelectionListener(this);
        this.getToPicker().addTreeExpansionListener(this);
        this.getToPicker().addTreeSelectionListener(this);
        this.expand(diff.getDiffContext().getResult());
        if (this.m_cbxOnlyShowDiffs.isSelected()) {
            this.removeSameNodes(diff.getResultSet());
            this.expandTwoLevels();
        }
    }

    private void expand(ResultSet rs) {
        block4: {
            block3: {
                if (TransferProps.isExpanded(rs)) {
                    ReconcileTreeNode treeNode = this.getFromPicker().getReconcileTreeNode(rs);
                    TreePath path = new TreePath(treeNode.getPath());
                    this.getFromPicker().getJTree().expandPath(path);
                }
                if (!"LIST".equals(rs.getType())) break block3;
                for (ResultSet rk : rs.getNotSameObjectList()) {
                    this.expand(rk);
                }
                break block4;
            }
            if (!"MAP".equals(rs.getType())) break block4;
            for (ResultSet rp : rs.getNotSameObjectMap().values()) {
                this.expand(rp);
            }
        }
    }

    private void ShowTextCompare() {
        if (this.m_lastSelectedNode != null) {
            ResultSet rs = this.m_lastSelectedNode.getResultSet();
            Namespace ns = new Namespace();
            ns.put("OriginalObject", (Object)this.m_lastSelectedNode);
            ns.put("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY", (Object)this.m_td);
            TreeNode[] path = this.m_lastSelectedNode.getPath();
            StringBuffer fullname = new StringBuffer();
            int i = 0;
            while (i < path.length - 1) {
                if (path[i] instanceof ReconcileTreeNode) {
                    if (fullname.length() != 0) {
                        fullname.append(".");
                    }
                    fullname.append(((ReconcileTreeNode)path[i]).getResultSet().getName());
                }
                ++i;
            }
            String attrName = rs.getName();
            String shuttled = "";
            if (this.m_lastSelectedNode.isShuttled()) {
                shuttled = " (change accepted)";
            }
            String panelTitle = fullname.toString() + " " + attrName + shuttled;
            ReconcileTextPanel panel = new ReconcileTextPanel();
            TDialogLauncher tdl = new TDialogLauncher((Component)Ide.getMainWindow(), panelTitle, (Traversable)panel, ns);
            tdl.setInitialSize(700, 500);
            JEWTDialog dialog = tdl.initDialog();
            dialog.setButtonMask(16);
            s_uiResHelper.setName((Component)dialog, "ReconcileTextPanel");
            boolean ok = tdl.showDialog();
        }
    }

    private void buildDependancies(ReconcilePicker fromPicker, ReconcilePicker toPicker, DependancyManager diff) {
        ResultSet rs = diff.getResultSet();
        this.buildDependancies(fromPicker, toPicker, rs);
        for (ResultSet r : diff.getResultSetsWithDependancies()) {
            ReconcileTreeNode fromNode = fromPicker.getReconcileTreeNode(r);
            ReconcileTreeNode toNode = toPicker.getReconcileTreeNode(r);
            if (fromNode == null || toNode == null) continue;
            Set revert = diff.getRevertDependancies(r);
            Set add = diff.getAddDependancies(r);
            for (ResultSet rd : add) {
                ReconcileTreeNode dFromNode = fromPicker.getReconcileTreeNode(rd);
                Assert.check((dFromNode != null ? 1 : 0) != 0);
                fromNode.addDependantChange(dFromNode);
            }
            for (ResultSet rd : revert) {
                ReconcileTreeNode dToNode = toPicker.getReconcileTreeNode(rd);
                Assert.check((dToNode != null ? 1 : 0) != 0);
                toNode.addDependantChange(dToNode);
            }
        }
    }

    private void buildDependancies(ReconcilePicker fromPicker, ReconcilePicker toPicker, ResultSet rs) {
        block4: {
            block3: {
                ReconcileTreeNode fromNode = fromPicker.getReconcileTreeNode(rs);
                ReconcileTreeNode toNode = toPicker.getReconcileTreeNode(rs);
                if (fromNode != null && toNode != null) {
                    fromNode.setPartner(toNode);
                    toNode.setPartner(fromNode);
                }
                if (!"LIST".equals(rs.getType())) break block3;
                for (ResultSet r : rs.getAllObjectsList()) {
                    this.buildDependancies(fromPicker, toPicker, r);
                }
                break block4;
            }
            if (!"MAP".equals(rs.getType())) break block4;
            for (ResultSet r : rs.getAllObjectsMap().values()) {
                this.buildDependancies(fromPicker, toPicker, r);
            }
        }
    }

    private void commit(DependancyManager dm, boolean forward) throws TraversalException {
        if (forward) {
            this.updateChildren(dm.getResultSet());
        }
    }

    private boolean updateChildren(ResultSet rs) {
        boolean same;
        block5: {
            block6: {
                same = rs.isSame();
                ReconcileTreeNode treeNode = this.getToPicker().getReconcileTreeNode(rs);
                if (treeNode != null) {
                    TreePath path = new TreePath(treeNode.getPath());
                    boolean expanded = this.getToPicker().getJTree().isExpanded(path);
                    TransferProps.setExpanded(rs, expanded);
                }
                if (same) break block5;
                if (treeNode != null) {
                    boolean shuttled = treeNode.isShuttled();
                    same = shuttled ^ true;
                    TransferProps.setShuttled(rs, shuttled);
                } else {
                    same = true;
                }
                if (!"LIST".equals(rs.getType())) break block6;
                for (ResultSet rk : rs.getNotSameObjectList()) {
                    same &= this.updateChildren(rk);
                }
                break block5;
            }
            if (!"MAP".equals(rs.getType())) break block5;
            for (ResultSet rp : rs.getNotSameObjectMap().values()) {
                same &= this.updateChildren(rp);
            }
        }
        return same;
    }

    private void removeNode(ReconcilePicker picker, ResultSet rs) {
        MutableTreeNode parent;
        DefaultTreeModel treeModel = picker.getTreeModel();
        ReconcileTreeNode rtn = picker.getReconcileTreeNode(rs);
        if (rtn != null && (parent = (MutableTreeNode)rtn.getParent()) != null) {
            treeModel.removeNodeFromParent(rtn);
        }
    }

    private boolean isSame(ReconcileTreeNode rtn) {
        boolean same = false;
        if (rtn != null) {
            same = !rtn.isAdd() && !rtn.isDrop() && !rtn.isChange();
        }
        return same;
    }

    private void removeSameNodes(ResultSet rs) {
        ReconcilePicker fromPicker = this.getFromPicker();
        ReconcilePicker toPicker = this.getToPicker();
        ReconcileTreeNode rtn = fromPicker.getReconcileTreeNode(rs);
        if (this.isSame(rtn)) {
            this.removeNode(fromPicker, rs);
            this.removeNode(toPicker, rs);
        } else {
            Iterator i = rs.getChildIterator();
            if (i != null) {
                while (i.hasNext()) {
                    ResultSet child = (ResultSet)i.next();
                    this.removeSameNodes(child);
                }
            }
        }
    }

    private void addIfSame(ReconcilePicker picker, ResultSet rs, DefaultMutableTreeNode parent, int index) {
        DefaultTreeModel treeModel = picker.getTreeModel();
        ReconcileTreeNode rtn = picker.getReconcileTreeNode(rs);
        if (this.isSame(rtn) && parent != null) {
            int lastIndex = 0;
            if (parent.getChildCount() != 0) {
                lastIndex = parent.getIndex(parent.getLastChild()) + 1;
            }
            if (index > lastIndex) {
                index = lastIndex;
                TransferLog.getLogger().log(Level.SEVERE, "Reconcile display tree error Index = " + index + ", but lastIndex = ", lastIndex);
            }
            treeModel.insertNodeInto(rtn, parent, index);
        }
    }

    private int addSameNodes(ReconcilePicker picker, ResultSet rs, DefaultMutableTreeNode parentNode, int index) {
        DefaultMutableTreeNode newNode = null;
        Assert.check((rs != null ? 1 : 0) != 0, (String)"Unexpected null ResultSet");
        if ("LIST".equals(rs.getType())) {
            String listName = rs.getName();
            if (ModelUtil.hasLength((String)listName)) {
                newNode = picker.getReconcileTreeNode(rs);
                if (parentNode != null) {
                    this.addIfSame(picker, rs, parentNode, index);
                }
            } else {
                newNode = parentNode;
            }
            List children = rs.getAllObjectsList();
            index = 0;
            for (ResultSet rchild : children) {
                if (!DisplayProps.isDisplay((ResultSet)rchild)) continue;
                ReconcileTreeNode childNode = picker.getReconcileTreeNode(rchild);
                this.addSameNodes(picker, rchild, newNode, index);
                ++index;
            }
        } else if ("MAP".equals(rs.getType())) {
            boolean flatMap = false;
            Object parentUserObject = parentNode.getUserObject();
            if (!DisplayProps.isDisplayMapAsFolder((ResultSet)rs) && parentUserObject instanceof ResultSet && "MAP".equals(((ResultSet)parentUserObject).getType())) {
                newNode = parentNode;
            } else {
                newNode = picker.getReconcileTreeNode(rs);
                if (parentNode != null) {
                    this.addIfSame(picker, rs, parentNode, index);
                }
                index = 0;
            }
            Map attrs = rs.getAllObjectsMap();
            List<Object> keys = new ArrayList(attrs.keySet());
            if (newNode instanceof ReconcileTreeNode) {
                keys = ReconcileTreeNode.orderChildren(rs, keys);
            }
            for (String name : keys) {
                ResultSet rattr = (ResultSet)attrs.get(name);
                if (!DisplayProps.isDisplay((ResultSet)rattr)) continue;
                int childIndex = this.addSameNodes(picker, rattr, newNode, index);
                if (!DisplayProps.isDisplayMapAsFolder((ResultSet)rs) && "MAP".equals(rattr.getType())) {
                    index = childIndex;
                    continue;
                }
                ++index;
            }
        } else {
            Assert.check((parentNode != null ? 1 : 0) != 0);
            this.addIfSame(picker, rs, parentNode, index);
        }
        return index;
    }

    public void actionPerformed(ActionEvent ae) {
        if (ACTION_TEXT_COMPARE.equals(ae.getActionCommand())) {
            this.ShowTextCompare();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.m_cbxOnlyShowDiffs) {
            if (e.getStateChange() == 1) {
                this.removeSameNodes(this.m_diff.getResultSet());
                this.expandTwoLevels();
            } else {
                DefaultMutableTreeNode fromRoot = (DefaultMutableTreeNode)this.getFromPicker().getTreeModel().getRoot();
                this.addSameNodes(this.getFromPicker(), this.m_diff.getResultSet(), fromRoot, 0);
                DefaultMutableTreeNode toRoot = (DefaultMutableTreeNode)this.getToPicker().getTreeModel().getRoot();
                this.addSameNodes(this.getToPicker(), this.m_diff.getResultSet(), toRoot, 0);
                TreePath path = new TreePath(fromRoot.getPath());
                this.getFromPicker().getJTree().expandPath(path);
                path = new TreePath(toRoot.getPath());
                this.getToPicker().getJTree().expandPath(path);
            }
        }
    }

    private void expandTwoLevels() {
        ReconcilePicker fromPicker = this.getFromPicker();
        ReconcileTreeNode[] rtns = fromPicker.getTopTreeNodes();
        if (rtns.length == 1) {
            for (Object child : rtns[0].getAllChildren()) {
                if (!(child instanceof ReconcileTreeNode)) continue;
                TreePath path = new TreePath(((ReconcileTreeNode)child).getPath());
                this.getFromPicker().getJTree().expandPath(path);
            }
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath[] changedPaths = e.getPaths();
        int i = 0;
        while (i < changedPaths.length) {
            ReconcileTreeNode node = (ReconcileTreeNode)changedPaths[i].getLastPathComponent();
            JTree jTree = node.isFrom() ? this.getFromPicker().getJTree() : this.getToPicker().getJTree();
            TreeSelectionModel tsm = jTree.getSelectionModel();
            TreePath[] selectionPaths = jTree.getSelectionPaths();
            ResultSet rs = (node = TransferUtil.ccIfPartOfColumnConstraint(node)).getResultSet();
            if (rs.getName() != null) {
                boolean isAddedPath = e.isAddedPath(i);
                boolean keepHighLighted = false;
                if (!isAddedPath && selectionPaths != null) {
                    int j = 0;
                    while (j < selectionPaths.length) {
                        TreePath selectionPath = selectionPaths[j];
                        ReconcileTreeNode selectedNode = (ReconcileTreeNode)selectionPath.getLastPathComponent();
                        keepHighLighted |= selectedNode.getDependantChanges().contains(node);
                        ++j;
                    }
                }
                if (!this.isLeafDependantOnParent(rs) && !keepHighLighted) {
                    this.setHighLighted(node, isAddedPath);
                }
            }
            ++i;
        }
        this.m_lastSelectedNode = null;
        if (e.isAddedPath()) {
            TreePath tp = e.getPath();
            ReconcileTreeNode n = (ReconcileTreeNode)tp.getLastPathComponent();
            ResultSet rs = n.getResultSet();
            if (DisplayProps.getAVal((ResultSet)rs) != null || DisplayProps.getBVal((ResultSet)rs) != null || rs.a() instanceof String || rs.b() instanceof String) {
                this.m_btnCompareText.setEnabled(true);
                this.m_lastSelectedNode = n;
            } else {
                this.m_btnCompareText.setEnabled(false);
                this.m_lastSelectedNode = n;
            }
        }
        if (this.m_lastSelectedNode == null) {
            this.m_btnCompareText.setEnabled(false);
        }
    }

    public void treeCollapsed(TreeExpansionEvent e) {
        TreePath path = e.getPath();
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (dmtn instanceof ReconcileTreeNode) {
            ReconcileTreeNode rtn = (ReconcileTreeNode)dmtn;
            ReconcileTreeNode otherRtn = rtn.getPartner();
            TreePath otherPath = new TreePath(otherRtn.getPath());
            JTree otherTree = otherRtn.isFrom() ? this.getFromPicker().getJTree() : this.getToPicker().getJTree();
            otherTree.collapsePath(otherPath);
            JTree tree = rtn.isFrom() ? this.getFromPicker().getJTree() : this.getToPicker().getJTree();
            tree.getSelectionModel().resetRowSelection();
            otherTree.getSelectionModel().resetRowSelection();
        } else {
            Assert.println((String)"Cant collapse");
        }
    }

    public void treeExpanded(TreeExpansionEvent e) {
        TreePath path = e.getPath();
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (dmtn instanceof ReconcileTreeNode) {
            ReconcileTreeNode rtn = (ReconcileTreeNode)dmtn;
            ReconcileTreeNode otherRtn = rtn.getPartner();
            if (otherRtn == null) {
                Assert.println((String)"No partner");
            }
            TreePath otherPath = new TreePath(otherRtn.getPath());
            JTree otherTree = otherRtn.isFrom() ? this.getFromPicker().getJTree() : this.getToPicker().getJTree();
            otherTree.expandPath(otherPath);
            JTree tree = rtn.isFrom() ? this.getFromPicker().getJTree() : this.getToPicker().getJTree();
            tree.getSelectionModel().resetRowSelection();
            otherTree.getSelectionModel().resetRowSelection();
        } else {
            Assert.println((String)"Cant expand");
        }
    }

    public void shuttleItemsReordered(ShuttleEvent e) {
    }

    public void shuttleItemsMoved(ShuttleEvent e) {
        this.setShuttled(e.getItems(), true);
        this.setOKButton();
    }

    public void shuttleItemsRemoved(ShuttleEvent e) {
        this.setShuttled(e.getItems(), false);
        this.setOKButton();
    }

    private void setOKButton() {
        ReconcileTreeNode[] topNodes = this.getToPicker().getTopTreeNodes();
        boolean shuttled = false;
        if (topNodes != null) {
            int i = 0;
            while (i < topNodes.length) {
                shuttled = topNodes[i].isChildShuttled();
                if (shuttled) break;
                ++i;
            }
        }
        if (this.m_wcallbacks != null) {
            this.m_wcallbacks.wizardEnableButtons(Boolean.TRUE, Boolean.valueOf(shuttled), Boolean.valueOf(shuttled));
        }
        if (this.m_dcallbacks != null) {
            this.m_dcallbacks.enableOKButton(shuttled);
        }
    }

    private boolean isLeafDependantOnParent(ResultSet rs) {
        return "LEAF".equals(rs.getType()) && (rs.inAbutNotB() || rs.inBbutNotA());
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setShuttled(Transferable[] items, boolean shuttled) {
        block16: {
            block18: {
                block15: {
                    topNodes = new ArrayList<ReconcileTreeNode>();
                    toPicker = this.getToPicker();
                    if (toPicker != null) {
                        var23_5 = this.getToPicker().getTopTreeNodes();
                        var24_6 = 0;
                        while (var24_6 < var23_5.length) {
                            n = var23_5[var24_6];
                            topNodes.add(n);
                            ++var24_6;
                        }
                    }
                    nodesJustShuttled = new HashSet<ReconcileTreeNode>();
                    try {
                        nodesToTransfer = new HashMap<ReconcileTreeNode, ResultSet>();
                        i = 0;
                        while (true) {
                            block17: {
                                if (i < items.length) break block17;
                                if (!nodesToTransfer.keySet().containsAll(topNodes)) break block15;
                                nodeToRemove = new ArrayList<ReconcileTreeNode>();
                                var25_15 = nodesToTransfer.keySet().iterator();
                                if (true) ** GOTO lbl42
                            }
                            item = items[i];
                            rs = (ResultSet)item.getTransferData(ReconcilePicker.TRANSFERABLE_FLAVOR);
                            if (!this.isLeafDependantOnParent(rs)) {
                                onlineNode = this.getToPicker().getReconcileTreeNode(rs);
                                nodesToTransfer.put(onlineNode, rs);
                            }
                            ++i;
                        }
                    }
                    catch (UnsupportedFlavorException e) {
                        Assert.printStackTrace((Throwable)e);
                    }
                    catch (IOException e) {
                        Assert.printStackTrace((Throwable)e);
                    }
                    do {
                        if (topNodes.contains(n = (ReconcileTreeNode)var25_15.next())) continue;
                        nodeToRemove.add(n);
lbl42:
                        // 3 sources

                    } while (var25_15.hasNext());
                    for (ReconcileTreeNode n : nodeToRemove) {
                        nodesToTransfer.remove(n);
                    }
                }
                debugCount = 0;
                for (ResultSet rs : nodesToTransfer.values()) {
                    ++debugCount;
                    onlineNode = this.getToPicker().getReconcileTreeNode(rs);
                    if (onlineNode == null) continue;
                    this.setShuttled(onlineNode, shuttled);
                    nodesJustShuttled.add(onlineNode);
                    this.setHighLighted(onlineNode, false);
                    this.getToPicker().getJTree().repaint();
                    offlineNode = this.getFromPicker().getReconcileTreeNode(rs);
                    this.setHighLighted(offlineNode, false);
                    this.getFromPicker().getJTree().repaint();
                }
                if (topNodes == null) break block18;
                var28_24 = topNodes.iterator();
                if (true) ** GOTO lbl75
            }
            finally {
                if (topNodes == null) break block16;
                var31_32 = topNodes.iterator();
                if (true) ** GOTO lbl80
            }
            do {
                n = (ReconcileTreeNode)var28_24.next();
                n.updateChildShuttled();
lbl75:
                // 2 sources

            } while (var28_24.hasNext());
            do {
                n = (ReconcileTreeNode)var31_32.next();
                n.clearJustShuttled();
lbl80:
                // 2 sources

            } while (var31_32.hasNext());
        }
    }

    private void setShuttled(ReconcileTreeNode treeNode, boolean shuttled) {
        treeNode.setShuttled(this.getFromPicker().getTreeModel(), this.getToPicker().getTreeModel(), shuttled);
        if (!shuttled) {
            ResultSet resultSet = treeNode.getResultSet();
        }
    }

    private void setHighLighted(ReconcileTreeNode treeNode, boolean highLight) {
        treeNode.setDependantsHighLighted(this.getFromPicker().getTreeModel(), this.getToPicker().getTreeModel(), highLight);
    }
}

