/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.reconcile;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.db.controls.AbstractTreePicker;
import oracle.ide.util.Assert;
import oracle.ideimpl.db.transfer.TransferUtil;
import oracle.ideimpl.db.transfer.reconcile.CompareTreeCellRenderer;
import oracle.ideimpl.db.transfer.reconcile.DependancyManager;
import oracle.ideimpl.db.transfer.reconcile.ReconcileFKColTreeNode;
import oracle.ideimpl.db.transfer.reconcile.ReconcileFKTreeNode;
import oracle.ideimpl.db.transfer.reconcile.ReconcileTreeModel;
import oracle.ideimpl.db.transfer.reconcile.ReconcileTreeNode;
import oracle.javatools.db.Column;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.View;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Differ;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.FKConstraintDiffer;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReconcilePicker
extends AbstractTreePicker {
    private CompareTreeCellRenderer m_renderer;
    private DefaultMutableTreeNode m_top;
    private ReconcileTreeModel m_treeModel;
    private JTree m_rptree;
    private Transferable[] m_all;
    private boolean m_fromA;
    private Map m_nodes;
    private static HashSet s_ignor = new HashSet<String>(Arrays.asList("OfflineDBConstants.IMPORT_SOURCE_ID", "OfflineDBConstants.IMPORT_SOURCE_CONNECTION", "OfflineDBConstants.GENERATE_TARGET_ID", "OfflineDBConstants.GENERATE_TARGET_CONECTION", "Timestamp", "lastNumber", "source", "oracle.jdevimpl.offlinedb.userprops.UserPropertyDefn"));
    static DataFlavor TRANSFERABLE_FLAVOR = new DataFlavor(ResultSetTransferable.class, "ResultSet");

    private void $init$() {
        this.m_renderer = new CompareTreeCellRenderer();
        this.m_nodes = new HashMap();
    }

    public ReconcilePicker() {
        this.$init$();
        this.m_top = new DefaultMutableTreeNode("XXXXXX");
        this.m_treeModel = new ReconcileTreeModel(this.m_top);
        this.m_rptree = new JTree(this.m_treeModel);
        this.setTree(this.m_rptree);
        this.m_rptree.setRootVisible(false);
        this.m_rptree.setCellRenderer(this.m_renderer);
        this.m_rptree.setShowsRootHandles(true);
        this.m_rptree.setScrollsOnExpand(true);
        this.m_rptree.getSelectionModel().setSelectionMode(4);
        ToolTipManager.sharedInstance().registerComponent(this.m_rptree);
    }

    public DefaultTreeModel getTreeModel() {
        return this.m_treeModel;
    }

    public JTree getJTree() {
        return this.m_rptree;
    }

    public ReconcileTreeNode[] getTopTreeNodes() {
        ReconcileTreeNode[] result = null;
        if (this.m_top != null) {
            result = new ReconcileTreeNode[this.m_top.getChildCount()];
            int i = 0;
            while (i < result.length) {
                result[i] = (ReconcileTreeNode)this.m_top.getChildAt(i);
                ++i;
            }
        }
        return result;
    }

    protected void buildTree(boolean from, DependancyManager diff) {
        ResultSet rs = diff.getResultSet();
        this.buildTree(from, diff, rs, this.m_top);
        this.m_treeModel.reload();
    }

    private void mapNode(ResultSet rs, DefaultMutableTreeNode cm) {
        this.m_nodes.put(rs, cm);
    }

    private List<ResultSet> getAllObjectsOrdered(ResultSet rs) {
        ArrayList children = rs.getAllObjectsList();
        if ("constraints".equals(rs.getName())) {
            TreeMap<String, ResultSet> names = new TreeMap<String, ResultSet>();
            for (ResultSet child : children) {
                names.put(child.getName(), child);
            }
            children = new ArrayList(names.values());
        }
        return children;
    }

    private DefaultMutableTreeNode buildTree(boolean from, DependancyManager diff, ResultSet rs, DefaultMutableTreeNode parentNode) {
        List<String> ignor = null;
        DefaultMutableTreeNode newNode = null;
        Assert.check((rs != null ? 1 : 0) != 0, (String)"Unexpected null ResultSet");
        if ("LIST".equals(rs.getType())) {
            String listName = rs.getName();
            if (ModelUtil.hasLength((String)listName)) {
                newNode = new ReconcileTreeNode(this.m_fromA, from, rs, this.isDisplayedChildChanged(rs));
                this.mapNode(rs, newNode);
                if (parentNode != null) {
                    parentNode.add(newNode);
                }
            } else {
                newNode = parentNode;
            }
            List<ResultSet> children = this.getAllObjectsOrdered(rs);
            for (ResultSet rchild : children) {
                if (!this.isDisplay(rchild, ignor)) continue;
                DefaultMutableTreeNode childNode = this.buildTree(from, diff, rchild, newNode);
                newNode.add(childNode);
            }
        } else if ("MAP".equals(rs.getType()) && rs.getAllObjectsMap().size() != 0 && !"SQLQuery".equals(rs.getName()) && !"columnExpressions".equals(rs.getName())) {
            Object parentUserObject = parentNode.getUserObject();
            if (!DisplayProps.isDisplayMapAsFolder((ResultSet)rs) && parentUserObject instanceof ResultSet && "MAP".equals(((ResultSet)parentUserObject).getType())) {
                newNode = parentNode;
            } else {
                newNode = new ReconcileTreeNode(this.m_fromA, from, rs, this.isDisplayedChildChanged(rs));
                this.mapNode(rs, newNode);
                if (parentNode != null) {
                    parentNode.add(newNode);
                }
            }
            if (!this.isViewColumn(rs)) {
                if (Trigger.class.equals((Object)rs.getResultSetClass())) {
                    ignor = this.getIgnoredTriggerProps(rs);
                }
                Map attrs = rs.getAllObjectsMap();
                List<Object> keys = new ArrayList(attrs.keySet());
                if (newNode instanceof ReconcileTreeNode) {
                    keys = ReconcileTreeNode.orderChildren(rs, keys);
                }
                for (String name : keys) {
                    ResultSet rattr = (ResultSet)attrs.get(name);
                    if (!this.isDisplay(rattr, ignor)) continue;
                    this.buildTree(from, diff, rattr, newNode);
                }
            }
        } else {
            Assert.check((parentNode != null ? 1 : 0) != 0);
            if ("OracleStorageProperties".equals(rs.getName())) {
                newNode = null;
            } else if (parentNode instanceof ReconcileTreeNode && ((ReconcileTreeNode)parentNode).getDBObject() instanceof FKConstraint && "referenceID".equals(rs.getName())) {
                DiffContext dc = diff.getDiffContext();
                DiffEngine de = dc.getEngine();
                ResultSet fkrs = this.getFKResultset(de, (ResultSet)parentNode.getUserObject());
                Map fkmap = fkrs.getAllObjectsMap();
                ResultSet rschemars = (ResultSet)fkmap.get("ReferencedSchema");
                ResultSet rrelrs = (ResultSet)fkmap.get("ReferencedRelation");
                ResultSet rconrs = (ResultSet)fkmap.get("ReferencedConstraintName");
                ResultSet fkRefColNames = (ResultSet)fkmap.get("ReferencedColumn");
                if (rschemars != null) {
                    newNode = new ReconcileFKTreeNode(this.m_fromA, from, rschemars, this.isDisplayedChildChanged(rs));
                    this.mapNode(rs, newNode);
                    parentNode.add(newNode);
                }
                if (rrelrs != null) {
                    newNode = new ReconcileFKTreeNode(this.m_fromA, from, rrelrs, this.isDisplayedChildChanged(rs));
                    this.mapNode(rs, newNode);
                    parentNode.add(newNode);
                }
                if (rconrs != null) {
                    newNode = new ReconcileFKTreeNode(this.m_fromA, from, rconrs, this.isDisplayedChildChanged(rs));
                    this.mapNode(rs, newNode);
                    parentNode.add(newNode);
                }
                if (fkRefColNames != null) {
                    newNode = new ReconcileFKTreeNode(this.m_fromA, from, fkRefColNames, this.isDisplayedChildChanged(rs));
                    this.mapNode(rs, newNode);
                    parentNode.add(newNode);
                    for (ResultSet refColName : fkRefColNames.getAllObjectsList()) {
                        ReconcileFKColTreeNode colNode = new ReconcileFKColTreeNode(this.m_fromA, from, refColName, this.isDisplayedChildChanged(rs));
                        this.mapNode(refColName, colNode);
                        newNode.add(colNode);
                    }
                }
            } else {
                if ("SQLQuery".equals(rs.getName())) {
                    this.setSQLQueryValues(rs);
                }
                newNode = new ReconcileTreeNode(this.m_fromA, from, rs, this.isDisplayedChildChanged(rs));
                this.mapNode(rs, newNode);
                parentNode.add(newNode);
            }
        }
        return newNode;
    }

    private void setSQLQueryValues(ResultSet rs) {
        if (DisplayProps.getAVal((ResultSet)rs) == null || DisplayProps.getBVal((ResultSet)rs) == null) {
            if (rs.a() instanceof SQLQuery) {
                DisplayProps.setAVal((ResultSet)rs, (String)((SQLQuery)rs.a()).getSQLText());
            }
            if (rs.b() instanceof SQLQuery) {
                DisplayProps.setBVal((ResultSet)rs, (String)((SQLQuery)rs.b()).getSQLText());
            }
        }
    }

    private void setExpressionValues(ResultSet rs) {
        if (DisplayProps.getAVal((ResultSet)rs) == null || DisplayProps.getBVal((ResultSet)rs) == null) {
            if (rs.a() instanceof ColumnUsage) {
                DisplayProps.setAVal((ResultSet)rs, (String)((ColumnUsage)rs.a()).getSQLText());
            }
            if (rs.b() instanceof ColumnUsage) {
                DisplayProps.setBVal((ResultSet)rs, (String)((ColumnUsage)rs.b()).getSQLText());
            }
        }
    }

    private List<String> getIgnoredTriggerProps(ResultSet rs) {
        ResultSet columnIDsRS;
        ResultSet refNamesRS;
        ResultSet whenRS;
        ArrayList<String> result = new ArrayList<String>();
        Map trgProps = rs.getAllObjectsMap();
        ResultSet baseTypeRS = (ResultSet)trgProps.get("baseType");
        if (baseTypeRS != null && baseTypeRS.isSame()) {
            Trigger.BaseType trgType = baseTypeRS.a() instanceof Trigger ? ((Trigger)baseTypeRS.a()).getBaseType() : (Trigger.BaseType)baseTypeRS.a();
            if (trgType == Trigger.BaseType.DATABASE) {
                result.add("tableOwner");
                result.add("tableID");
            } else if (trgType == Trigger.BaseType.SCHEMA) {
                result.add("tableID");
            }
        }
        if ((whenRS = (ResultSet)trgProps.get("whenClause")) != null && whenRS.isSame()) {
            result.add("whenClause");
        }
        if ((refNamesRS = (ResultSet)trgProps.get("referenceNames")) != null && refNamesRS.isSame()) {
            result.add("referenceNames");
        }
        if ((columnIDsRS = (ResultSet)trgProps.get("columnIDs")) != null && columnIDsRS.isSame()) {
            result.add("columnIDs");
        }
        return result;
    }

    private ResultSet getFKResultset(DiffEngine existingde, ResultSet rs) {
        ResultSet result = new ResultSet(null, rs.a(), rs.b(), rs.getName(), "MAP");
        DiffEngine de = new DiffEngine(existingde);
        de.registerDiffer((Differ)new FKConstraintDiffer(), FKConstraint.class);
        DiffContext dc = new DiffContext(de, result);
        de.diff(rs.a(), rs.b(), result, dc);
        return result;
    }

    public ReconcileTreeNode getReconcileTreeNode(ResultSet rs) {
        return (ReconcileTreeNode)this.m_nodes.get(rs);
    }

    public Transferable[] getAllSelectableItems() {
        if (this.m_all == null) {
            ArrayList ts = new ArrayList();
            Enumeration<TreeNode> kids = this.m_top.children();
            while (kids.hasMoreElements()) {
                ReconcileTreeNode rtn = (ReconcileTreeNode)kids.nextElement();
                this.addAllSelectableItems(ts, rtn);
            }
            this.m_all = ts.toArray(new Transferable[ts.size()]);
        }
        return this.m_all;
    }

    private void addAllSelectableItems(List ts, ReconcileTreeNode rtn) {
        ResultSet rs = rtn.getResultSet();
        if (!rs.isSame()) {
            ts.add(new ResultSetTransferable(rs));
            Iterator i = rtn.getAllChildren().iterator();
            while (i.hasNext()) {
                this.addAllSelectableItems(ts, (ReconcileTreeNode)i.next());
            }
        }
    }

    public boolean addSelectedItems(Transferable[] trans) {
        return true;
    }

    public void removeSelectedItems() {
    }

    public void removeAllSelectableItems() {
    }

    public Transferable createTransferable(TreePath path) {
        ReconcileTreeNode rtn = (ReconcileTreeNode)path.getLastPathComponent();
        rtn = TransferUtil.ccIfPartOfColumnConstraint(rtn);
        ResultSetTransferable t = new ResultSetTransferable(rtn.getResultSet());
        this.m_nodes.put(t, rtn);
        return t;
    }

    public void addTreeSelectionListener(TreeSelectionListener tsl) {
        this.m_rptree.addTreeSelectionListener(tsl);
    }

    public void addTreeExpansionListener(TreeExpansionListener tel) {
        this.m_rptree.addTreeExpansionListener(tel);
    }

    public void addTreeCellEditor(TreeCellEditor tce) {
        this.m_rptree.setCellEditor(tce);
    }

    public void addMouseListener(MouseListener ml) {
        this.m_rptree.addMouseListener(ml);
    }

    private boolean isSelectableChildPresent(ReconcileTreeNode node) {
        boolean result;
        boolean bl = result = !node.getResultSet().isSame() && !node.isShuttled();
        if (!result && node.getChildCount() > 0) {
            int i = node.getChildCount() - 1;
            while (i >= 0) {
                result = this.isSelectableChildPresent((ReconcileTreeNode)node.getChildAt(i));
                if (result) break;
                --i;
            }
        }
        return result;
    }

    public boolean isSelectableItemPresent() {
        boolean result = super.isSelectableItemPresent();
        int i = 0;
        while (i < this.m_top.getChildCount()) {
            TreeNode tn = this.m_top.getChildAt(i);
            Assert.check((boolean)(tn instanceof ReconcileTreeNode));
            ReconcileTreeNode node = (ReconcileTreeNode)tn;
            result = node.isFrom() ? this.isSelectableChildPresent(node) : node.isChildShuttled();
            if (result) break;
            ++i;
        }
        return result;
    }

    public boolean isItemSelected() {
        boolean result = super.isItemSelected();
        if (result) {
            result = false;
            TreePath[] path = this.m_rptree.getSelectionPaths();
            int i = 0;
            while (path != null && i < path.length) {
                ReconcileTreeNode rtn = (ReconcileTreeNode)path[i].getLastPathComponent();
                if (rtn.isHighLighted()) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public void setFromA(boolean fromA) {
        this.m_fromA = fromA;
    }

    private boolean isDisplay(ResultSet rs, List<String> ignorThese) {
        boolean result = DisplayProps.isDisplay((ResultSet)rs);
        if (result) {
            String name = rs.getName();
            if (ignorThese != null && ignorThese.contains(name)) {
                result = false;
            } else if (("LEAF".equals(rs.getType()) || "MAP".equals(rs.getType()) && rs.getAllObjectsMap().size() == 0) && s_ignor.contains(name)) {
                result = false;
            } else if ("MAP".equals(rs.getType())) {
                Map children = rs.getAllObjectsMap();
                if (children.isEmpty() && rs.a() == null && rs.b() == null && DisplayProps.getAVal((ResultSet)rs) == null && DisplayProps.getBVal((ResultSet)rs) == null) {
                    result = false;
                }
                for (String cname : children.keySet()) {
                    ResultSet rattr = (ResultSet)children.get(cname);
                    result = this.isDisplay(rattr, ignorThese);
                    if (!result) {
                        continue;
                    }
                    break;
                }
            } else if ("LIST".equals(rs.getType())) {
                List children = rs.getAllObjectsList();
                Iterator i = children.iterator();
                while (i.hasNext()) {
                    result = this.isDisplay((ResultSet)i.next(), ignorThese);
                    if (!result) {
                        continue;
                    }
                    break;
                }
            }
            DisplayProps.setDisplay((ResultSet)rs, (boolean)result);
        }
        return result;
    }

    private boolean isDisplayedChildChanged(ResultSet rs) {
        boolean result;
        block10: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                result = false;
                                if (rs.isSame()) break block10;
                                if (!"SQLQuery".equals(rs.getName())) break block11;
                                if ("LEAF".equals(rs.getType())) {
                                    result = rs.isSame() ^ true;
                                } else {
                                    Map nso = rs.getNotSameObjectMap();
                                    result = nso.keySet().contains("queryString");
                                }
                                break block10;
                            }
                            if (!"MAP".equals(rs.getType()) || !"columnExpressions".equals(rs.getName())) break block12;
                            String aval = rs.a() instanceof IndexObject ? ((IndexObject)rs.a()).getSQLText() : null;
                            String bval = rs.b() instanceof IndexObject ? ((IndexObject)rs.b()).getSQLText() : null;
                            result = ModelUtil.areDifferent((Object)aval, (Object)bval);
                            break block10;
                        }
                        if (!"LEAF".equals(rs.getType())) break block13;
                        String name = rs.getName();
                        result = (s_ignor.contains(name) || rs.isSame()) ^ true;
                        break block10;
                    }
                    if (!this.isViewColumn(rs)) break block14;
                    result = false;
                    break block10;
                }
                if (!"MAP".equals(rs.getType())) break block15;
                Map children = rs.getAllObjectsMap();
                if (children.size() == 0) {
                    String name = rs.getName();
                    result = (s_ignor.contains(name) || rs.isSame()) ^ true;
                } else {
                    for (String name : children.keySet()) {
                        ResultSet rattr = (ResultSet)children.get(name);
                        result = this.isDisplayedChildChanged(rattr);
                        if (!result) {
                            continue;
                        }
                        break block10;
                    }
                }
                break block10;
            }
            if (!"LIST".equals(rs.getType())) break block10;
            if (rs.isChildListReorder()) {
                result = true;
            } else {
                List children = rs.getAllObjectsList();
                Iterator i = children.iterator();
                while (i.hasNext()) {
                    result = this.isDisplayedChildChanged((ResultSet)i.next());
                    if (!result) {
                        continue;
                    }
                    break;
                }
            }
        }
        return result;
    }

    private boolean isViewColumn(ResultSet rs) {
        boolean result = false;
        if (rs.a() instanceof Column || rs.b() instanceof Column) {
            Column c = (Column)rs.a();
            if (c == null) {
                c = (Column)rs.b();
            }
            if (c.getRelation() instanceof View) {
                result = true;
            }
        }
        return result;
    }

    class ResultSetTransferable
    implements Transferable {
        private ResultSet m_rs;

        ResultSetTransferable(ResultSet rs) {
            this.m_rs = rs;
        }

        public ResultSet getResultSet() {
            return this.m_rs;
        }

        public Object getTransferData(DataFlavor flavor) {
            return this.m_rs;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{TRANSFERABLE_FLAVOR};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor == TRANSFERABLE_FLAVOR;
        }
    }
}

