/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.reconcile;

import java.awt.BorderLayout;
import java.awt.Container;
import java.util.HashMap;
import javax.swing.tree.TreeNode;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.db.transfer.TransferDescriptor;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.DialogCallbacks;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.db.transfer.TransferArb;
import oracle.ideimpl.db.transfer.TransferUtil;
import oracle.ideimpl.db.transfer.reconcile.ReconcileCompareView;
import oracle.ideimpl.db.transfer.reconcile.ReconcileTreeNode;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.ResultSet;

public class ReconcileTextPanel
extends DefaultTraversablePanel {
    public static final String HELP_ID = "f1_offdbgeneratereconcile_html";
    public static final String MODIFIED_OBJECT_KEY = "MODIFIED_OBJECT_KEY";
    private WizardCallbacks m_wcallbacks;
    private DialogCallbacks m_dcallbacks;
    private TransferDescriptor m_td;
    private BorderLayout layCenter;
    private ReconcileCompareView m_compareViewer;
    private HashMap attrType;

    private void $init$() {
        this.layCenter = new BorderLayout();
        this.m_compareViewer = new ReconcileCompareView();
        this.attrType = new HashMap();
        this.attrType.put("SQLQuery", ".sql");
        this.attrType.put("source", ".plsql");
        this.attrType.put("bodySource", ".plsql");
    }

    public ReconcileTextPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setHelpID(HELP_ID);
        this.setLayout(this.layCenter);
    }

    public String getHeaderTitle() {
        return TransferArb.getString(187);
    }

    public String getHeaderDescription() {
        return TransferArb.getString(116);
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_td = (TransferDescriptor)((Object)dataContext.get("oracle.ideimpl.db.transfer.model.TransferDescriptor.KEY"));
        ReconcileTreeNode rtn = (ReconcileTreeNode)dataContext.find("OriginalObject");
        this.init(rtn);
        this.m_wcallbacks = dataContext.getWizardCallbacks();
        if (this.m_wcallbacks == null) {
            this.m_dcallbacks = dataContext.getDialogCallbacks();
            if (this.m_dcallbacks != null) {
                this.m_dcallbacks.enableOKButton(true);
            }
        } else {
            this.m_dcallbacks = null;
            this.m_wcallbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commit(dataContext, dataContext.getDirection() != 2);
    }

    private void init(ReconcileTreeNode rtn) {
        String bval;
        String leftTitle = TransferUtil.getTitle(true, this.m_td);
        String rightTitle = TransferUtil.getTitle(false, this.m_td);
        this.m_compareViewer.setTitles(StringUtils.stripMnemonic((String)leftTitle), StringUtils.stripMnemonic((String)rightTitle));
        TreeNode[] path = rtn.getPath();
        StringBuffer fullname = new StringBuffer();
        int i = 0;
        while (i < path.length - 1) {
            if (path[i] instanceof ReconcileTreeNode) {
                if (fullname.length() != 0) {
                    fullname.append(".");
                }
                fullname.append(((ReconcileTreeNode)path[i]).getResultSet().getName());
            }
            ++i;
        }
        ResultSet rs = rtn.getResultSet();
        String name = rs.getName();
        String type = ".txt";
        if (this.attrType.containsKey(name)) {
            type = (String)this.attrType.get(name);
        }
        this.m_compareViewer.setType(type);
        String aval = DisplayProps.getAVal((ResultSet)rs);
        if (aval == null) {
            aval = (String)rs.a();
        }
        if ((bval = DisplayProps.getBVal((ResultSet)rs)) == null) {
            bval = (String)rs.b();
        }
        String left = rtn.isFromA() ? aval : bval;
        String right = rtn.isFromA() ? bval : aval;
        this.m_compareViewer.compare(left, right, (Container)((Object)this));
    }

    private void commit(TraversableContext dataContext, boolean forward) throws TraversalException {
        if (this.m_compareViewer.isModified()) {
            ReconcileTreeNode rtn = (ReconcileTreeNode)dataContext.find("OriginalObject");
            String newA = this.m_compareViewer.getRight();
            dataContext.put(MODIFIED_OBJECT_KEY, (Object)newA);
        }
    }
}

