/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.transfer.reconcile;

import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class ReconcileTreeModel
extends DefaultTreeModel {
    private JTree m_tree;
    private DefaultMutableTreeNode m_defaultMutableTreeNode;

    public ReconcileTreeModel(TreeNode top) {
        super(top);
    }

    public JTree getJTree() {
        return this.m_tree;
    }

    public void myNodeChanged(Object object) {
        if (object != null) {
            Object parent = this.getParent(object);
            if (parent != null) {
                int anindex = this.getIndexOfChild(parent, object);
                if (anindex >= 0) {
                    int[] cindexes = new int[]{anindex};
                    this.nodesChanged(parent, cindexes);
                }
            } else if (this.getRoot() == object) {
                this.nodesChanged(object, null);
            }
        }
    }

    public void nodesChanged(Object node, int[] childIndices) {
        if (node != null && childIndices != null) {
            int cc = childIndices.length;
            if (cc > 0) {
                Object[] children = new Object[cc];
                int i = 0;
                while (i < cc) {
                    children[i] = this.getChild(node, childIndices[i]);
                    ++i;
                }
                this.fireTreeNodesChanged(this, this.getPathToRoot(node), childIndices, children);
            } else if (node == this.getRoot()) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(node), null, null);
            }
        }
    }

    public void saveDefaultMutableTreeNode(DefaultMutableTreeNode dmtNode) {
        this.m_defaultMutableTreeNode = dmtNode;
    }

    public DefaultMutableTreeNode getDefaultMutableTreeNode() {
        return this.m_defaultMutableTreeNode;
    }

    protected Object[] getPathToRoot(Object node) {
        ArrayList<Object> path = new ArrayList<Object>();
        if (node != null) {
            path.add(node);
            Object parent = this.getParent(node);
            while (parent != null) {
                path.add(0, parent);
                parent = this.getParent(parent);
            }
        }
        return path.toArray();
    }

    protected Object getParent(Object node) {
        TreeNode parent = null;
        if (node instanceof DefaultMutableTreeNode) {
            parent = ((DefaultMutableTreeNode)node).getParent();
        }
        return parent;
    }
}

